jQuery(document).ready(function($) {

  // Instance the tour
  var tour = new Tour({
    steps: [
    {
      orphan: true,
      title: "Create a New Condition Set",
      content: "This tour will walk you through the steps of creating a condition set.",
    },
    {
      element: "#edit-admin-title",
      title: "Add Label",
      content: "Give your condition set a name",
      placement: "bottom",
    },
    {
      element: "#edit-description",
      title: "Add a Description (Optional)",
      content: "You can optionally add a description here, which will be displayed on the condition set overview page",
      placement: "bottom",
    },
    {
      element: "#Event-div",
      title: "Add an Event",
      content: "Use the Add Event selectbox to add one or more events to respond to. Note that when there is more than one event enabled, <i>all</i> enabled events must be detected in the system before this condition set is evaluated.",
      placement: "top",
    },
    {
      element: "#Condition-div",
      title: "Add a Condition (Optional)",
      content: "Use the Add Conditon selectbox to add one or more conditions which must be met for this condition set. Note that no conditions are required - nor is there a limit to how many may be active. When more than one condition is enabled, <i>all</i> enabled conditions must be met for this condition set to be executed.",
      placement: "top",
    },
    {
      element: "#Action-div",
      title: "Add an Action",
      content: "Use the Add Action selectbox to add one or more actions which will be performed when this condition set is evaluated. Note that if Add Action is unavailable, no modules which provide BCubed action plugins are currently active in the system - you must enable one or more of the included submodules.",
      placement: "top",
    },
  ],
  storage: false,
  });

  // Initialize the tour
  tour.init();

  // Start the tour
  tour.start();
});
