<?php

/**
 * @file
 * Define this Export UI plugin.
 */

$plugin = array(
// As defined in hook_schema().
  'schema' => 'bcubed_condition_set',
// Define a permission users must have to access these pages.
  'access' => 'administer bcubed',

  // Define the menu item.
  'menu' => array(
    'menu item' => 'condition_set',
    'menu prefix' => 'admin/config/system/bcubed',
    'menu title' => 'Condition Sets',
    'menu description' => 'Administer BCubed Condition Sets.',
  ),

  // Define user interface texts.
  'title singular' => t('condition set'),
  'title plural' => t('condition sets'),
  'title singular proper' => t('BCubed Condition Set'),
  'title plural proper' => t('BCubed Condition Sets'),

  // Define the names of the functions that provide the add/edit forms.
  'form' => array(
    'settings' => 'bcubed_condition_set_form',
  ),

  // Specify handler class.
  'handler' => array(
    'class' => 'bcubed_export_condition_set',
    'parent' => 'ctools_export_ui',
  ),
);

/**
 * Define the preset add/edit form.
 */
function bcubed_condition_set_form(&$form, &$form_state) {
  $condition_set = $form_state['item'];

  // Add configuration interface.
  $form['description'] = array(
    '#type' => 'textarea',
    '#title' => t('Description'),
    '#description' => t('Brief description of this condition set, shown in the condition sets overview.'),
    '#default_value' => $condition_set->description,
  );

  $form['plugins'] = array(
    '#type' => 'container',
    '#prefix' => '<div id="bcubed-plugins-div">',
    '#suffix' => '</div>',
    '#tree' => TRUE,
  );
}
