<?php

declare(strict_types=1);

namespace Drupal\bcvb;

use Drupal\bcvb\Entity\BuildableEntityInterface;
use Drupal\Core\Cache\CacheableMetadata;
use Drupal\Core\Entity\EntityInterface;

/**
 * Trait for view builders that want to override getBuildDefaults.
 *
 * This trait can be used in custom view builders for entities which do not
 * use core's EntityViewBuilder. E.g NodeViewBuilder or BlockContentViewBuilder.
 */
trait BcvbViewBuilderTrait {

  /**
   * {@inheritdoc}
   */
  public function getBuildDefaults(EntityInterface $entity, $view_mode) {
    $build = parent::getBuildDefaults($entity, $view_mode);

    if (!$entity instanceof BuildableEntityInterface || !$entity->shouldBuild($view_mode)) {
      return $build;
    }

    $cache = CacheableMetadata::createFromRenderArray($build);
    $build = $entity->build($view_mode);
    $cache->merge(CacheableMetadata::createFromRenderArray($build))
      ->applyTo($build);

    return $build;
  }

}
