<?php

declare(strict_types=1);

namespace Drupal\bcvb_example\Pinto;

use Drupal\bcvb_example\Entity\BlockContent\Accordion as AccordionBlockEntity;
use Drupal\Core\Cache\CacheableDependencyInterface;
use Pinto\Attribute\ObjectType\Slots;

#[Slots(
  bindPromotedProperties: TRUE,
)]
final class Accordion implements CacheableDependencyInterface {

  use BcvbExampleObjectTrait;

  public function __construct(
    public readonly string $title,
    public readonly string $content,
  ) {}

  /**
   * Create a theme object from an accordion.
   */
  public static function createFromAccordionBlock(AccordionBlockEntity $accordion): static {
    return new static(
      (string) $accordion->getTitle(),
      (string) $accordion->getContent(),
    );
  }

}
