<?php

declare(strict_types=1);

namespace Drupal\bcvb_example\Pinto;

use Pinto\Attribute\Definition;
use Pinto\List\ObjectListInterface;
use Pinto\List\ObjectListTrait;

enum BcvbExampleList: string implements ObjectListInterface {

  use ObjectListTrait;
  #[Definition(Accordion::class)]
  #[BcvbModuleTemplate('bcvb_example')]
  case Accordion = 'bcvb_example_accordion';

  /**
   * {@inheritdoc}
   */
  public function templateDirectory(): string {
    $reflection = new \ReflectionEnumUnitCase($this::class, $this->name);
    /** @var \Drupal\bcvb_example\Pinto\BcvbModuleTemplate $definition */
    $definition = ($reflection->getAttributes(BcvbModuleTemplate::class)[0] ?? NULL)?->newInstance() ?? throw new \LogicException('All component cases must have a `' . BcvbModuleTemplate::class . '`.');
    return \sprintf('@%s/templates', $definition->templateModule);
  }

  /**
   * {@inheritdoc}
   */
  public function cssDirectory(): string {
    return '/libraries/foo';
  }

  /**
   * {@inheritdoc}
   */
  public function jsDirectory(): string {
    return '/libraries/foo';
  }

}
