<?php

declare(strict_types=1);

namespace Drupal\Tests\bcvb\Functional;

use Drupal\bcvb\Handler\BcvbViewBuilder;
use Drupal\bcvb_example\Entity\BlockContent\Accordion;
use Drupal\Tests\BrowserTestBase;
use Symfony\Component\DomCrawler\Crawler;

/**
 * Tests BCVB rendering with Pinto.
 *
 * @group bcvb
 */
final class BcvbPintoTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'bcvb_example',
    'bcvb',
    'pinto',
    'block_content',
    'bca',
  ];

  /**
   * Tests entity rendering via BCVB and Pinto.
   */
  public function testAccordionBlockRendering(): void {
    $title = 'Test accordion title';
    $content = 'Test accordion content';
    $accordionBlock = Accordion::create()
      ->setTitle($title)
      ->setContent($content);
    $accordionBlock->save();

    $blockContentViewBuilder = \Drupal::entityTypeManager()->getViewBuilder(Accordion::ENTITY_TYPE);
    self::assertNotInstanceOf(BcvbViewBuilder::class, $blockContentViewBuilder);
    $build = $blockContentViewBuilder->view($accordionBlock);
    self::assertArrayNotHasKey('#theme', $build);

    // Enable BCVB for block_content.
    \Drupal::configFactory()->getEditable('bcvb.settings')->set('entity_types', [
      'block_content' => 'block_content',
    ])->save();

    // Test invoked Pinto object via BCVB.
    $blockContentViewBuilder = \Drupal::entityTypeManager()->getViewBuilder(Accordion::ENTITY_TYPE);
    self::assertInstanceOf(BcvbViewBuilder::class, $blockContentViewBuilder);
    $build = $blockContentViewBuilder->view($accordionBlock);
    self::assertEquals('bcvb_example_accordion', $build['#theme']);
    self::assertEquals($title, $build['#title']);
    self::assertEquals($content, $build['#content']);

    // Test rendered output.
    $renderer = \Drupal::service('renderer');
    $output = $renderer->renderInIsolation($build);
    $crawler = new Crawler((string) $output);
    self::assertCount(1, $crawler->filter('.accordion'));
    self::assertEquals($title, $crawler->filter('.accordion__title')->first()->text());
    self::assertEquals($content, $crawler->filter('.accordion__body')->first()->text());
  }

}
