# Bundle Class View Builder

BCVB provides a simple way to bypass Drupal core's normal entity rendering, giving developers full control to render an entity via its bundle class.

It allows bundle classes to render content via a `build` function in their respective class.

## Setup

First, configure which entity types you want to use bundle class rendering on via the module settings page.

Once configured, any bundle class that implements `Drupal\bcvb\Entity\BuildableEntityInterface` that returns TRUE from the `shouldBuild` function
will render via the `build` function.

### Recommended modules

1. The [BCA](https://www.drupal.org/project/bca) module provides attribute based discovery for Bundle classes
1. The [Pinto](https://www.drupal.org/project/pinto) module provides Object Oriented based theming, allowing bundle classes to directly render a theme object from their build.

Check out the [blog post on Pinto](https://www.previousnext.com.au/blog/next-level-theming-pinto) for more information.

Examples can be found in the bcvb_example test module.
