<?php

declare(strict_types=1);

namespace Drupal\bcvb\Entity;

/**
 * Interface for entities which override the view builder.
 */
interface BuildableEntityInterface {

  /**
   * Default method to build an entity.
   *
   * Must return a render array.
   */
  public function build(string $viewMode): array;

  /**
   * Determine if the entity should be built for the given view mode.
   */
  public function shouldBuild(string $viewMode): bool;

}
