<?php

declare(strict_types=1);

namespace Drupal\bcvb\EventSubscriber;

use Drupal\Core\Config\ConfigCrudEvent;
use Drupal\Core\Config\ConfigEvents;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Listens to the config save event for bcvb.settings.
 */
class BcvbConfigSubscriber implements EventSubscriberInterface {

  /**
   * Constructs the BcvbConfigSubscriber.
   */
  public function __construct(
    protected EntityTypeManagerInterface $entityTypeManager,
  ) {
  }

  /**
   * Clear entity type definitions when bcvb.settings:entity_types change.
   *
   * @param \Drupal\Core\Config\ConfigCrudEvent $event
   *   The ConfigCrudEvent to process.
   */
  public function onSave(ConfigCrudEvent $event): void {
    if ($event->getConfig()->getName() !== 'bcvb.settings' || !$event->isChanged('entity_types')) {
      return;
    }

    $this->entityTypeManager->clearCachedDefinitions();
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    return [
      ConfigEvents::SAVE => [
        ['onSave'],
      ],
    ];
  }

}
