<?php

declare(strict_types=1);

namespace Drupal\bcvb_example\Entity\BlockContent;

use Drupal\bca\Attribute\Bundle;
use Drupal\bcvb\Entity\BuildableEntityInterface;
use Drupal\bcvb_example\Pinto\Accordion as PintoAccordion;
use Drupal\block_content\Entity\BlockContent;

#[Bundle(entityType: self::ENTITY_TYPE, bundle: self::BUNDLE)]
class Accordion extends BlockContent implements BuildableEntityInterface {

  public const string ENTITY_TYPE = 'block_content';
  public const string BUNDLE = 'accordion';

  public function getTitle(): ?string {
    return $this->get('title')->value;
  }

  public function setTitle(?string $title): static {
    return $this->set('title', $title);
  }

  public function getContent(): ?string {
    return $this->get('content')->value;
  }

  public function setContent(?string $content): static {
    return $this->set('content', $content);
  }

  /**
   * {@inheritdoc}
   */
  public function shouldBuild(string $viewMode): bool {
    return TRUE;
  }

  /**
   * {@inheritdoc}
   */
  public function build(string $viewMode): array {
    return PintoAccordion::createFromAccordionBlock($this)();
  }

}
