<?php

declare(strict_types=1);

namespace Drupal\bcvb_example\Pinto;

use Drupal\Core\Cache\CacheableDependencyInterface;
use Drupal\Core\Cache\CacheableMetadata;
use Drupal\Core\Cache\RefinableCacheableDependencyTrait;
use Drupal\pinto\Object\DrupalObjectTrait;
use Pinto\Slots\Build;

trait BcvbExampleObjectTrait {

  use DrupalObjectTrait;
  use RefinableCacheableDependencyTrait;

  /**
   * Renders the theme object.
   *
   * __invoke is a PHP magic method that is called when calling an object like
   * a function.
   *
   * @code
   *   $accordion = Accordion::createFromAccordionBlock($block);
   *   $build = $accordion();
   * @endcode
   */
  public function __invoke(): mixed {
    $built = $this->pintoBuild(function (mixed $build): mixed {
      if (!$this instanceof CacheableDependencyInterface) {
        throw new \LogicException(static::class . ' must implement CacheableDependencyInterface');
      }
      return $this->build($build);
    });
    (new CacheableMetadata())->addCacheableDependency($this)->applyTo($built);
    return $built;
  }

  /**
   * By default, an object's slots should be automatically bound.
   */
  protected function build(Build $build): Build {
    return $build;
  }

}
