<?php

declare(strict_types=1);

namespace Drupal\be_alert\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure BE-Alert settings for this site.
 */
final class GlobalSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'be_alert_global_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['be_alert.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $form['sandbox'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Sandbox'),
      '#tree' => TRUE,
    ];
    $form['sandbox']['api_key'] = [
      '#type' => 'textfield',
      '#title' => $this->t('API Key'),
      '#default_value' => $this->config('be_alert.settings')->get('sandbox.api_key'),
    ];
    $form['production'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Production'),
      '#tree' => TRUE,
    ];
    $form['production']['api_key'] = [
      '#type' => 'textfield',
      '#title' => $this->t('API Key'),
      '#default_value' => $this->config('be_alert.settings')->get('production.api_key'),
    ];
    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $this->config('be_alert.settings')
      ->set('sandbox.api_key', $form_state->getValue('sandbox')['api_key'])
      ->set('production.api_key', $form_state->getValue('production')['api_key'])
      ->save();
    parent::submitForm($form, $form_state);
  }

}
