<?php

namespace Drupal\be_ixf_drupal\Factory;

/* Can comment out if you have modified merge-plugin in the top level composer.json */
include_once __DIR__ . '../../../vendor/autoload.php';

use GuzzleHttp\ClientInterface;
use BrightEdge\BEIXFClient;

/**
 * Class BrightEdgeFactory.
 */
class BrightEdgeFactory {

  /**
   * {@inheritdoc}
   */
  public static function createRequest($config, ClientInterface $client) {
    $be_config = $config->get('be_ixf_drupal.settings');

    $be_ixf_config = [
      BEIXFClient::$CAPSULE_MODE_CONFIG => $be_config->get('capsule_mode'),
      BEIXFClient::$ACCOUNT_ID_CONFIG => $be_config->get('account_id'),
      BEIXFClient::$CANONICAL_HOST_CONFIG => $be_config->get('canonical_host'),
    ];
    $api_endpoint = $be_config->get('api_endpoint');
    if (!empty($api_endpoint)) {
      $be_ixf_config[BEIXFClient::$API_ENDPOINT_CONFIG] = $api_endpoint;
    }
    $be_ixf_config['defer.redirect'] = "true";
    return new BrightEdgeIXFPHPClient($be_ixf_config);
  }

}

/**
 * {@inheritdoc}
 */
class BrightEdgeIXFPHPClient {
  // Subscriber and block instaniate different instances.
  // From factory so we use static array here.

  /**
   * Static variable $sdkClientArray.
   *
   * @var sdkClientArray
   */
  protected static $sdkClientArray = [];

  /**
   * Variable $sdkConfig.
   *
   * @var sdkConfig
   */
  protected $sdkConfig;

  /**
   * Constructs a new BrightEdgeIXFPHPClient.
   *
   * @param object $sdkConfig
   *   The config manager.
   */
  public function __construct($sdkConfig) {
    $this->sdkConfig = $sdkConfig;
  }

  /**
   * {@inheritdoc}
   */
  public function getClient() {
   //$url = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
    /**** custom code start ****/
    $config = \Drupal::config('be_ixf_drupal.settings');
    $protocol = $config->get('protocol');

    $url = $protocol. "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";

   /**** custom code end ****/
    if (array_key_exists($url, self::$sdkClientArray)) {
      $be_ixf_client = self::$sdkClientArray[$url];
    }
    else {
      self::$sdkClientArray = [];
      $be_ixf_client = new BEIXFClient($this->sdkConfig);
      self::$sdkClientArray[$url] = $be_ixf_client;
    }

    return $be_ixf_client;
  }

}
