<?php

namespace Drupal\brightedge\Service;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Database\Connection;
use Drupal\Core\Language\LanguageManagerInterface;

/**
 * Provides services related to the BrightEdge integration.
 *
 * Handles configurations, database management, and language settings
 * for the BrightEdge integration within Drupal.
 */
class BrightEdgeService implements BrightEdgeServiceInterface {

  /**
   * The configuration settings for BrightEdge.
   *
   * @var \Drupal\Core\Config\Config
   */
  protected $config;

  /**
   * The database connection object.
   *
   * @var \Drupal\Core\Database\Connection
   */
  protected $database;

  /**
   * The language manager service.
   *
   * @var \Drupal\Core\Language\LanguageManagerInterface
   */
  protected $languageManager;

  /**
   * Constructs a new BrightEdgeService object.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config
   *   The configuration factory interface.
   * @param \Drupal\Core\Database\Connection $database
   *   The database connection.
   * @param \Drupal\Core\Language\LanguageManagerInterface $languageManager
   *   The language manager service.
   */
  public function __construct(ConfigFactoryInterface $config, Connection $database, LanguageManagerInterface $languageManager) {
    $this->config = $config->get('be_ixf_drupal.settings');
    $this->languageConfig = $config->get('be_ixf_drupal.locales');
    $this->database = $database;
    $this->languageManager = $languageManager;
  }

}
