<?php

/**
 * @file
 * PHP part of performance.
 */

/**
 * Check availability of Page caching.
 */
function bs_performance_cache_caching() {
  return variable_get('cache');
}

/**
 * Module File cache should be disabled.
 */
function bs_performance_cache_file_cache() {
  return !module_exists('filecache');
}

/**
 * Check minimum cache lifetime.
 */
function bs_performance_cache_min_lifetime() {
  return variable_get('cache_lifetime', 0) > 0;
}

/**
 * Check cache max age.
 */
function bs_performance_cache_max_age() {
  return variable_get('page_cache_maximum_age', 0) >= 300;
}

/**
 * Check availability of Memcache or Redis.
 */
function bs_performance_cache_memcache_redis() {
  return module_exists('memcache') || module_exists('redis') || module_exists('memcache_storage');
}
