<?php

/**
 * @file
 * Page structure part of SEO.
 */

/**
 * Check availability of Page Title.
 */
function bs_seo_page_structure_page_title() {
  return module_exists('page_title');
}

/**
 * Check availability of Redirect.
 */
function bs_seo_page_structure_redirect() {
  return module_exists('redirect');
}

/**
 * Check availability of Clean URLs.
 */
function bs_seo_page_structure_clean_urls() {
  return variable_get('clean_url');
}

/**
 * Check availability of Global Redirect.
 */
function bs_seo_page_structure_global_redirect() {
  return module_exists('globalredirect');
}

/**
 * Check availability of Pathauto.
 */
function bs_seo_page_structure_pathauto() {
  return module_exists('pathauto');
}

/**
 * Check availability of Google Analytics.
 */
function bs_seo_page_structure_gag() {
  return module_exists('googleanalytics') && drupal_strlen(variable_get('googleanalytics_account')) > 3;
}

/**
 * Check availability of Metatag.
 */
function bs_seo_page_structure_metatag() {
  return module_exists('metatag');
}
