<?php

declare(strict_types=1);

namespace Drupal\bean_migrate;

use Drupal\field\Plugin\migrate\source\d7\Field;
use Drupal\field\Plugin\migrate\source\d7\FieldInstance;
use Drupal\field\Plugin\migrate\source\d7\FieldLabelDescriptionTranslation;
use Drupal\migrate\Plugin\MigrateSourceInterface;
use Drupal\migrate\Plugin\MigrationInterface;
use Drupal\migrate\Row;

/**
 * Prepares migration rows to make them compatible with Bean migrations.
 */
class MigrationRowPreparer {

  /**
   * Maps bean fields and view mode migration source values to block_content.
   *
   * @param \Drupal\migrate\Row $row
   *   The row being imported.
   * @param \Drupal\migrate\Plugin\MigrateSourceInterface $source
   *   The migration source plugin instance of the migration the row belongs to.
   * @param \Drupal\migrate\Plugin\MigrationInterface $migration
   *   The current migration.
   *
   * @throws \Exception
   */
  public static function mapBeanToBlockContent(Row $row, MigrateSourceInterface $source, MigrationInterface $migration) {
    if (
      !($source instanceof Field) &&
      !($source instanceof FieldInstance) &&
      !($source instanceof FieldLabelDescriptionTranslation)
    ) {
      // Not a field related source.
      return;
    }

    if ($row->getSourceProperty('entity_type') !== 'bean') {
      // Not a bean related migration row.
      return;
    }

    $row->setSourceProperty('entity_type', 'block_content');

    if (
      !is_string($row->getSourceProperty('bundle')) ||
      empty($migration->getProcess()['bundle'])
    ) {
      // Bundle property isn't present or isn't used.
      return;
    }

    $migration->setProcessOfProperty('bundle', [
      [
        'plugin' => 'migration_lookup',
        'migration' => 'bean_type',
        'no_stub' => TRUE,
        'source' => 'bundle',
      ],
      [
        'plugin' => 'skip_on_empty',
        'method' => 'row',
      ],
    ]);
  }

}
