<?php

namespace Drupal\bean_migrate\Plugin\migrate;

use Drupal\bean_migrate\Plugin\migrate\source\BeanBlockPlacement;
use Drupal\Component\Plugin\Derivative\DeriverBase;
use Drupal\Core\Database\DatabaseExceptionWrapper;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\migrate\Exception\RequirementsException;
use Drupal\migrate\Plugin\MigrationDeriverTrait;
use Drupal\migrate\Row;

/**
 * Deriver class for Bean block placement migration.
 */
class BeanBlockDeriver extends DeriverBase {

  use BeanDeriverTrait;
  use MigrationDeriverTrait;
  use StringTranslationTrait;

  /**
   * Array of the bean migration plugin base IDs which are derived.
   *
   * @const string[]
   */
  const MIGRATION_BASE_IDS_TO_DERIVE = [
    'bean',
  ];

  /**
   * {@inheritdoc}
   */
  public function getDerivativeDefinitions($base_plugin_definition) {
    $source = static::getSourcePlugin($base_plugin_definition['source']['plugin']);
    if (!($source instanceof BeanBlockPlacement)) {
      throw new \LogicException(sprintf('"%s" should only used for Bean block placement migrations. The current migration definition\'s source plugin is a "%s" instance. The definition\s base ID: "%s".', get_class($this), get_class($source), $base_plugin_definition['id']));
    }
    try {
      $source->checkRequirements();
    }
    catch (RequirementsException $e) {
      return $this->derivatives;
    }

    try {
      foreach ($source as $row) {
        assert($row instanceof Row);
        $type = $row->getSourceProperty('type');
        if (array_key_exists($type, $this->derivatives)) {
          continue;
        }

        $derivative_id = $type;
        $derivative_definition = $base_plugin_definition;
        $derivative_definition['source']['type'] = $type;
        // Re-using the string used in other migration derivers.
        // @see \Drupal\node\Plugin\migrate\D7NodeDeriver
        $derivative_definition['label'] = $this->t('@label (@type)', [
          '@label' => $derivative_definition['label'],
          '@type' => $row->getSourceProperty('label') ?? $type,
        ]);

        // Finalize migration dependencies.
        static::finalizeMigrationDependencies($derivative_definition, $type);

        $this->derivatives[$derivative_id] = $derivative_definition;
      }
    }
    catch (DatabaseExceptionWrapper $e) {
    }

    return $this->derivatives;
  }

}
