<?php

namespace Drupal\bean_migrate\Plugin\migrate\source;

use Drupal\block\Plugin\migrate\source\Block;

/**
 * Migration source plugin for Bean block placements.
 *
 * @MigrateSource(
 *   id = "bean_block_placement",
 *   source_module = "bean"
 * )
 */
class BeanBlockPlacement extends Block {

  /**
   * {@inheritdoc}
   */
  public function query() {
    $query = parent::query();
    $query->condition('b.module', 'bean');
    $query->condition('b.status', 1);
    $query->join('bean', 'bean', 'b.delta = bean.delta');
    $query->addField('bean', 'bid', 'bean_id');
    $query->addField('bean', 'vid', 'bean_revision_id');
    $query->addField('bean', 'title', 'bean_title');
    $query->addField('bean', 'type');

    if ($type = $this->configuration['type'] ?? NULL) {
      $query->condition('bean.type', $type);
    }

    return $query;
  }

  /**
   * {@inheritdoc}
   */
  public function getIds() {
    $ids = parent::getIds();
    $ids['delta']['alias'] = 'b';
    return $ids;
  }

  /**
   * {@inheritdoc}
   */
  public function fields() {
    return parent::fields() + [
      'bean_id' => $this->t('The ID of the bean entity what this block config displays.'),
      'bean_revision_id' => $this->t('The revision ID of the bean entity what this block config displays.'),
      'bean_title' => $this->t('The title of the bean entity. If the block title is empty, then this is the title of the block.'),
      'type' => $this->t('The type (bundle) of the bean entity what this block config displays.'),
    ];
  }

}
