<?php

namespace Drupal\bean_migrate\Plugin\migrate\source;

use Drupal\migrate_drupal\Plugin\migrate\source\DrupalSqlBase;

/**
 * Migration source plugin for Bean types.
 *
 * @MigrateSource(
 *   id = "bean_type",
 *   source_module = "bean"
 * )
 */
class BeanType extends DrupalSqlBase {

  /**
   * {@inheritdoc}
   */
  public function query() {
    $bean_type_exists = $this->getDatabase()->schema()->tableExists('bean_type');
    $query = $this->select('bean')
      ->fields('bean', ['type'])
      ->distinct(TRUE);
    $query->addField('bean', 'type', 'id');

    // We might have an admin label and a description, but nothing guarantees
    // that every type has a record in the "bean_type" table.
    if ($bean_type_exists) {
      $query->leftJoin('bean_type', 'bt', 'bt.name = bean.type');
      $query->fields('bt', ['label', 'description']);
    }

    if ($bean_type = $this->configuration['type'] ?? NULL) {
      $query->condition('bean.type', $bean_type);
    }

    return $query;
  }

  /**
   * {@inheritdoc}
   */
  public function fields() {
    return [
      'type' => $this->t('The type (machine name) of the bean type.'),
      'label' => $this->t('Label of the bean type, if available.'),
      'description' => $this->t('The description of the bean type, if available.'),
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getIds() {
    return [
      'type' => [
        'type' => 'string',
        'max_length' => 32,
      ],
    ];
  }

}
