<?php

namespace Drupal\Tests\bean_migrate\Functional;

use Drupal\Tests\bean_migrate\Traits\BeanMigrateAssertionsTrait;

/**
 * Tests Bean Migrate and core migrations compatibility.
 *
 * @group bean_migrate
 */
class BeanUiMigrationTest extends BeanUiMigrationTestBase {

  use BeanMigrateAssertionsTrait;

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'bean_migrate',
    'migrate_drupal_ui',
  ];

  /**
   * {@inheritdoc}
   */
  protected function getSourceBasePath() {
    return drupal_get_path('module', 'bean_migrate') . '/tests/fixtures/files';
  }

  /**
   * {@inheritdoc}
   */
  public function getDatabaseFixtureFilePath() {
    return drupal_get_path('module', 'bean_migrate') . '/tests/fixtures/drupal7_bean.php';
  }

  /**
   * Tests Bean Migrate and core migrations compatibility.
   */
  public function testMigrationsWithBean() {
    $this->loadFixture($this->getDatabaseFixtureFilePath());

    $this->executeMigrationsWithUi();

    // We have to reset all the static caches after migration to ensure entities
    // are loadable.
    $this->resetAll();

    $this->performBeanMigrationAssertions();
  }

}
