<?php

namespace Drupal\Tests\bean_migrate\Kernel\Plugin\migrate\source;

use Drupal\Tests\migrate\Kernel\MigrateSqlSourceTestBase;

/**
 * Tests the bean migrate source plugin.
 *
 * @covers \Drupal\bean_migrate\Plugin\migrate\source\Bean
 * @group bean_migrate
 */
class BeanTest extends MigrateSqlSourceTestBase {

  /**
   * {@inheritdoc}
   *
   * @todo This should be changed to "protected" after Drupal core 8.x security
   *   support ends.
   * @see https://www.drupal.org/node/2909426
   */
  public static $modules = [
    'bean_migrate',
    'migrate_drupal',
  ];

  /**
   * {@inheritdoc}
   */
  public function providerSource() {
    $simple_plus_complicated = static::BEAN_SIMPLE_TABLES;
    foreach (static::BEAN_COMPLICATED_TABLES as $table_name => $records) {
      $simple_plus_complicated[$table_name] = array_merge(
        $simple_plus_complicated[$table_name],
        $records
      );
    }

    $test_cases = [
      'Simple beans with revisions' => [
        'Source' => static::BEAN_SIMPLE_TABLES + static::FIELD_TABLES,
        'Expected' => [
          [
            'bid' => 1,
            'vid' => 1,
            'delta' => 'simple-1',
            'label' => 'Label 1 (rev 1)',
            'title' => 'Title 1 (rev 1)',
            'type' => 'simple',
            'view_mode' => 'default',
            'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
            'uid' => 1,
            'created' => '1600000000',
            'changed' => '1600000000',
            'log' => '',
            'status' => 1,
            'revision_default' => 1,
            'revision_uid' => 1,
            'field' => [['value' => 'simple id 1 rev 1 field value']],
          ],
          [
            'bid' => 2,
            'vid' => 2,
            'delta' => 'simple-2',
            'label' => 'Label 2 (rev 1)',
            'title' => 'Title 2 (rev 1)',
            'type' => 'simple',
            'view_mode' => 'default',
            'data' => serialize(['view_mode' => 'default']),
            'uid' => 22,
            'created' => '1610000000',
            'changed' => '1610000000',
            'log' => '',
            'status' => 1,
            'revision_default' => 1,
            'revision_uid' => 20,
            'field' => [['value' => 'simple id 2 rev 1 field value']],
          ],
          [
            'bid' => 2,
            'vid' => 3,
            'delta' => 'simple-2',
            'label' => 'Label 2 (rev 2)',
            'title' => 'Title 2 (rev 2)',
            'type' => 'simple',
            'view_mode' => 'default',
            'data' => serialize(['view_mode' => 'default']),
            'uid' => 22,
            'created' => '1610000000',
            'changed' => '1610010000',
            'log' => 'New (published) revision.',
            'status' => 1,
            'revision_default' => 1,
            'revision_uid' => 22,
            'field' => [['value' => 'simple id 2 rev 2 field value']],
          ],
        ],
      ],
      'Complicated bean with a trailing (non-default) revision' => [
        'Source' => static::BEAN_COMPLICATED_TABLES + static::FIELD_TABLES,
        'Expected' => [
          [
            'bid' => 3,
            'vid' => 4,
            'delta' => 'complicated',
            'label' => 'Label 3 (rev 1)',
            'title' => 'Title 3 (rev 1)',
            'type' => 'complicated',
            'view_mode' => 'default',
            'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
            'uid' => 2,
            'created' => '1620000000',
            'changed' => '1620000000',
            'log' => '',
            'status' => 1,
            'revision_default' => 1,
            'revision_uid' => 2,
            'field' => [['value' => 'complicated id 3 rev 1 field value']],
          ],
          [
            'bid' => 3,
            'vid' => 5,
            'delta' => 'complicated',
            'label' => 'Label 3 (rev 2)',
            'title' => 'Title 3 (rev 2)',
            'type' => 'complicated',
            'view_mode' => 'default',
            'data' => serialize(['view_mode' => 'default']),
            'uid' => 2,
            'created' => '1620000000',
            'changed' => '1620010000',
            'log' => 'Unpublished revision.',
            'status' => 0,
            'revision_default' => 0,
            'revision_uid' => 2,
            'field' => [['value' => 'complicated id 3 rev 2 field value']],
          ],
        ],
      ],
    ];
    $test_cases['Simple + complicated, no filtering'] = [
      'Source' => $simple_plus_complicated + static::FIELD_TABLES,
      'Expected' => array_merge(
        $test_cases['Simple beans with revisions']['Expected'],
        $test_cases['Complicated bean with a trailing (non-default) revision']['Expected']
      ),
    ];
    $test_cases['Simple + complicated, source limited to simple'] = [
      'Source' => $simple_plus_complicated + static::FIELD_TABLES,
      'Expected' => $test_cases['Simple beans with revisions']['Expected'],
      'Count' => 3,
      'config' => [
        'type' => 'simple',
      ],
    ];

    return $test_cases;
  }

  /**
   * Field related tables and records used in the test.
   *
   * @const array[][]
   */
  const FIELD_TABLES = [
    'field_config' => [
      [
        'id' => 1,
        'translatable' => 0,
      ],
    ],
    'field_config_instance' => [
      [
        'field_id' => 1,
        'field_name' => 'field',
        'entity_type' => 'bean',
        'bundle' => 'simple',
        'deleted' => 0,
      ],
      [
        'field_id' => 1,
        'field_name' => 'field',
        'entity_type' => 'bean',
        'bundle' => 'complicated',
        'deleted' => 0,
      ],
    ],
    'field_revision_field' => [
      [
        'entity_type' => 'bean',
        'bundle' => 'simple',
        'entity_id' => '1',
        'revision_id' => '1',
        'delta' => 0,
        'deleted' => 0,
        'field_value' => 'simple id 1 rev 1 field value',
      ],
      [
        'entity_type' => 'bean',
        'bundle' => 'simple',
        'entity_id' => '2',
        'revision_id' => '2',
        'delta' => 0,
        'deleted' => 0,
        'field_value' => 'simple id 2 rev 1 field value',
      ],
      [
        'entity_type' => 'bean',
        'bundle' => 'simple',
        'entity_id' => '2',
        'revision_id' => '3',
        'delta' => 0,
        'deleted' => 0,
        'field_value' => 'simple id 2 rev 2 field value',
      ],
      [
        'entity_type' => 'bean',
        'bundle' => 'complicated',
        'entity_id' => '3',
        'revision_id' => '4',
        'delta' => 0,
        'deleted' => 0,
        'field_value' => 'complicated id 3 rev 1 field value',
      ],
      [
        'entity_type' => 'bean',
        'bundle' => 'complicated',
        'entity_id' => '3',
        'revision_id' => '5',
        'delta' => 0,
        'deleted' => 0,
        'field_value' => 'complicated id 3 rev 2 field value',
      ],
    ],
  ];

  /**
   * Tables with test data with "simple" bean records.
   *
   * Contains two bean entities. One of them has two revisions (all of them are
   * published).
   *
   * @const array[][]
   */
  const BEAN_SIMPLE_TABLES = [
    'bean' => [
      [
        'bid' => 1,
        'vid' => 1,
        'delta' => 'simple-1',
        'label' => 'Label 1 (rev 1)',
        'title' => 'Title 1 (rev 1)',
        'type' => 'simple',
        'view_mode' => 'default',
        'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
        'uid' => 1,
        'created' => '1600000000',
        'changed' => '1600000000',
      ],
      [
        'bid' => 2,
        'vid' => 3,
        'delta' => 'simple-2',
        'label' => 'Label 2 (rev 2)',
        'title' => 'Title 2 (rev 2)',
        'type' => 'simple',
        'view_mode' => 'default',
        'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
        'uid' => 22,
        'created' => '1610000000',
        'changed' => '1620000000',
      ],
    ],
    'bean_revision' => [
      [
        'bid' => 1,
        'vid' => 1,
        'delta' => 'simple-1',
        'label' => 'Label 1 (rev 1)',
        'title' => 'Title 1 (rev 1)',
        'type' => 'simple',
        'view_mode' => 'default',
        'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
        'uid' => 1,
        'created' => '1600000000',
        'changed' => '1600000000',
        'log' => '',
      ],
      [
        'bid' => 2,
        'vid' => 2,
        'delta' => 'simple-2',
        'label' => 'Label 2 (rev 1)',
        'title' => 'Title 2 (rev 1)',
        'type' => 'simple',
        'view_mode' => 'default',
        'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
        'uid' => 20,
        'created' => '1610000000',
        'changed' => '1610000000',
        'log' => '',
      ],
      [
        'bid' => 2,
        'vid' => 3,
        'delta' => 'simple-2',
        'label' => 'Label 2 (rev 2)',
        'title' => 'Title 2 (rev 2)',
        'type' => 'simple',
        'view_mode' => 'default',
        'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
        'uid' => 22,
        'created' => '1610000000',
        'changed' => '1610010000',
        'log' => 'New (published) revision.',
      ],
    ],
  ];

  /**
   * Tables with test data with "complicated" bean records.
   *
   * Contains a single bean entity with a default revision and with a trailer,
   * unpublished revision.
   *
   * @const array[][]
   */
  const BEAN_COMPLICATED_TABLES = [
    'bean' => [
      [
        'bid' => 3,
        'vid' => 4,
        'delta' => 'complicated',
        'label' => 'Label 3 (rev 1)',
        'title' => 'Title 3 (rev 1)',
        'type' => 'complicated',
        'view_mode' => 'default',
        'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
        'uid' => 2,
        'created' => '1620000000',
        'changed' => '1620000000',
      ],
    ],
    'bean_revision' => [
      [
        'bid' => 3,
        'vid' => 4,
        'delta' => 'complicated',
        'label' => 'Label 3 (rev 1)',
        'title' => 'Title 3 (rev 1)',
        'type' => 'complicated',
        'view_mode' => 'default',
        'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
        'uid' => 2,
        'created' => '1620000000',
        'changed' => '1620000000',
        'log' => '',
      ],
      [
        'bid' => 3,
        'vid' => 5,
        'delta' => 'complicated',
        'label' => 'Label 3 (rev 2)',
        'title' => 'Title 3 (rev 2)',
        'type' => 'complicated',
        'view_mode' => 'default',
        'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
        'uid' => 2,
        'created' => '1620000000',
        'changed' => '1620010000',
        'log' => 'Unpublished revision.',
      ],
    ],
  ];

}
