<?php

namespace Drupal\Tests\bean_migrate\Kernel\Plugin\migrate\source;

use Drupal\Tests\migrate\Kernel\MigrateSqlSourceTestBase;

/**
 * Tests the "bean_title_field_widget" migrate source plugin.
 *
 * @covers \Drupal\bean_migrate\Plugin\migrate\source\BeanTitleFieldWidget
 * @group bean_migrate
 */
class BeanTitleFieldWidgetTest extends MigrateSqlSourceTestBase {

  /**
   * {@inheritdoc}
   *
   * @todo This should be changed to "protected" after Drupal core 8.x security
   *   support ends.
   * @see https://www.drupal.org/node/2909426
   */
  public static $modules = [
    'bean_migrate',
    'migrate_drupal',
  ];

  /**
   * {@inheritdoc}
   */
  public function providerSource() {
    $test_cases = [
      'All bundles' => [
        'Source' => [
          'bean' => [
            ['type' => 'simple'],
            ['type' => 'complicated'],
          ],
          'variable' => [
            [
              'name' => 'field_bundle_settings_bean__simple',
              'value' => serialize([
                'extra_fields' => ['form' => ['title' => ['weight' => '-5']]],
              ]),
            ],
            [
              'name' => 'field_bundle_settings_bean__complicated',
              'value' => serialize([
                'extra_fields' => ['form' => ['title' => ['weight' => '44']]],
              ]),
            ],
          ],
        ],
        'Expected' => [
          [
            'type' => 'simple',
            'widget_weight' => -5,
          ],
          [
            'type' => 'complicated',
            'widget_weight' => 44,
          ],
        ],
      ],
    ];
    $test_cases['Filtering for "simple"'] = [
      'Source' => $test_cases['All bundles']['Source'],
      'Expected' => [
        [
          'type' => 'simple',
          'widget_weight' => -5,
        ],
      ],
      'Count' => 1,
      'Plugin config' => [
        'type' => 'simple',
      ],
    ];
    $test_cases['Filtering for a missing type'] = [
      'Source' => $test_cases['All bundles']['Source'],
      'Expected' => [],
      'Count' => NULL,
      'Plugin config' => [
        'type' => 'missing_type',
      ],
    ];

    return $test_cases;
  }

}
