<?php

namespace Drupal\Tests\bean_migrate\Kernel\Plugin\migrate\source;

use Drupal\Tests\migrate\Kernel\MigrateSqlSourceTestBase;

/**
 * Tests the bean type migrate source plugin.
 *
 * @covers \Drupal\bean_migrate\Plugin\migrate\source\BeanType
 * @group bean_migrate
 */
class BeanTypeTest extends MigrateSqlSourceTestBase {

  /**
   * {@inheritdoc}
   *
   * @todo This should be changed to "protected" after Drupal core 8.x security
   *   support ends.
   * @see https://www.drupal.org/node/2909426
   */
  public static $modules = [
    'bean_migrate',
    'migrate_drupal',
  ];

  /**
   * {@inheritdoc}
   */
  public function providerSource() {
    $test_cases = [
      'No bean_type table' => [
        'Source' => [
          'bean' => [
            ['type' => 'simple'],
            ['type' => 'complicated'],
          ],
        ],
        'Expected' => [
          ['type' => 'simple'],
          ['type' => 'complicated'],
        ],
      ],
      'With incomplete bean_type table' => [
        'Source' => [
          'bean' => [
            ['type' => 'simple'],
            ['type' => 'complicated'],
          ],
          'bean_type' => [
            [
              'name' => 'complicated',
              'label' => 'Complete label',
              'description' => 'Description for complete',
            ],
          ],
        ],
        'Expected' => [
          [
            'type' => 'simple',
            'label' => NULL,
            'description' => NULL,
          ],
          [
            'type' => 'complicated',
            'label' => 'Complete label',
            'description' => 'Description for complete',
          ],
        ],
      ],
    ];
    $test_cases['With filtering applied'] = [
      'Source' => $test_cases['No bean_type table']['Source'],
      'Expected' => [
        ['type' => 'simple'],
      ],
      'Count' => 1,
      'Plugin config' => [
        'type' => 'simple',
      ],
    ];

    return $test_cases;
  }

}
