<?php

namespace Drupal\Tests\bean_migrate\Traits;

use Drupal\block\Entity\Block;

/**
 * Trait for bean block related assertions.
 */
trait BeanBlockAssertionsTrait {

  /**
   * List of block config properties whose value shouldn't have to be checked.
   *
   * @var string[]
   */
  protected $blockUnconcernedProperties = [
    'uuid',
    '_core',
  ];

  /**
   * Checks the block config entity which was migrated from BLOCK #1.
   *
   * This checks a block that WASN'T A BEAN in Drupal 7.
   */
  public function assertBlock1Block() {
    $block = \Drupal::entityTypeManager()
      ->getStorage('block')
      ->load('bartik_block_1');
    $this->assertInstanceOf(Block::class, $block);

    // We need to know the uuid of the block content entity this plugin instance
    // display.
    $block_contents = \Drupal::entityTypeManager()
      ->getStorage('block_content')
      ->loadByProperties(['info' => 'Admin label of Custom block #1']);
    $block_content = reset($block_contents);

    $this->assertEquals([
      'langcode' => 'en',
      'status' => TRUE,
      'dependencies' => [
        'content' => ["block_content:basic:{$block_content->uuid()}"],
        'module' => ['block_content'],
        'theme' => ['bartik'],
      ],
      'id' => 'bartik_block_1',
      'theme' => 'bartik',
      'region' => 'featured_bottom_third',
      'weight' => 0,
      'provider' => NULL,
      'plugin' => "block_content:{$block_content->uuid()}",
      'settings' => [
        'id' => "block_content:{$block_content->uuid()}",
        'label' => 'Title of Custom block #1',
        'provider' => 'block_content',
        'label_display' => 'visible',
        'status' => TRUE,
        'info' => '',
        'view_mode' => 'full',
      ],
      'visibility' => [],
    ], $this->getImportantEntityProperties($block));
  }

  /**
   * Checks the block config entity which was migrated from Bean #3.
   */
  public function assertBean3Block() {
    $block = \Drupal::entityTypeManager()
      ->getStorage('block')
      ->load('bartik_bean_yellow_image');
    $this->assertInstanceOf(Block::class, $block);

    // We need to know the uuid of the block content entity this plugin instance
    // display.
    $block_contents = \Drupal::entityTypeManager()
      ->getStorage('block_content')
      ->loadByProperties(['info' => 'Admin label of Bean #3']);
    $block_content = reset($block_contents);

    $this->assertEquals([
      'langcode' => 'en',
      'status' => TRUE,
      'dependencies' => [
        'content' => ["block_content:image:{$block_content->uuid()}"],
        'module' => ['block_content'],
        'theme' => ['bartik'],
      ],
      'id' => 'bartik_bean_yellow_image',
      'theme' => 'bartik',
      'region' => 'featured_bottom_first',
      'weight' => 0,
      'provider' => NULL,
      'plugin' => "block_content:{$block_content->uuid()}",
      'settings' => [
        'id' => "block_content:{$block_content->uuid()}",
        'label' => 'Yellow image',
        'provider' => 'block_content',
        'label_display' => 'visible',
        'status' => TRUE,
        'info' => '',
        'view_mode' => 'full',
      ],
      'visibility' => [],
    ], $this->getImportantEntityProperties($block));
  }

  /**
   * Checks the block config entity which was migrated from Bean #4.
   */
  public function assertBean4Block(string $type = 'simple') {
    $block = \Drupal::entityTypeManager()
      ->getStorage('block')
      ->load('bartik_bean_bean_4_rev_1');
    $this->assertInstanceOf(Block::class, $block);

    // We need to know the uuid of the block content entity this plugin instance
    // display.
    $block_contents = \Drupal::entityTypeManager()
      ->getStorage('block_content')
      ->loadByProperties(['info' => 'Admin label of Bean #4']);
    $block_content = reset($block_contents);

    $this->assertEquals([
      'langcode' => 'en',
      'status' => TRUE,
      'dependencies' => [
        'content' => ["block_content:{$type}:{$block_content->uuid()}"],
        'module' => ['block_content'],
        'theme' => ['bartik'],
      ],
      'id' => 'bartik_bean_bean_4_rev_1',
      'theme' => 'bartik',
      'region' => 'featured_bottom_second',
      'weight' => 0,
      'provider' => NULL,
      'plugin' => "block_content:{$block_content->uuid()}",
      'settings' => [
        'id' => "block_content:{$block_content->uuid()}",
        'label' => 'Bean #4 (rev 1)',
        'provider' => 'block_content',
        'label_display' => 'visible',
        'status' => TRUE,
        'info' => '',
        'view_mode' => 'full',
      ],
      'visibility' => [],
    ], $this->getImportantEntityProperties($block));
  }

}
