<?php

namespace Drupal\Tests\bean_migrate\Traits;

use Drupal\field\FieldConfigInterface;

/**
 * Trait for bean field related assertions.
 */
trait BeanFieldConfigAssertionsTrait {

  /**
   * List of block type properties whose value shouldn't have to be checked.
   *
   * @var string[]
   */
  protected $fieldConfigUnconcernedProperties = [
    'uuid',
    'langcode',
  ];

  /**
   * Checks the "field_image" field instance migrated for the "image" type.
   */
  public function assertBeanImageImageFieldInstance() {
    $field_instance = $this->container->get('entity_type.manager')->getStorage('field_config')->load('block_content.image.field_image');
    assert($field_instance instanceof FieldConfigInterface);

    $this->assertEquals([
      'status' => TRUE,
      'dependencies' => [
        'config' => [
          'block_content.type.image',
          'field.storage.block_content.field_image',
        ],
        'module' => [
          'image',
        ],
      ],
      'id' => 'block_content.image.field_image',
      'label' => 'Image',
      'description' => '',
      'field_name' => 'field_image',
      'entity_type' => 'block_content',
      'bundle' => 'image',
      'required' => FALSE,
      'translatable' => FALSE,
      'default_value' => [],
      'default_value_callback' => '',
      'settings' => [
        'file_directory' => 'images',
        'file_extensions' => 'png gif jpg jpeg',
        'max_filesize' => '',
        'max_resolution' => '',
        'min_resolution' => '',
        'alt_field' => FALSE,
        'title_field' => FALSE,
        'default_image' => [
          'alt' => '',
          'title' => '',
          'width' => NULL,
          'height' => NULL,
          'uuid' => '',
        ],
        'alt_field_required' => TRUE,
        'title_field_required' => FALSE,
        'handler' => 'default:file',
        'handler_settings' => [],
      ],
      'field_type' => 'image',
    ], $this->getImportantEntityProperties($field_instance));
  }

  /**
   * Checks the "title" field instance migrated for the "image" type.
   */
  public function assertBeanImageTitleFieldInstance() {
    $image_title_field_instance = \Drupal::entityTypeManager()
      ->getStorage('field_config')
      ->load('block_content.image.title');
    assert($image_title_field_instance instanceof FieldConfigInterface);

    $this->assertEquals([
      'status' => TRUE,
      'dependencies' => [
        'config' => [
          'block_content.type.image',
          'field.storage.block_content.title',
        ],
      ],
      'id' => 'block_content.image.title',
      'label' => 'Title',
      'description' => 'The Title of the block.',
      'field_name' => 'title',
      'entity_type' => 'block_content',
      'bundle' => 'image',
      'required' => FALSE,
      'translatable' => TRUE,
      'default_value' => [],
      'default_value_callback' => '',
      'settings' => [],
      'field_type' => 'string',
    ], $this->getImportantEntityProperties($image_title_field_instance));
  }

  /**
   * Checks the "field_body" field instance migrated for the "simple" type.
   *
   * @param string $type
   *   The ID of the migrated "simple" bean type.
   */
  public function assertBeanSimpleBodyFieldInstance(string $type = 'simple') {
    $field_instance = \Drupal::entityTypeManager()
      ->getStorage('field_config')
      ->load("block_content.{$type}.field_body");
    assert($field_instance instanceof FieldConfigInterface);

    $this->assertEquals([
      'status' => TRUE,
      'dependencies' => [
        'config' => [
          "block_content.type.{$type}",
          'field.storage.block_content.field_body',
        ],
        'module' => [
          'text',
        ],
      ],
      'id' => "block_content.{$type}.field_body",
      'label' => 'Body',
      'description' => '',
      'field_name' => 'field_body',
      'entity_type' => 'block_content',
      'bundle' => $type,
      'required' => FALSE,
      'translatable' => FALSE,
      'default_value' => [],
      'default_value_callback' => '',
      'settings' => [],
      'field_type' => 'text_long',
    ], $this->getImportantEntityProperties($field_instance));
  }

  /**
   * Checks the "title" field instance migrated for the "simple" type.
   *
   * @param string $type
   *   The ID of the migrated "simple" bean type.
   */
  public function assertBeanSimpleTitleFieldInstance(string $type = 'simple') {
    $simple_title_field_instance = \Drupal::entityTypeManager()
      ->getStorage('field_config')
      ->load("block_content.{$type}.title");
    assert($simple_title_field_instance instanceof FieldConfigInterface);

    $this->assertEquals([
      'status' => TRUE,
      'dependencies' => [
        'config' => [
          "block_content.type.{$type}",
          'field.storage.block_content.title',
        ],
      ],
      'id' => "block_content.{$type}.title",
      'label' => 'Title',
      'description' => 'The Title of the block.',
      'field_name' => 'title',
      'entity_type' => 'block_content',
      'bundle' => $type,
      'required' => FALSE,
      'translatable' => TRUE,
      'default_value' => [],
      'default_value_callback' => '',
      'settings' => [],
      'field_type' => 'string',
    ], $this->getImportantEntityProperties($simple_title_field_instance));
  }

}
