<?php
// @codingStandardsIgnoreFile
/**
 * @file
 * A database agnostic dump for testing purposes.
 *
 * This file was generated by the Drupal 9.1.2 db-tools.php script.
 */

use Drupal\Core\Database\Database;

$connection = Database::getConnection();

$connection->schema()->createTable('actions', array(
  'fields' => array(
    'aid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '0',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'parameters' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'label' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'aid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('actions')
->fields(array(
  'aid',
  'type',
  'callback',
  'parameters',
  'label',
))
->values(array(
  'aid' => 'node_make_sticky_action',
  'type' => 'node',
  'callback' => 'node_make_sticky_action',
  'parameters' => '',
  'label' => 'Make content sticky',
))
->values(array(
  'aid' => 'node_make_unsticky_action',
  'type' => 'node',
  'callback' => 'node_make_unsticky_action',
  'parameters' => '',
  'label' => 'Make content unsticky',
))
->values(array(
  'aid' => 'node_promote_action',
  'type' => 'node',
  'callback' => 'node_promote_action',
  'parameters' => '',
  'label' => 'Promote content to front page',
))
->values(array(
  'aid' => 'node_publish_action',
  'type' => 'node',
  'callback' => 'node_publish_action',
  'parameters' => '',
  'label' => 'Publish content',
))
->values(array(
  'aid' => 'node_save_action',
  'type' => 'node',
  'callback' => 'node_save_action',
  'parameters' => '',
  'label' => 'Save content',
))
->values(array(
  'aid' => 'node_unpromote_action',
  'type' => 'node',
  'callback' => 'node_unpromote_action',
  'parameters' => '',
  'label' => 'Remove content from front page',
))
->values(array(
  'aid' => 'node_unpublish_action',
  'type' => 'node',
  'callback' => 'node_unpublish_action',
  'parameters' => '',
  'label' => 'Unpublish content',
))
->values(array(
  'aid' => 'system_block_ip_action',
  'type' => 'user',
  'callback' => 'system_block_ip_action',
  'parameters' => '',
  'label' => 'Ban IP address of current user',
))
->values(array(
  'aid' => 'user_block_user_action',
  'type' => 'user',
  'callback' => 'user_block_user_action',
  'parameters' => '',
  'label' => 'Block current user',
))
->execute();
$connection->schema()->createTable('authmap', array(
  'fields' => array(
    'aid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'authname' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'aid',
  ),
  'unique keys' => array(
    'authname' => array(
      'authname',
    ),
  ),
  'indexes' => array(
    'uid_module' => array(
      'uid',
      'module',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('batch', array(
  'fields' => array(
    'bid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'token' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'batch' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'bid',
  ),
  'indexes' => array(
    'token' => array(
      'token',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('bean', array(
  'fields' => array(
    'bid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'delta' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ),
    'label' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'view_mode' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => 'default',
    ),
    'data' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'changed' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'uuid' => array(
      'type' => 'char',
      'not null' => TRUE,
      'length' => '36',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'bid',
  ),
  'unique keys' => array(
    'vid' => array(
      'vid',
    ),
    'delta' => array(
      'delta',
    ),
  ),
  'indexes' => array(
    'uuid' => array(
      'uuid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('bean')
->fields(array(
  'bid',
  'vid',
  'delta',
  'label',
  'title',
  'type',
  'view_mode',
  'data',
  'uid',
  'created',
  'changed',
  'uuid',
))
->values(array(
  'bid' => '1',
  'vid' => '1',
  'delta' => 'admin-label-of-bean-block-1',
  'label' => 'Admin label of Bean #1',
  'title' => 'Title of Bean block #1',
  'type' => 'simple',
  'view_mode' => 'default',
  'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
  'uid' => '1',
  'created' => '1611055931',
  'changed' => '1611055931',
  'uuid' => 'f5c783c4-2fa5-48a2-9c09-5c43e4faea8c',
))
->values(array(
  'bid' => '2',
  'vid' => '3',
  'delta' => 'admin-label-of-bean-block-2-rev-',
  'label' => 'Admin label of Bean #2',
  'title' => 'Title of Bean block #2 (rev 2)',
  'type' => 'simple',
  'view_mode' => 'default',
  'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
  'uid' => '1',
  'created' => '1611056213',
  'changed' => '1611056294',
  'uuid' => '8568da7e-9325-4421-8473-fe1d5d14af6a',
))
->values(array(
  'bid' => '3',
  'vid' => '4',
  'delta' => 'yellow-image',
  'label' => 'Admin label of Bean #3',
  'title' => 'Yellow image',
  'type' => 'image',
  'view_mode' => 'default',
  'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
  'uid' => '1',
  'created' => '1611056822',
  'changed' => '1611056822',
  'uuid' => '657e9ce8-a3a5-414e-ae1a-0e11208abc4e',
))
->values(array(
  'bid' => '4',
  'vid' => '5',
  'delta' => 'bean-4-rev-1',
  'label' => 'Admin label of Bean #4',
  'title' => 'Bean #4 (rev 1)',
  'type' => 'simple',
  'view_mode' => 'default',
  'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
  'uid' => '1',
  'created' => '1611057740',
  'changed' => '1611057740',
  'uuid' => '9b693dcc-74c6-402c-8078-49225b1d6820',
))
->execute();
$connection->schema()->createTable('bean_revision', array(
  'fields' => array(
    'bid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'delta' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ),
    'label' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'view_mode' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => 'default',
    ),
    'data' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'changed' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'log' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'vuuid' => array(
      'type' => 'char',
      'not null' => TRUE,
      'length' => '36',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'indexes' => array(
    'bid' => array(
      'bid',
      'vid',
    ),
    'vuuid' => array(
      'vuuid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('bean_revision')
->fields(array(
  'bid',
  'vid',
  'delta',
  'label',
  'title',
  'type',
  'view_mode',
  'data',
  'uid',
  'created',
  'changed',
  'log',
  'vuuid',
))
->values(array(
  'bid' => '1',
  'vid' => '1',
  'delta' => 'admin-label-of-bean-block-1',
  'label' => 'Admin label of Bean #1',
  'title' => 'Title of Bean block #1',
  'type' => 'simple',
  'view_mode' => 'default',
  'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
  'uid' => '1',
  'created' => '1611055931',
  'changed' => '1611055931',
  'log' => '',
  'vuuid' => '2d4294b8-3d9b-43e6-87e6-158a9786104f',
))
->values(array(
  'bid' => '2',
  'vid' => '2',
  'delta' => 'admin-label-of-bean-block-2-rev-',
  'label' => 'Admin label of Bean #2',
  'title' => 'Title of Bean block #2 (rev 1)',
  'type' => 'simple',
  'view_mode' => 'compact',
  'data' => 'a:1:{s:9:"view_mode";s:7:"compact";}',
  'uid' => '1',
  'created' => '1611056213',
  'changed' => '1611056213',
  'log' => '',
  'vuuid' => '6401f02f-9466-4285-90f8-e7b7ce7bc245',
))
->values(array(
  'bid' => '2',
  'vid' => '3',
  'delta' => 'admin-label-of-bean-block-2-rev-',
  'label' => 'Admin label of Bean #2',
  'title' => 'Title of Bean block #2 (rev 2)',
  'type' => 'simple',
  'view_mode' => 'default',
  'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
  'uid' => '1',
  'created' => '1611056213',
  'changed' => '1611056294',
  'log' => 'A revision log message for the second revision of Bean #2.',
  'vuuid' => '3901fc55-9d23-48f0-a286-e03520616be6',
))
->values(array(
  'bid' => '3',
  'vid' => '4',
  'delta' => 'yellow-image',
  'label' => 'Admin label of Bean #3',
  'title' => 'Yellow image',
  'type' => 'image',
  'view_mode' => 'default',
  'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
  'uid' => '1',
  'created' => '1611056822',
  'changed' => '1611056822',
  'log' => '',
  'vuuid' => '53f774b5-e927-4a1f-8d97-6031e1547d43',
))
->values(array(
  'bid' => '4',
  'vid' => '5',
  'delta' => 'bean-4-rev-1',
  'label' => 'Admin label of Bean #4',
  'title' => 'Bean #4 (rev 1, default)',
  'type' => 'simple',
  'view_mode' => 'default',
  'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
  'uid' => '1',
  'created' => '1611057740',
  'changed' => '1611057740',
  'log' => '',
  'vuuid' => '02209282-f15b-4742-854a-9c6edce218c0',
))
->values(array(
  'bid' => '4',
  'vid' => '6',
  'delta' => 'bean-4-rev-1',
  'label' => 'Admin label of Bean #4',
  'title' => 'Bean #4 (rev 2, non-default)',
  'type' => 'simple',
  'view_mode' => 'default',
  'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
  'uid' => '1',
  'created' => '1611057740',
  'changed' => '1611057797',
  'log' => 'New revision for Bean #4, but leaving the previous as default.',
  'vuuid' => 'ba016ce7-4f21-4a47-a5ed-3387b2d820c4',
))
->execute();
$connection->schema()->createTable('bean_type', array(
  'fields' => array(
    'type_id' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ),
    'label' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'options' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'type_id',
  ),
  'unique keys' => array(
    'name' => array(
      'name',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('bean_type')
->fields(array(
  'type_id',
  'name',
  'label',
  'options',
  'description',
))
->values(array(
  'type_id' => '1',
  'name' => 'simple',
  'label' => 'Simple',
  'options' => NULL,
  'description' => 'A simple type for storing a short formatted text.',
))
->values(array(
  'type_id' => '2',
  'name' => 'image',
  'label' => 'Image',
  'options' => NULL,
  'description' => 'A type for referencing images.',
))
->execute();
$connection->schema()->createTable('block', array(
  'fields' => array(
    'bid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '0',
    ),
    'theme' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'region' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'custom' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'visibility' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'pages' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'cache' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '1',
    ),
  ),
  'primary key' => array(
    'bid',
  ),
  'unique keys' => array(
    'tmd' => array(
      'theme',
      'module',
      'delta',
    ),
  ),
  'indexes' => array(
    'list' => array(
      'theme',
      'status',
      'region',
      'weight',
      'module',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('block')
->fields(array(
  'bid',
  'module',
  'delta',
  'theme',
  'status',
  'weight',
  'region',
  'custom',
  'visibility',
  'pages',
  'title',
  'cache',
))
->values(array(
  'bid' => '1',
  'module' => 'system',
  'delta' => 'main',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '0',
  'region' => 'content',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '2',
  'module' => 'user',
  'delta' => 'login',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '0',
  'region' => 'sidebar_first',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '3',
  'module' => 'system',
  'delta' => 'navigation',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '0',
  'region' => 'sidebar_first',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '4',
  'module' => 'system',
  'delta' => 'management',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '1',
  'region' => 'sidebar_first',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '5',
  'module' => 'system',
  'delta' => 'help',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '0',
  'region' => 'help',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '6',
  'module' => 'node',
  'delta' => 'syndicate',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '7',
  'module' => 'node',
  'delta' => 'recent',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '8',
  'module' => 'system',
  'delta' => 'powered-by',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '10',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '9',
  'module' => 'system',
  'delta' => 'user-menu',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '10',
  'module' => 'system',
  'delta' => 'main-menu',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '11',
  'module' => 'user',
  'delta' => 'new',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '12',
  'module' => 'user',
  'delta' => 'online',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '13',
  'module' => 'bean',
  'delta' => 'admin-label-of-bean-block-1',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '14',
  'module' => 'bean',
  'delta' => 'admin-label-of-bean-block-2-rev-',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '15',
  'module' => 'bean',
  'delta' => 'yellow-image',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '0',
  'region' => 'triptych_first',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '16',
  'module' => 'bean',
  'delta' => 'bean-3-rev-1',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '17',
  'module' => 'bean',
  'delta' => 'bean-4-rev-1',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '0',
  'region' => 'triptych_middle',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '18',
  'module' => 'block',
  'delta' => '1',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '0',
  'region' => 'triptych_last',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => 'Title of Custom block #1',
  'cache' => '-1',
))
->execute();
$connection->schema()->createTable('block_custom', array(
  'fields' => array(
    'bid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'body' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'info' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'bid',
  ),
  'unique keys' => array(
    'info' => array(
      'info',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('block_custom')
->fields(array(
  'bid',
  'body',
  'info',
  'format',
))
->values(array(
  'bid' => '1',
  'body' => 'Body of Custom block #1.',
  'info' => 'Admin label of Custom block #1',
  'format' => 'plain_text',
))
->execute();
$connection->schema()->createTable('block_node_type', array(
  'fields' => array(
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
    'delta' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ),
  ),
  'primary key' => array(
    'module',
    'delta',
    'type',
  ),
  'indexes' => array(
    'type' => array(
      'type',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('block_role', array(
  'fields' => array(
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
    'delta' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ),
    'rid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'module',
    'delta',
    'rid',
  ),
  'indexes' => array(
    'rid' => array(
      'rid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('blocked_ips', array(
  'fields' => array(
    'iid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'ip' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '40',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'iid',
  ),
  'indexes' => array(
    'blocked_ip' => array(
      'ip',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_block', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_bootstrap', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_field', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_filter', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_form', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_image', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_menu', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_page', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_path', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('ctools_css_cache', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
    ),
    'filename' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'css' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'filter' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'tiny',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('ctools_object_cache', array(
  'fields' => array(
    'sid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
    ),
    'obj' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
    ),
    'updated' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'sid',
    'obj',
    'name',
  ),
  'indexes' => array(
    'updated' => array(
      'updated',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('date_format_locale', array(
  'fields' => array(
    'format' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '100',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
    ),
  ),
  'primary key' => array(
    'type',
    'language',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('date_format_type', array(
  'fields' => array(
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'locked' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'type',
  ),
  'indexes' => array(
    'title' => array(
      array(
        'title',
        '191',
      ),
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('date_format_type')
->fields(array(
  'type',
  'title',
  'locked',
))
->values(array(
  'type' => 'long',
  'title' => 'Long',
  'locked' => '1',
))
->values(array(
  'type' => 'medium',
  'title' => 'Medium',
  'locked' => '1',
))
->values(array(
  'type' => 'short',
  'title' => 'Short',
  'locked' => '1',
))
->execute();
$connection->schema()->createTable('date_formats', array(
  'fields' => array(
    'dfid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'format' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '100',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
    'locked' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'dfid',
  ),
  'unique keys' => array(
    'formats' => array(
      'format',
      'type',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('date_formats')
->fields(array(
  'dfid',
  'format',
  'type',
  'locked',
))
->values(array(
  'dfid' => '1',
  'format' => 'm/d/Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '2',
  'format' => 'd/m/Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '3',
  'format' => 'Y/m/d - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '4',
  'format' => 'd.m.Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '5',
  'format' => 'Y-m-d H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '6',
  'format' => 'm/d/Y - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '7',
  'format' => 'd/m/Y - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '8',
  'format' => 'Y/m/d - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '9',
  'format' => 'M j Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '10',
  'format' => 'j M Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '11',
  'format' => 'Y M j - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '12',
  'format' => 'M j Y - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '13',
  'format' => 'j M Y - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '14',
  'format' => 'Y M j - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '15',
  'format' => 'D, m/d/Y - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '16',
  'format' => 'D, d/m/Y - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '17',
  'format' => 'D, Y/m/d - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '18',
  'format' => 'D, Y-m-d H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '19',
  'format' => 'F j, Y - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '20',
  'format' => 'j F, Y - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '21',
  'format' => 'Y, F j - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '22',
  'format' => 'D, m/d/Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '23',
  'format' => 'D, d/m/Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '24',
  'format' => 'D, Y/m/d - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '25',
  'format' => 'F j, Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '26',
  'format' => 'j F Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '27',
  'format' => 'Y, F j - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '28',
  'format' => 'j. F Y - G:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '29',
  'format' => 'l, F j, Y - H:i',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '30',
  'format' => 'l, j F, Y - H:i',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '31',
  'format' => 'l, Y,  F j - H:i',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '32',
  'format' => 'l, F j, Y - g:ia',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '33',
  'format' => 'l, j F Y - g:ia',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '34',
  'format' => 'l, Y,  F j - g:ia',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '35',
  'format' => 'l, j. F Y - G:i',
  'type' => 'long',
  'locked' => '1',
))
->execute();
$connection->schema()->createTable('field_config', array(
  'fields' => array(
    'id' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'field_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'active' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'storage_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
    ),
    'storage_module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'storage_active' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'locked' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'cardinality' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'translatable' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'id',
  ),
  'indexes' => array(
    'field_name' => array(
      'field_name',
    ),
    'active' => array(
      'active',
    ),
    'storage_active' => array(
      'storage_active',
    ),
    'deleted' => array(
      'deleted',
    ),
    'module' => array(
      'module',
    ),
    'storage_module' => array(
      'storage_module',
    ),
    'type' => array(
      'type',
    ),
    'storage_type' => array(
      'storage_type',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_config')
->fields(array(
  'id',
  'field_name',
  'type',
  'module',
  'active',
  'storage_type',
  'storage_module',
  'storage_active',
  'locked',
  'data',
  'cardinality',
  'translatable',
  'deleted',
))
->values(array(
  'id' => '1',
  'field_name' => 'field_body',
  'type' => 'text_long',
  'module' => 'text',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:7:{s:12:"translatable";s:1:"0";s:12:"entity_types";a:0:{}s:8:"settings";a:0:{}s:7:"storage";a:5:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";s:1:"1";s:7:"details";a:1:{s:3:"sql";a:2:{s:18:"FIELD_LOAD_CURRENT";a:1:{s:21:"field_data_field_body";a:2:{s:5:"value";s:16:"field_body_value";s:6:"format";s:17:"field_body_format";}}s:19:"FIELD_LOAD_REVISION";a:1:{s:25:"field_revision_field_body";a:2:{s:5:"value";s:16:"field_body_value";s:6:"format";s:17:"field_body_format";}}}}}s:12:"foreign keys";a:1:{s:6:"format";a:2:{s:5:"table";s:13:"filter_format";s:7:"columns";a:1:{s:6:"format";s:6:"format";}}}s:7:"indexes";a:1:{s:6:"format";a:1:{i:0;s:6:"format";}}s:2:"id";s:1:"1";}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
))
->values(array(
  'id' => '2',
  'field_name' => 'node_body',
  'type' => 'text_with_summary',
  'module' => 'text',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:6:{s:12:"entity_types";a:1:{i:0;s:4:"node";}s:12:"translatable";b:0;s:8:"settings";a:0:{}s:7:"storage";a:4:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";i:1;}s:12:"foreign keys";a:1:{s:6:"format";a:2:{s:5:"table";s:13:"filter_format";s:7:"columns";a:1:{s:6:"format";s:6:"format";}}}s:7:"indexes";a:1:{s:6:"format";a:1:{i:0;s:6:"format";}}}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
))
->values(array(
  'id' => '3',
  'field_name' => 'field_block_reference',
  'type' => 'blockreference',
  'module' => 'blockreference',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:7:{s:12:"translatable";s:1:"0";s:12:"entity_types";a:0:{}s:8:"settings";a:1:{s:21:"referenceable_modules";a:0:{}}s:7:"storage";a:5:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";s:1:"1";s:7:"details";a:1:{s:3:"sql";a:2:{s:18:"FIELD_LOAD_CURRENT";a:1:{s:32:"field_data_field_block_reference";a:1:{s:8:"moddelta";s:30:"field_block_reference_moddelta";}}s:19:"FIELD_LOAD_REVISION";a:1:{s:36:"field_revision_field_block_reference";a:1:{s:8:"moddelta";s:30:"field_block_reference_moddelta";}}}}}s:12:"foreign keys";a:0:{}s:7:"indexes";a:1:{s:8:"moddelta";a:1:{i:0;s:8:"moddelta";}}s:2:"id";s:1:"3";}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
))
->values(array(
  'id' => '4',
  'field_name' => 'field_block_reference_multi',
  'type' => 'blockreference',
  'module' => 'blockreference',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:7:{s:12:"translatable";s:1:"0";s:12:"entity_types";a:0:{}s:8:"settings";a:1:{s:21:"referenceable_modules";a:0:{}}s:7:"storage";a:5:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";s:1:"1";s:7:"details";a:1:{s:3:"sql";a:2:{s:18:"FIELD_LOAD_CURRENT";a:1:{s:38:"field_data_field_block_reference_multi";a:1:{s:8:"moddelta";s:36:"field_block_reference_multi_moddelta";}}s:19:"FIELD_LOAD_REVISION";a:1:{s:42:"field_revision_field_block_reference_multi";a:1:{s:8:"moddelta";s:36:"field_block_reference_multi_moddelta";}}}}}s:12:"foreign keys";a:0:{}s:7:"indexes";a:1:{s:8:"moddelta";a:1:{i:0;s:8:"moddelta";}}s:2:"id";s:1:"4";}',
  'cardinality' => '3',
  'translatable' => '0',
  'deleted' => '0',
))
->values(array(
  'id' => '5',
  'field_name' => 'field_image',
  'type' => 'image',
  'module' => 'image',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:7:{s:12:"translatable";s:1:"0";s:12:"entity_types";a:0:{}s:8:"settings";a:2:{s:10:"uri_scheme";s:6:"public";s:13:"default_image";i:0;}s:7:"storage";a:5:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";s:1:"1";s:7:"details";a:1:{s:3:"sql";a:2:{s:18:"FIELD_LOAD_CURRENT";a:1:{s:22:"field_data_field_image";a:5:{s:3:"fid";s:15:"field_image_fid";s:3:"alt";s:15:"field_image_alt";s:5:"title";s:17:"field_image_title";s:5:"width";s:17:"field_image_width";s:6:"height";s:18:"field_image_height";}}s:19:"FIELD_LOAD_REVISION";a:1:{s:26:"field_revision_field_image";a:5:{s:3:"fid";s:15:"field_image_fid";s:3:"alt";s:15:"field_image_alt";s:5:"title";s:17:"field_image_title";s:5:"width";s:17:"field_image_width";s:6:"height";s:18:"field_image_height";}}}}}s:12:"foreign keys";a:1:{s:3:"fid";a:2:{s:5:"table";s:12:"file_managed";s:7:"columns";a:1:{s:3:"fid";s:3:"fid";}}}s:7:"indexes";a:1:{s:3:"fid";a:1:{i:0;s:3:"fid";}}s:2:"id";s:1:"5";}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
))
->execute();
$connection->schema()->createTable('field_config_instance', array(
  'fields' => array(
    'id' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'field_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'field_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'id',
  ),
  'indexes' => array(
    'field_name_bundle' => array(
      'field_name',
      'entity_type',
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_config_instance')
->fields(array(
  'id',
  'field_id',
  'field_name',
  'entity_type',
  'bundle',
  'data',
  'deleted',
))
->values(array(
  'id' => '1',
  'field_id' => '1',
  'field_name' => 'field_body',
  'entity_type' => 'bean',
  'bundle' => 'simple',
  'data' => 'a:7:{s:5:"label";s:4:"Body";s:6:"widget";a:5:{s:6:"weight";s:2:"11";s:4:"type";s:13:"text_textarea";s:6:"module";s:4:"text";s:6:"active";i:1;s:8:"settings";a:1:{s:4:"rows";s:1:"5";}}s:8:"settings";a:2:{s:15:"text_processing";s:1:"1";s:18:"user_register_form";b:0;}s:7:"display";a:2:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";s:1:"0";s:8:"settings";a:0:{}s:6:"module";s:4:"text";}s:7:"compact";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_trimmed";s:6:"weight";s:1:"0";s:8:"settings";a:1:{s:11:"trim_length";s:3:"100";}s:6:"module";s:4:"text";}}s:8:"required";i:0;s:11:"description";s:0:"";s:13:"default_value";N;}',
  'deleted' => '0',
))
->values(array(
  'id' => '2',
  'field_id' => '2',
  'field_name' => 'node_body',
  'entity_type' => 'node',
  'bundle' => 'page',
  'data' => 'a:6:{s:5:"label";s:4:"Body";s:6:"widget";a:4:{s:4:"type";s:26:"text_textarea_with_summary";s:8:"settings";a:2:{s:4:"rows";i:20;s:12:"summary_rows";i:5;}s:6:"weight";s:2:"-4";s:6:"module";s:4:"text";}s:8:"settings";a:3:{s:15:"display_summary";b:1;s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:7:"display";a:2:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";s:1:"0";s:8:"settings";a:0:{}s:6:"module";s:4:"text";}s:6:"teaser";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:23:"text_summary_or_trimmed";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:6:"module";s:4:"text";s:6:"weight";i:0;}}s:8:"required";b:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '3',
  'field_id' => '3',
  'field_name' => 'field_block_reference',
  'entity_type' => 'node',
  'bundle' => 'page',
  'data' => 'a:7:{s:5:"label";s:15:"Block reference";s:6:"widget";a:5:{s:6:"weight";s:2:"-3";s:4:"type";s:27:"blockreference_autocomplete";s:6:"module";s:14:"blockreference";s:6:"active";i:1;s:8:"settings";a:3:{s:30:"blockreference_ac_match_method";s:8:"contains";s:4:"size";i:60;s:17:"autocomplete_path";s:27:"blockreference/autocomplete";}}s:8:"settings";a:2:{s:22:"blockreference_modules";a:5:{s:4:"bean";s:4:"bean";s:5:"block";i:0;s:4:"node";i:0;s:6:"system";i:0;s:4:"user";i:0;}s:18:"user_register_form";b:0;}s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:5:"above";s:4:"type";s:28:"blockreference_without_title";s:6:"weight";s:1:"1";s:8:"settings";a:1:{s:17:"show_empty_blocks";i:0;}s:6:"module";s:14:"blockreference";}}s:8:"required";i:0;s:11:"description";s:26:"Only one selection allowed";s:13:"default_value";N;}',
  'deleted' => '0',
))
->values(array(
  'id' => '4',
  'field_id' => '4',
  'field_name' => 'field_block_reference_multi',
  'entity_type' => 'node',
  'bundle' => 'page',
  'data' => 'a:7:{s:5:"label";s:21:"Block reference multi";s:6:"widget";a:5:{s:6:"weight";s:2:"-2";s:4:"type";s:14:"options_select";s:6:"module";s:7:"options";s:6:"active";i:1;s:8:"settings";a:0:{}}s:8:"settings";a:2:{s:22:"blockreference_modules";a:5:{s:4:"bean";s:4:"bean";s:5:"block";i:0;s:4:"node";i:0;s:6:"system";i:0;s:4:"user";i:0;}s:18:"user_register_form";b:0;}s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:5:"above";s:4:"type";s:28:"blockreference_without_title";s:6:"weight";s:1:"2";s:8:"settings";a:1:{s:17:"show_empty_blocks";b:0;}s:6:"module";s:14:"blockreference";}}s:8:"required";i:0;s:11:"description";s:27:"Up to 3 selections allowed.";s:13:"default_value";N;}',
  'deleted' => '0',
))
->values(array(
  'id' => '5',
  'field_id' => '5',
  'field_name' => 'field_image',
  'entity_type' => 'bean',
  'bundle' => 'image',
  'data' => 'a:6:{s:5:"label";s:5:"Image";s:6:"widget";a:5:{s:6:"weight";s:2:"11";s:4:"type";s:11:"image_image";s:6:"module";s:5:"image";s:6:"active";i:1;s:8:"settings";a:2:{s:18:"progress_indicator";s:8:"throbber";s:19:"preview_image_style";s:9:"thumbnail";}}s:8:"settings";a:9:{s:14:"file_directory";s:6:"images";s:15:"file_extensions";s:16:"png gif jpg jpeg";s:12:"max_filesize";s:0:"";s:14:"max_resolution";s:0:"";s:14:"min_resolution";s:0:"";s:9:"alt_field";i:0;s:11:"title_field";i:0;s:13:"default_image";i:0;s:18:"user_register_form";b:0;}s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:5:"image";s:6:"weight";s:1:"0";s:8:"settings";a:2:{s:11:"image_style";s:6:"medium";s:10:"image_link";s:0:"";}s:6:"module";s:5:"image";}}s:8:"required";i:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->execute();
$connection->schema()->createTable('field_data_node_body', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'node_body_value' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'node_body_summary' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'node_body_format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'node_body_format' => array(
      array(
        'node_body_format',
        '191',
      ),
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_data_node_body')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'node_body_value',
  'node_body_summary',
  'node_body_format',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'page',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'und',
  'delta' => '0',
  'node_body_value' => 'Copy of basic page #1.',
  'node_body_summary' => '',
  'node_body_format' => 'plain_text',
))
->execute();
$connection->schema()->createTable('field_data_field_block_reference', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_block_reference_moddelta' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '129',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'field_block_reference_moddelta' => array(
      'field_block_reference_moddelta',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_data_field_block_reference')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'field_block_reference_moddelta',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'page',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'und',
  'delta' => '0',
  'field_block_reference_moddelta' => 'bean:yellow-image',
))
->execute();
$connection->schema()->createTable('field_data_field_block_reference_multi', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_block_reference_multi_moddelta' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '129',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'field_block_reference_multi_moddelta' => array(
      'field_block_reference_multi_moddelta',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_data_field_block_reference_multi')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'field_block_reference_multi_moddelta',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'page',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'und',
  'delta' => '0',
  'field_block_reference_multi_moddelta' => 'bean:admin-label-of-bean-block-1',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'page',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'und',
  'delta' => '1',
  'field_block_reference_multi_moddelta' => 'bean:admin-label-of-bean-block-2-rev-',
))
->execute();
$connection->schema()->createTable('field_data_field_body', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_body_value' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'field_body_format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'field_body_format' => array(
      array(
        'field_body_format',
        '191',
      ),
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_data_field_body')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'field_body_value',
  'field_body_format',
))
->values(array(
  'entity_type' => 'bean',
  'bundle' => 'simple',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'und',
  'delta' => '0',
  'field_body_value' => 'Copy of Bean block #1: a simple bean block with default view mode and with a filtered text format.',
  'field_body_format' => 'filtered_html',
))
->values(array(
  'entity_type' => 'bean',
  'bundle' => 'simple',
  'deleted' => '0',
  'entity_id' => '2',
  'revision_id' => '3',
  'language' => 'und',
  'delta' => '0',
  'field_body_value' => 'Copy of Bean block #2 (rev 2): view_mode changed from compact to default; text format is still plain text.',
  'field_body_format' => 'plain_text',
))
->values(array(
  'entity_type' => 'bean',
  'bundle' => 'simple',
  'deleted' => '0',
  'entity_id' => '4',
  'revision_id' => '5',
  'language' => 'und',
  'delta' => '0',
  'field_body_value' => 'Body of Bean #4 (rev 1)',
  'field_body_format' => 'plain_text',
))
->execute();
$connection->schema()->createTable('field_data_field_image', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_image_fid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_image_alt' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '512',
    ),
    'field_image_title' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '1024',
    ),
    'field_image_width' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_image_height' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'field_image_fid' => array(
      'field_image_fid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_data_field_image')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'field_image_fid',
  'field_image_alt',
  'field_image_title',
  'field_image_width',
  'field_image_height',
))
->values(array(
  'entity_type' => 'bean',
  'bundle' => 'image',
  'deleted' => '0',
  'entity_id' => '3',
  'revision_id' => '4',
  'language' => 'und',
  'delta' => '0',
  'field_image_fid' => '1',
  'field_image_alt' => '',
  'field_image_title' => '',
  'field_image_width' => '640',
  'field_image_height' => '400',
))
->execute();
$connection->schema()->createTable('field_revision_node_body', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'node_body_value' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'node_body_summary' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'node_body_format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'revision_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'node_body_format' => array(
      array(
        'node_body_format',
        '191',
      ),
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_revision_node_body')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'node_body_value',
  'node_body_summary',
  'node_body_format',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'page',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'und',
  'delta' => '0',
  'node_body_value' => 'Copy of basic page #1.',
  'node_body_summary' => '',
  'node_body_format' => 'plain_text',
))
->execute();
$connection->schema()->createTable('field_revision_field_block_reference', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_block_reference_moddelta' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '129',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'revision_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'field_block_reference_moddelta' => array(
      'field_block_reference_moddelta',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_revision_field_block_reference')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'field_block_reference_moddelta',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'page',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'und',
  'delta' => '0',
  'field_block_reference_moddelta' => 'bean:yellow-image',
))
->execute();
$connection->schema()->createTable('field_revision_field_block_reference_multi', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_block_reference_multi_moddelta' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '129',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'revision_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'field_block_reference_multi_moddelta' => array(
      'field_block_reference_multi_moddelta',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_revision_field_block_reference_multi')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'field_block_reference_multi_moddelta',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'page',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'und',
  'delta' => '0',
  'field_block_reference_multi_moddelta' => 'bean:admin-label-of-bean-block-1',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'page',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'und',
  'delta' => '1',
  'field_block_reference_multi_moddelta' => 'bean:admin-label-of-bean-block-2-rev-',
))
->execute();
$connection->schema()->createTable('field_revision_field_body', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_body_value' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'field_body_format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'revision_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'field_body_format' => array(
      array(
        'field_body_format',
        '191',
      ),
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_revision_field_body')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'field_body_value',
  'field_body_format',
))
->values(array(
  'entity_type' => 'bean',
  'bundle' => 'simple',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'und',
  'delta' => '0',
  'field_body_value' => 'Copy of Bean block #1: a simple bean block with default view mode and with a filtered text format.',
  'field_body_format' => 'filtered_html',
))
->values(array(
  'entity_type' => 'bean',
  'bundle' => 'simple',
  'deleted' => '0',
  'entity_id' => '2',
  'revision_id' => '2',
  'language' => 'und',
  'delta' => '0',
  'field_body_value' => 'Copy of Bean block #2 (rev 1): compact view_mode, plain text format.',
  'field_body_format' => 'plain_text',
))
->values(array(
  'entity_type' => 'bean',
  'bundle' => 'simple',
  'deleted' => '0',
  'entity_id' => '2',
  'revision_id' => '3',
  'language' => 'und',
  'delta' => '0',
  'field_body_value' => 'Copy of Bean block #2 (rev 2): view_mode changed from compact to default; text format is still plain text.',
  'field_body_format' => 'plain_text',
))
->values(array(
  'entity_type' => 'bean',
  'bundle' => 'simple',
  'deleted' => '0',
  'entity_id' => '4',
  'revision_id' => '5',
  'language' => 'und',
  'delta' => '0',
  'field_body_value' => 'Body of Bean #4 (rev 1)',
  'field_body_format' => 'plain_text',
))
->values(array(
  'entity_type' => 'bean',
  'bundle' => 'simple',
  'deleted' => '0',
  'entity_id' => '4',
  'revision_id' => '6',
  'language' => 'und',
  'delta' => '0',
  'field_body_value' => 'Body of Bean #4 (rev 2)',
  'field_body_format' => 'plain_text',
))
->execute();
$connection->schema()->createTable('field_revision_field_image', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_image_fid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_image_alt' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '512',
    ),
    'field_image_title' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '1024',
    ),
    'field_image_width' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_image_height' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'revision_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'field_image_fid' => array(
      'field_image_fid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_revision_field_image')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'field_image_fid',
  'field_image_alt',
  'field_image_title',
  'field_image_width',
  'field_image_height',
))
->values(array(
  'entity_type' => 'bean',
  'bundle' => 'image',
  'deleted' => '0',
  'entity_id' => '3',
  'revision_id' => '4',
  'language' => 'und',
  'delta' => '0',
  'field_image_fid' => '1',
  'field_image_alt' => '',
  'field_image_title' => '',
  'field_image_width' => '640',
  'field_image_height' => '400',
))
->execute();
$connection->schema()->createTable('file_managed', array(
  'fields' => array(
    'fid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'filename' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'uri' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'filemime' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'filesize' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'big',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'uuid' => array(
      'type' => 'char',
      'not null' => TRUE,
      'length' => '36',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'fid',
  ),
  'unique keys' => array(
    'uri' => array(
      'uri',
    ),
  ),
  'indexes' => array(
    'uid' => array(
      'uid',
    ),
    'status' => array(
      'status',
    ),
    'timestamp' => array(
      'timestamp',
    ),
    'uuid' => array(
      'uuid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('file_managed')
->fields(array(
  'fid',
  'uid',
  'filename',
  'uri',
  'filemime',
  'filesize',
  'status',
  'timestamp',
  'uuid',
))
->values(array(
  'fid' => '1',
  'uid' => '1',
  'filename' => 'yellow.jpg',
  'uri' => 'public://images/yellow.jpg',
  'filemime' => 'image/jpeg',
  'filesize' => '5363',
  'status' => '1',
  'timestamp' => '1611056822',
  'uuid' => '5975f1a4-8b96-4968-b23f-11ccf301604f',
))
->execute();
$connection->schema()->createTable('file_usage', array(
  'fields' => array(
    'fid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'count' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'fid',
    'type',
    'id',
    'module',
  ),
  'indexes' => array(
    'type_id' => array(
      'type',
      'id',
    ),
    'fid_count' => array(
      'fid',
      'count',
    ),
    'fid_module' => array(
      'fid',
      array(
        'module',
        '191',
      ),
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('file_usage')
->fields(array(
  'fid',
  'module',
  'type',
  'id',
  'count',
))
->values(array(
  'fid' => '1',
  'module' => 'file',
  'type' => 'bean',
  'id' => '3',
  'count' => '1',
))
->execute();
$connection->schema()->createTable('filter', array(
  'fields' => array(
    'format' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'settings' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'format',
    'name',
  ),
  'indexes' => array(
    'list' => array(
      'weight',
      'module',
      'name',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('filter')
->fields(array(
  'format',
  'module',
  'name',
  'weight',
  'status',
  'settings',
))
->values(array(
  'format' => 'filtered_html',
  'module' => 'filter',
  'name' => 'filter_autop',
  'weight' => '2',
  'status' => '1',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'filtered_html',
  'module' => 'filter',
  'name' => 'filter_html',
  'weight' => '1',
  'status' => '1',
  'settings' => 'a:3:{s:12:"allowed_html";s:37:"<div> <span> <ul> <li> <ol> <a> <img>";s:16:"filter_html_help";i:1;s:20:"filter_html_nofollow";i:0;}',
))
->values(array(
  'format' => 'filtered_html',
  'module' => 'filter',
  'name' => 'filter_htmlcorrector',
  'weight' => '10',
  'status' => '1',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'filtered_html',
  'module' => 'filter',
  'name' => 'filter_html_escape',
  'weight' => '-10',
  'status' => '0',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'filtered_html',
  'module' => 'filter',
  'name' => 'filter_url',
  'weight' => '0',
  'status' => '1',
  'settings' => 'a:1:{s:17:"filter_url_length";s:3:"128";}',
))
->values(array(
  'format' => 'plain_text',
  'module' => 'filter',
  'name' => 'filter_autop',
  'weight' => '2',
  'status' => '1',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'plain_text',
  'module' => 'filter',
  'name' => 'filter_html',
  'weight' => '-10',
  'status' => '0',
  'settings' => 'a:3:{s:12:"allowed_html";s:74:"<a> <em> <strong> <cite> <blockquote> <code> <ul> <ol> <li> <dl> <dt> <dd>";s:16:"filter_html_help";i:1;s:20:"filter_html_nofollow";i:0;}',
))
->values(array(
  'format' => 'plain_text',
  'module' => 'filter',
  'name' => 'filter_htmlcorrector',
  'weight' => '10',
  'status' => '0',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'plain_text',
  'module' => 'filter',
  'name' => 'filter_html_escape',
  'weight' => '0',
  'status' => '1',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'plain_text',
  'module' => 'filter',
  'name' => 'filter_url',
  'weight' => '1',
  'status' => '1',
  'settings' => 'a:1:{s:17:"filter_url_length";i:72;}',
))
->execute();
$connection->schema()->createTable('filter_format', array(
  'fields' => array(
    'format' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'cache' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '1',
      'unsigned' => TRUE,
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'format',
  ),
  'unique keys' => array(
    'name' => array(
      'name',
    ),
  ),
  'indexes' => array(
    'status_weight' => array(
      'status',
      'weight',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('filter_format')
->fields(array(
  'format',
  'name',
  'cache',
  'status',
  'weight',
))
->values(array(
  'format' => 'filtered_html',
  'name' => 'Filtered HTML',
  'cache' => '1',
  'status' => '1',
  'weight' => '0',
))
->values(array(
  'format' => 'plain_text',
  'name' => 'Plain text',
  'cache' => '1',
  'status' => '1',
  'weight' => '10',
))
->execute();
$connection->schema()->createTable('flood', array(
  'fields' => array(
    'fid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'event' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'identifier' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'expiration' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'fid',
  ),
  'indexes' => array(
    'allow' => array(
      'event',
      'identifier',
      'timestamp',
    ),
    'purge' => array(
      'expiration',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('history', array(
  'fields' => array(
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'uid',
    'nid',
  ),
  'indexes' => array(
    'nid' => array(
      'nid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('history')
->fields(array(
  'uid',
  'nid',
  'timestamp',
))
->values(array(
  'uid' => '1',
  'nid' => '1',
  'timestamp' => '1611057214',
))
->execute();
$connection->schema()->createTable('image_effects', array(
  'fields' => array(
    'ieid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'isid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'ieid',
  ),
  'indexes' => array(
    'isid' => array(
      'isid',
    ),
    'weight' => array(
      'weight',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('image_styles', array(
  'fields' => array(
    'isid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'label' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'isid',
  ),
  'unique keys' => array(
    'name' => array(
      'name',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('menu_links', array(
  'fields' => array(
    'menu_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'mlid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'plid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'link_path' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'router_path' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'link_title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'options' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => 'system',
    ),
    'hidden' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'external' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'has_children' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'expanded' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'depth' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'customized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'p1' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p2' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p3' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p4' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p5' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p6' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p7' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p8' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p9' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'updated' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'mlid',
  ),
  'indexes' => array(
    'path_menu' => array(
      array(
        'link_path',
        '128',
      ),
      'menu_name',
    ),
    'menu_plid_expand_child' => array(
      'menu_name',
      'plid',
      'expanded',
      'has_children',
    ),
    'menu_parents' => array(
      'menu_name',
      'p1',
      'p2',
      'p3',
      'p4',
      'p5',
      'p6',
      'p7',
      'p8',
      'p9',
    ),
    'router_path' => array(
      array(
        'router_path',
        '128',
      ),
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('menu_links')
->fields(array(
  'menu_name',
  'mlid',
  'plid',
  'link_path',
  'router_path',
  'link_title',
  'options',
  'module',
  'hidden',
  'external',
  'has_children',
  'expanded',
  'weight',
  'depth',
  'customized',
  'p1',
  'p2',
  'p3',
  'p4',
  'p5',
  'p6',
  'p7',
  'p8',
  'p9',
  'updated',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '1',
  'plid' => '0',
  'link_path' => 'admin',
  'router_path' => 'admin',
  'link_title' => 'Administration',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '9',
  'depth' => '1',
  'customized' => '0',
  'p1' => '1',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'user-menu',
  'mlid' => '2',
  'plid' => '0',
  'link_path' => 'user',
  'router_path' => 'user',
  'link_title' => 'User account',
  'options' => 'a:1:{s:5:"alter";b:1;}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '1',
  'customized' => '0',
  'p1' => '2',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '3',
  'plid' => '0',
  'link_path' => 'filter/tips',
  'router_path' => 'filter/tips',
  'link_title' => 'Compose tips',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '3',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '4',
  'plid' => '0',
  'link_path' => 'node/%',
  'router_path' => 'node/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '4',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '5',
  'plid' => '0',
  'link_path' => 'node/add',
  'router_path' => 'node/add',
  'link_title' => 'Add content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '5',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '6',
  'plid' => '1',
  'link_path' => 'admin/appearance',
  'router_path' => 'admin/appearance',
  'link_title' => 'Appearance',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:33:"Select and configure your themes.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-6',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '6',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '7',
  'plid' => '1',
  'link_path' => 'admin/config',
  'router_path' => 'admin/config',
  'link_title' => 'Configuration',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:20:"Administer settings.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '8',
  'plid' => '1',
  'link_path' => 'admin/content',
  'router_path' => 'admin/content',
  'link_title' => 'Content',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:24:"Find and manage content.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'user-menu',
  'mlid' => '9',
  'plid' => '2',
  'link_path' => 'user/register',
  'router_path' => 'user/register',
  'link_title' => 'Create new account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '2',
  'p2' => '9',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '10',
  'plid' => '1',
  'link_path' => 'admin/index',
  'router_path' => 'admin/index',
  'link_title' => 'Index',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-18',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '10',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'user-menu',
  'mlid' => '11',
  'plid' => '2',
  'link_path' => 'user/login',
  'router_path' => 'user/login',
  'link_title' => 'Log in',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '2',
  'p2' => '11',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'user-menu',
  'mlid' => '12',
  'plid' => '0',
  'link_path' => 'user/logout',
  'router_path' => 'user/logout',
  'link_title' => 'Log out',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '1',
  'customized' => '0',
  'p1' => '12',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '13',
  'plid' => '1',
  'link_path' => 'admin/modules',
  'router_path' => 'admin/modules',
  'link_title' => 'Modules',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:26:"Extend site functionality.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-2',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '13',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '14',
  'plid' => '0',
  'link_path' => 'user/%',
  'router_path' => 'user/%',
  'link_title' => 'My account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '14',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '15',
  'plid' => '1',
  'link_path' => 'admin/people',
  'router_path' => 'admin/people',
  'link_title' => 'People',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:45:"Manage user accounts, roles, and permissions.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-4',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '16',
  'plid' => '1',
  'link_path' => 'admin/reports',
  'router_path' => 'admin/reports',
  'link_title' => 'Reports',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:34:"View reports, updates, and errors.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '16',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'user-menu',
  'mlid' => '17',
  'plid' => '2',
  'link_path' => 'user/password',
  'router_path' => 'user/password',
  'link_title' => 'Request new password',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '2',
  'p2' => '17',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '18',
  'plid' => '1',
  'link_path' => 'admin/structure',
  'router_path' => 'admin/structure',
  'link_title' => 'Structure',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:45:"Administer blocks, content types, menus, etc.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-8',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '19',
  'plid' => '1',
  'link_path' => 'admin/tasks',
  'router_path' => 'admin/tasks',
  'link_title' => 'Tasks',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '19',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '20',
  'plid' => '3',
  'link_path' => 'filter/tips/%',
  'router_path' => 'filter/tips/%',
  'link_title' => 'Compose tips',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '3',
  'p2' => '20',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '21',
  'plid' => '15',
  'link_path' => 'admin/people/create',
  'router_path' => 'admin/people/create',
  'link_title' => 'Add user',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '21',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '22',
  'plid' => '18',
  'link_path' => 'admin/structure/block',
  'router_path' => 'admin/structure/block',
  'link_title' => 'Blocks',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:79:\"Configure what block content appears in your site's sidebars and other regions.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '22',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '23',
  'plid' => '14',
  'link_path' => 'user/%/cancel',
  'router_path' => 'user/%/cancel',
  'link_title' => 'Cancel account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '14',
  'p2' => '23',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '24',
  'plid' => '8',
  'link_path' => 'admin/content/node',
  'router_path' => 'admin/content/node',
  'link_title' => 'Content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '24',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '25',
  'plid' => '7',
  'link_path' => 'admin/config/content',
  'router_path' => 'admin/config/content',
  'link_title' => 'Content authoring',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:53:"Settings related to formatting and authoring content.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-15',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '25',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '26',
  'plid' => '18',
  'link_path' => 'admin/structure/types',
  'router_path' => 'admin/structure/types',
  'link_title' => 'Content types',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:92:"Manage content types, including default status, front page promotion, comment settings, etc.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '26',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '27',
  'plid' => '4',
  'link_path' => 'node/%/delete',
  'router_path' => 'node/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '2',
  'customized' => '0',
  'p1' => '4',
  'p2' => '27',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '28',
  'plid' => '7',
  'link_path' => 'admin/config/development',
  'router_path' => 'admin/config/development',
  'link_title' => 'Development',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:18:"Development tools.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '28',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '29',
  'plid' => '14',
  'link_path' => 'user/%/edit',
  'router_path' => 'user/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '14',
  'p2' => '29',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '30',
  'plid' => '4',
  'link_path' => 'node/%/edit',
  'router_path' => 'node/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '4',
  'p2' => '30',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '31',
  'plid' => '13',
  'link_path' => 'admin/modules/list',
  'router_path' => 'admin/modules/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '13',
  'p3' => '31',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '32',
  'plid' => '15',
  'link_path' => 'admin/people/people',
  'router_path' => 'admin/people/people',
  'link_title' => 'List',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:50:"Find and manage people interacting with your site.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '32',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '33',
  'plid' => '6',
  'link_path' => 'admin/appearance/list',
  'router_path' => 'admin/appearance/list',
  'link_title' => 'List',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:31:"Select and configure your theme";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-1',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '6',
  'p3' => '33',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '34',
  'plid' => '7',
  'link_path' => 'admin/config/media',
  'router_path' => 'admin/config/media',
  'link_title' => 'Media',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:12:"Media tools.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '34',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '35',
  'plid' => '7',
  'link_path' => 'admin/config/people',
  'router_path' => 'admin/config/people',
  'link_title' => 'People',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:24:"Configure user accounts.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '35',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '36',
  'plid' => '15',
  'link_path' => 'admin/people/permissions',
  'router_path' => 'admin/people/permissions',
  'link_title' => 'Permissions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:64:"Determine access to features by selecting permissions for roles.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '36',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '38',
  'plid' => '7',
  'link_path' => 'admin/config/regional',
  'router_path' => 'admin/config/regional',
  'link_title' => 'Regional and language',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:48:"Regional settings, localization and translation.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-5',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '38',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '39',
  'plid' => '4',
  'link_path' => 'node/%/revisions',
  'router_path' => 'node/%/revisions',
  'link_title' => 'Revisions',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '2',
  'customized' => '0',
  'p1' => '4',
  'p2' => '39',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '40',
  'plid' => '7',
  'link_path' => 'admin/config/search',
  'router_path' => 'admin/config/search',
  'link_title' => 'Search and metadata',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:36:"Local site search, metadata and SEO.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '40',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '41',
  'plid' => '6',
  'link_path' => 'admin/appearance/settings',
  'router_path' => 'admin/appearance/settings',
  'link_title' => 'Settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:46:"Configure default and theme specific settings.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '20',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '6',
  'p3' => '41',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '42',
  'plid' => '16',
  'link_path' => 'admin/reports/status',
  'router_path' => 'admin/reports/status',
  'link_title' => 'Status report',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:74:\"Get a status report about your site's operation and any detected problems.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-60',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '16',
  'p3' => '42',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '43',
  'plid' => '7',
  'link_path' => 'admin/config/system',
  'router_path' => 'admin/config/system',
  'link_title' => 'System',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:37:"General system related configuration.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '43',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '46',
  'plid' => '13',
  'link_path' => 'admin/modules/uninstall',
  'router_path' => 'admin/modules/uninstall',
  'link_title' => 'Uninstall',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '20',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '13',
  'p3' => '46',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '47',
  'plid' => '7',
  'link_path' => 'admin/config/user-interface',
  'router_path' => 'admin/config/user-interface',
  'link_title' => 'User interface',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:38:"Tools that enhance the user interface.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-15',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '47',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '48',
  'plid' => '4',
  'link_path' => 'node/%/view',
  'router_path' => 'node/%/view',
  'link_title' => 'View',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '4',
  'p2' => '48',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '49',
  'plid' => '14',
  'link_path' => 'user/%/view',
  'router_path' => 'user/%/view',
  'link_title' => 'View',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '14',
  'p2' => '49',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '50',
  'plid' => '7',
  'link_path' => 'admin/config/services',
  'router_path' => 'admin/config/services',
  'link_title' => 'Web services',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:30:"Tools related to web services.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '50',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '51',
  'plid' => '7',
  'link_path' => 'admin/config/workflow',
  'router_path' => 'admin/config/workflow',
  'link_title' => 'Workflow',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:43:"Content workflow, editorial workflow tools.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '51',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '52',
  'plid' => '35',
  'link_path' => 'admin/config/people/accounts',
  'router_path' => 'admin/config/people/accounts',
  'link_title' => 'Account settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:109:"Configure default behavior of users, including registration requirements, e-mails, fields, and user pictures.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '35',
  'p4' => '52',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '53',
  'plid' => '43',
  'link_path' => 'admin/config/system/actions',
  'router_path' => 'admin/config/system/actions',
  'link_title' => 'Actions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:41:"Manage the actions defined for your site.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '43',
  'p4' => '53',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '54',
  'plid' => '22',
  'link_path' => 'admin/structure/block/add',
  'router_path' => 'admin/structure/block/add',
  'link_title' => 'Add block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '22',
  'p4' => '54',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '55',
  'plid' => '26',
  'link_path' => 'admin/structure/types/add',
  'router_path' => 'admin/structure/types/add',
  'link_title' => 'Add content type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '26',
  'p4' => '55',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '56',
  'plid' => '41',
  'link_path' => 'admin/appearance/settings/bartik',
  'router_path' => 'admin/appearance/settings/bartik',
  'link_title' => 'Bartik',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '6',
  'p3' => '41',
  'p4' => '56',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '57',
  'plid' => '40',
  'link_path' => 'admin/config/search/clean-urls',
  'router_path' => 'admin/config/search/clean-urls',
  'link_title' => 'Clean URLs',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:43:"Enable or disable clean URLs for your site.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '40',
  'p4' => '57',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '58',
  'plid' => '43',
  'link_path' => 'admin/config/system/cron',
  'router_path' => 'admin/config/system/cron',
  'link_title' => 'Cron',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:40:"Manage automatic site maintenance tasks.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '20',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '43',
  'p4' => '58',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '59',
  'plid' => '38',
  'link_path' => 'admin/config/regional/date-time',
  'router_path' => 'admin/config/regional/date-time',
  'link_title' => 'Date and time',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:44:"Configure display formats for date and time.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-15',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '38',
  'p4' => '59',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '61',
  'plid' => '34',
  'link_path' => 'admin/config/media/file-system',
  'router_path' => 'admin/config/media/file-system',
  'link_title' => 'File system',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:68:"Tell Drupal where to store uploaded files and how they are accessed.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '34',
  'p4' => '61',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '62',
  'plid' => '41',
  'link_path' => 'admin/appearance/settings/garland',
  'router_path' => 'admin/appearance/settings/garland',
  'link_title' => 'Garland',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '6',
  'p3' => '41',
  'p4' => '62',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '63',
  'plid' => '41',
  'link_path' => 'admin/appearance/settings/global',
  'router_path' => 'admin/appearance/settings/global',
  'link_title' => 'Global settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-1',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '6',
  'p3' => '41',
  'p4' => '63',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '64',
  'plid' => '35',
  'link_path' => 'admin/config/people/ip-blocking',
  'router_path' => 'admin/config/people/ip-blocking',
  'link_title' => 'IP address blocking',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:28:"Manage blocked IP addresses.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '35',
  'p4' => '64',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '65',
  'plid' => '34',
  'link_path' => 'admin/config/media/image-toolkit',
  'router_path' => 'admin/config/media/image-toolkit',
  'link_title' => 'Image toolkit',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:74:"Choose which image toolkit to use if you have installed optional toolkits.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '20',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '34',
  'p4' => '65',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '66',
  'plid' => '26',
  'link_path' => 'admin/structure/types/list',
  'router_path' => 'admin/structure/types/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '26',
  'p4' => '66',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '67',
  'plid' => '31',
  'link_path' => 'admin/modules/list/confirm',
  'router_path' => 'admin/modules/list/confirm',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '13',
  'p3' => '31',
  'p4' => '67',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '68',
  'plid' => '28',
  'link_path' => 'admin/config/development/logging',
  'router_path' => 'admin/config/development/logging',
  'link_title' => 'Logging and errors',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:154:\"Settings for logging and alerts modules. Various modules can route Drupal's system events to different destinations, such as syslog, database, email, etc.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-15',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '28',
  'p4' => '68',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '69',
  'plid' => '28',
  'link_path' => 'admin/config/development/maintenance',
  'router_path' => 'admin/config/development/maintenance',
  'link_title' => 'Maintenance mode',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:62:"Take the site offline for maintenance or bring it back online.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '28',
  'p4' => '69',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '70',
  'plid' => '28',
  'link_path' => 'admin/config/development/performance',
  'router_path' => 'admin/config/development/performance',
  'link_title' => 'Performance',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:101:"Enable or disable page caching for anonymous users and set CSS and JS bandwidth optimization options.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '28',
  'p4' => '70',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '71',
  'plid' => '36',
  'link_path' => 'admin/people/permissions/list',
  'router_path' => 'admin/people/permissions/list',
  'link_title' => 'Permissions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:64:"Determine access to features by selecting permissions for roles.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-8',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '36',
  'p4' => '71',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '72',
  'plid' => '50',
  'link_path' => 'admin/config/services/rss-publishing',
  'router_path' => 'admin/config/services/rss-publishing',
  'link_title' => 'RSS publishing',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:114:"Configure the site description, the number of items per feed and whether feeds should be titles/teasers/full-text.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '50',
  'p4' => '72',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '73',
  'plid' => '38',
  'link_path' => 'admin/config/regional/settings',
  'router_path' => 'admin/config/regional/settings',
  'link_title' => 'Regional settings',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:54:\"Settings for the site's default time zone and country.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '38',
  'p4' => '73',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '74',
  'plid' => '36',
  'link_path' => 'admin/people/permissions/roles',
  'router_path' => 'admin/people/permissions/roles',
  'link_title' => 'Roles',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:30:"List, edit, or add user roles.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-5',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '36',
  'p4' => '74',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '75',
  'plid' => '41',
  'link_path' => 'admin/appearance/settings/seven',
  'router_path' => 'admin/appearance/settings/seven',
  'link_title' => 'Seven',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '6',
  'p3' => '41',
  'p4' => '75',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '76',
  'plid' => '43',
  'link_path' => 'admin/config/system/site-information',
  'router_path' => 'admin/config/system/site-information',
  'link_title' => 'Site information',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:104:"Change site name, e-mail address, slogan, default front page, and number of posts per page, error pages.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '43',
  'p4' => '76',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '77',
  'plid' => '41',
  'link_path' => 'admin/appearance/settings/stark',
  'router_path' => 'admin/appearance/settings/stark',
  'link_title' => 'Stark',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '6',
  'p3' => '41',
  'p4' => '77',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '78',
  'plid' => '25',
  'link_path' => 'admin/config/content/formats',
  'router_path' => 'admin/config/content/formats',
  'link_title' => 'Text formats',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:127:"Configure how content input by users is filtered, including allowed HTML tags. Also allows enabling of module-provided filters.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '25',
  'p4' => '78',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '79',
  'plid' => '46',
  'link_path' => 'admin/modules/uninstall/confirm',
  'router_path' => 'admin/modules/uninstall/confirm',
  'link_title' => 'Uninstall',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '13',
  'p3' => '46',
  'p4' => '79',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '80',
  'plid' => '29',
  'link_path' => 'user/%/edit/account',
  'router_path' => 'user/%/edit/account',
  'link_title' => 'Account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '14',
  'p2' => '29',
  'p3' => '80',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '81',
  'plid' => '78',
  'link_path' => 'admin/config/content/formats/%',
  'router_path' => 'admin/config/content/formats/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '25',
  'p4' => '78',
  'p5' => '81',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '82',
  'plid' => '78',
  'link_path' => 'admin/config/content/formats/add',
  'router_path' => 'admin/config/content/formats/add',
  'link_title' => 'Add text format',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '25',
  'p4' => '78',
  'p5' => '82',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '83',
  'plid' => '22',
  'link_path' => 'admin/structure/block/list/bartik',
  'router_path' => 'admin/structure/block/list/bartik',
  'link_title' => 'Bartik',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '22',
  'p4' => '83',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '84',
  'plid' => '53',
  'link_path' => 'admin/config/system/actions/configure',
  'router_path' => 'admin/config/system/actions/configure',
  'link_title' => 'Configure an advanced action',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '43',
  'p4' => '53',
  'p5' => '84',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '85',
  'plid' => '26',
  'link_path' => 'admin/structure/types/manage/%',
  'router_path' => 'admin/structure/types/manage/%',
  'link_title' => 'Edit content type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '26',
  'p4' => '85',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '86',
  'plid' => '59',
  'link_path' => 'admin/config/regional/date-time/formats',
  'router_path' => 'admin/config/regional/date-time/formats',
  'link_title' => 'Formats',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:51:"Configure display format strings for date and time.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-9',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '38',
  'p4' => '59',
  'p5' => '86',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '87',
  'plid' => '22',
  'link_path' => 'admin/structure/block/list/garland',
  'router_path' => 'admin/structure/block/list/garland',
  'link_title' => 'Garland',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '22',
  'p4' => '87',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '88',
  'plid' => '78',
  'link_path' => 'admin/config/content/formats/list',
  'router_path' => 'admin/config/content/formats/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '25',
  'p4' => '78',
  'p5' => '88',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '89',
  'plid' => '53',
  'link_path' => 'admin/config/system/actions/manage',
  'router_path' => 'admin/config/system/actions/manage',
  'link_title' => 'Manage actions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:41:"Manage the actions defined for your site.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-2',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '43',
  'p4' => '53',
  'p5' => '89',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '90',
  'plid' => '52',
  'link_path' => 'admin/config/people/accounts/settings',
  'router_path' => 'admin/config/people/accounts/settings',
  'link_title' => 'Settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '35',
  'p4' => '52',
  'p5' => '90',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '91',
  'plid' => '22',
  'link_path' => 'admin/structure/block/list/seven',
  'router_path' => 'admin/structure/block/list/seven',
  'link_title' => 'Seven',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '22',
  'p4' => '91',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '92',
  'plid' => '22',
  'link_path' => 'admin/structure/block/list/stark',
  'router_path' => 'admin/structure/block/list/stark',
  'link_title' => 'Stark',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '22',
  'p4' => '92',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '93',
  'plid' => '59',
  'link_path' => 'admin/config/regional/date-time/types',
  'router_path' => 'admin/config/regional/date-time/types',
  'link_title' => 'Types',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:44:"Configure display formats for date and time.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '38',
  'p4' => '59',
  'p5' => '93',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '94',
  'plid' => '39',
  'link_path' => 'node/%/revisions/%/delete',
  'router_path' => 'node/%/revisions/%/delete',
  'link_title' => 'Delete earlier revision',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '4',
  'p2' => '39',
  'p3' => '94',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '95',
  'plid' => '39',
  'link_path' => 'node/%/revisions/%/revert',
  'router_path' => 'node/%/revisions/%/revert',
  'link_title' => 'Revert to earlier revision',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '4',
  'p2' => '39',
  'p3' => '95',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '96',
  'plid' => '39',
  'link_path' => 'node/%/revisions/%/view',
  'router_path' => 'node/%/revisions/%/view',
  'link_title' => 'Revisions',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '4',
  'p2' => '39',
  'p3' => '96',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '97',
  'plid' => '87',
  'link_path' => 'admin/structure/block/list/garland/add',
  'router_path' => 'admin/structure/block/list/garland/add',
  'link_title' => 'Add block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '22',
  'p4' => '87',
  'p5' => '97',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '98',
  'plid' => '91',
  'link_path' => 'admin/structure/block/list/seven/add',
  'router_path' => 'admin/structure/block/list/seven/add',
  'link_title' => 'Add block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '22',
  'p4' => '91',
  'p5' => '98',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '99',
  'plid' => '92',
  'link_path' => 'admin/structure/block/list/stark/add',
  'router_path' => 'admin/structure/block/list/stark/add',
  'link_title' => 'Add block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '22',
  'p4' => '92',
  'p5' => '99',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '100',
  'plid' => '93',
  'link_path' => 'admin/config/regional/date-time/types/add',
  'router_path' => 'admin/config/regional/date-time/types/add',
  'link_title' => 'Add date type',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:18:"Add new date type.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '38',
  'p4' => '59',
  'p5' => '93',
  'p6' => '100',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '101',
  'plid' => '86',
  'link_path' => 'admin/config/regional/date-time/formats/add',
  'router_path' => 'admin/config/regional/date-time/formats/add',
  'link_title' => 'Add format',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:43:"Allow users to add additional date formats.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '38',
  'p4' => '59',
  'p5' => '86',
  'p6' => '101',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '102',
  'plid' => '22',
  'link_path' => 'admin/structure/block/manage/%/%',
  'router_path' => 'admin/structure/block/manage/%/%',
  'link_title' => 'Configure block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '22',
  'p4' => '102',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '103',
  'plid' => '23',
  'link_path' => 'user/%/cancel/confirm/%/%',
  'router_path' => 'user/%/cancel/confirm/%/%',
  'link_title' => 'Confirm account cancellation',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '14',
  'p2' => '23',
  'p3' => '103',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '104',
  'plid' => '85',
  'link_path' => 'admin/structure/types/manage/%/delete',
  'router_path' => 'admin/structure/types/manage/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '26',
  'p4' => '85',
  'p5' => '104',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '105',
  'plid' => '64',
  'link_path' => 'admin/config/people/ip-blocking/delete/%',
  'router_path' => 'admin/config/people/ip-blocking/delete/%',
  'link_title' => 'Delete IP address',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '35',
  'p4' => '64',
  'p5' => '105',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '106',
  'plid' => '53',
  'link_path' => 'admin/config/system/actions/delete/%',
  'router_path' => 'admin/config/system/actions/delete/%',
  'link_title' => 'Delete action',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:17:"Delete an action.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '43',
  'p4' => '53',
  'p5' => '106',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '107',
  'plid' => '74',
  'link_path' => 'admin/people/permissions/roles/delete/%',
  'router_path' => 'admin/people/permissions/roles/delete/%',
  'link_title' => 'Delete role',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '36',
  'p4' => '74',
  'p5' => '107',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '108',
  'plid' => '81',
  'link_path' => 'admin/config/content/formats/%/disable',
  'router_path' => 'admin/config/content/formats/%/disable',
  'link_title' => 'Disable text format',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '25',
  'p4' => '78',
  'p5' => '81',
  'p6' => '108',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '109',
  'plid' => '85',
  'link_path' => 'admin/structure/types/manage/%/edit',
  'router_path' => 'admin/structure/types/manage/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '26',
  'p4' => '85',
  'p5' => '109',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '110',
  'plid' => '74',
  'link_path' => 'admin/people/permissions/roles/edit/%',
  'router_path' => 'admin/people/permissions/roles/edit/%',
  'link_title' => 'Edit role',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '36',
  'p4' => '74',
  'p5' => '110',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '111',
  'plid' => '102',
  'link_path' => 'admin/structure/block/manage/%/%/configure',
  'router_path' => 'admin/structure/block/manage/%/%/configure',
  'link_title' => 'Configure block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '22',
  'p4' => '102',
  'p5' => '111',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '112',
  'plid' => '102',
  'link_path' => 'admin/structure/block/manage/%/%/delete',
  'router_path' => 'admin/structure/block/manage/%/%/delete',
  'link_title' => 'Delete block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '22',
  'p4' => '102',
  'p5' => '112',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '113',
  'plid' => '86',
  'link_path' => 'admin/config/regional/date-time/formats/%/delete',
  'router_path' => 'admin/config/regional/date-time/formats/%/delete',
  'link_title' => 'Delete date format',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:47:"Allow users to delete a configured date format.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '38',
  'p4' => '59',
  'p5' => '86',
  'p6' => '113',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '114',
  'plid' => '93',
  'link_path' => 'admin/config/regional/date-time/types/%/delete',
  'router_path' => 'admin/config/regional/date-time/types/%/delete',
  'link_title' => 'Delete date type',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:45:"Allow users to delete a configured date type.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '38',
  'p4' => '59',
  'p5' => '93',
  'p6' => '114',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '115',
  'plid' => '86',
  'link_path' => 'admin/config/regional/date-time/formats/%/edit',
  'router_path' => 'admin/config/regional/date-time/formats/%/edit',
  'link_title' => 'Edit date format',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:45:"Allow users to edit a configured date format.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '38',
  'p4' => '59',
  'p5' => '86',
  'p6' => '115',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '116',
  'plid' => '0',
  'link_path' => 'block/add',
  'router_path' => 'block/add',
  'link_title' => 'Add Block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '116',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '117',
  'plid' => '0',
  'link_path' => 'block/%',
  'router_path' => 'block/%',
  'link_title' => 'Block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '117',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '118',
  'plid' => '117',
  'link_path' => 'block/%/delete',
  'router_path' => 'block/%/delete',
  'link_title' => 'Delete Block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '2',
  'customized' => '0',
  'p1' => '117',
  'p2' => '118',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '119',
  'plid' => '117',
  'link_path' => 'block/%/edit',
  'router_path' => 'block/%/edit',
  'link_title' => 'Edit Block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '117',
  'p2' => '119',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '120',
  'plid' => '117',
  'link_path' => 'block/%/revisions',
  'router_path' => 'block/%/revisions',
  'link_title' => 'Revisions',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '117',
  'p2' => '120',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '121',
  'plid' => '117',
  'link_path' => 'block/%/view',
  'router_path' => 'block/%/view',
  'link_title' => 'View',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '2',
  'customized' => '0',
  'p1' => '117',
  'p2' => '121',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '122',
  'plid' => '8',
  'link_path' => 'admin/content/blocks',
  'router_path' => 'admin/content/blocks',
  'link_title' => 'Blocks',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:32:"Manage blocks used on your site.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '122',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '123',
  'plid' => '120',
  'link_path' => 'block/%/revisions/%',
  'router_path' => 'block/%/revisions/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '117',
  'p2' => '120',
  'p3' => '123',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '124',
  'plid' => '123',
  'link_path' => 'block/%/revisions/%/delete',
  'router_path' => 'block/%/revisions/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '4',
  'customized' => '0',
  'p1' => '117',
  'p2' => '120',
  'p3' => '123',
  'p4' => '124',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '125',
  'plid' => '123',
  'link_path' => 'block/%/revisions/%/edit',
  'router_path' => 'block/%/revisions/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '117',
  'p2' => '120',
  'p3' => '123',
  'p4' => '125',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '126',
  'plid' => '123',
  'link_path' => 'block/%/revisions/%/set-active',
  'router_path' => 'block/%/revisions/%/set-active',
  'link_title' => 'Set active',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '117',
  'p2' => '120',
  'p3' => '123',
  'p4' => '126',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '127',
  'plid' => '123',
  'link_path' => 'block/%/revisions/%/view',
  'router_path' => 'block/%/revisions/%/view',
  'link_title' => 'View',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '117',
  'p2' => '120',
  'p3' => '123',
  'p4' => '127',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '128',
  'plid' => '18',
  'link_path' => 'admin/structure/block-types',
  'router_path' => 'admin/structure/block-types',
  'link_title' => 'Block types',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:52:"Manage block types, including fields, settings, etc.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '128',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '129',
  'plid' => '128',
  'link_path' => 'admin/structure/block-types/add',
  'router_path' => 'admin/structure/block-types/add',
  'link_title' => 'Add block type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '128',
  'p4' => '129',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '130',
  'plid' => '128',
  'link_path' => 'admin/structure/block-types/list',
  'router_path' => 'admin/structure/block-types/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '128',
  'p4' => '130',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '131',
  'plid' => '128',
  'link_path' => 'admin/structure/block-types/manage/%',
  'router_path' => 'admin/structure/block-types/manage/%',
  'link_title' => 'Edit block type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '128',
  'p4' => '131',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '132',
  'plid' => '131',
  'link_path' => 'admin/structure/block-types/manage/%/delete',
  'router_path' => 'admin/structure/block-types/manage/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '128',
  'p4' => '131',
  'p5' => '132',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '133',
  'plid' => '131',
  'link_path' => 'admin/structure/block-types/manage/%/revert',
  'router_path' => 'admin/structure/block-types/manage/%/revert',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '128',
  'p4' => '131',
  'p5' => '133',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '134',
  'plid' => '131',
  'link_path' => 'admin/structure/block-types/manage/%/edit',
  'router_path' => 'admin/structure/block-types/manage/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '128',
  'p4' => '131',
  'p5' => '134',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '135',
  'plid' => '116',
  'link_path' => 'block/add/simple',
  'router_path' => 'block/add/simple',
  'link_title' => 'Simple',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '116',
  'p2' => '135',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '136',
  'plid' => '16',
  'link_path' => 'admin/reports/fields',
  'router_path' => 'admin/reports/fields',
  'link_title' => 'Field list',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:39:"Overview of fields on all entity types.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '16',
  'p3' => '136',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '137',
  'plid' => '52',
  'link_path' => 'admin/config/people/accounts/display',
  'router_path' => 'admin/config/people/accounts/display',
  'link_title' => 'Manage display',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '35',
  'p4' => '52',
  'p5' => '137',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '138',
  'plid' => '52',
  'link_path' => 'admin/config/people/accounts/fields',
  'router_path' => 'admin/config/people/accounts/fields',
  'link_title' => 'Manage fields',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '35',
  'p4' => '52',
  'p5' => '138',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '139',
  'plid' => '137',
  'link_path' => 'admin/config/people/accounts/display/default',
  'router_path' => 'admin/config/people/accounts/display/default',
  'link_title' => 'Default',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '35',
  'p4' => '52',
  'p5' => '137',
  'p6' => '139',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '140',
  'plid' => '131',
  'link_path' => 'admin/structure/block-types/manage/%/display',
  'router_path' => 'admin/structure/block-types/manage/%/display',
  'link_title' => 'Manage display',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '128',
  'p4' => '131',
  'p5' => '140',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '141',
  'plid' => '131',
  'link_path' => 'admin/structure/block-types/manage/%/fields',
  'router_path' => 'admin/structure/block-types/manage/%/fields',
  'link_title' => 'Manage fields',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '128',
  'p4' => '131',
  'p5' => '141',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '142',
  'plid' => '137',
  'link_path' => 'admin/config/people/accounts/display/full',
  'router_path' => 'admin/config/people/accounts/display/full',
  'link_title' => 'User account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '35',
  'p4' => '52',
  'p5' => '137',
  'p6' => '142',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '143',
  'plid' => '138',
  'link_path' => 'admin/config/people/accounts/fields/%',
  'router_path' => 'admin/config/people/accounts/fields/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '35',
  'p4' => '52',
  'p5' => '138',
  'p6' => '143',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '144',
  'plid' => '140',
  'link_path' => 'admin/structure/block-types/manage/%/display/default',
  'router_path' => 'admin/structure/block-types/manage/%/display/default',
  'link_title' => 'Default',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '128',
  'p4' => '131',
  'p5' => '140',
  'p6' => '144',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '145',
  'plid' => '141',
  'link_path' => 'admin/structure/block-types/manage/%/fields/%',
  'router_path' => 'admin/structure/block-types/manage/%/fields/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '128',
  'p4' => '131',
  'p5' => '141',
  'p6' => '145',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '146',
  'plid' => '143',
  'link_path' => 'admin/config/people/accounts/fields/%/delete',
  'router_path' => 'admin/config/people/accounts/fields/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '35',
  'p4' => '52',
  'p5' => '138',
  'p6' => '143',
  'p7' => '146',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '147',
  'plid' => '143',
  'link_path' => 'admin/config/people/accounts/fields/%/edit',
  'router_path' => 'admin/config/people/accounts/fields/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '35',
  'p4' => '52',
  'p5' => '138',
  'p6' => '143',
  'p7' => '147',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '148',
  'plid' => '143',
  'link_path' => 'admin/config/people/accounts/fields/%/field-settings',
  'router_path' => 'admin/config/people/accounts/fields/%/field-settings',
  'link_title' => 'Field settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '35',
  'p4' => '52',
  'p5' => '138',
  'p6' => '143',
  'p7' => '148',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '149',
  'plid' => '143',
  'link_path' => 'admin/config/people/accounts/fields/%/widget-type',
  'router_path' => 'admin/config/people/accounts/fields/%/widget-type',
  'link_title' => 'Widget type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '35',
  'p4' => '52',
  'p5' => '138',
  'p6' => '143',
  'p7' => '149',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '150',
  'plid' => '145',
  'link_path' => 'admin/structure/block-types/manage/%/fields/%/delete',
  'router_path' => 'admin/structure/block-types/manage/%/fields/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '128',
  'p4' => '131',
  'p5' => '141',
  'p6' => '145',
  'p7' => '150',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '151',
  'plid' => '145',
  'link_path' => 'admin/structure/block-types/manage/%/fields/%/edit',
  'router_path' => 'admin/structure/block-types/manage/%/fields/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '128',
  'p4' => '131',
  'p5' => '141',
  'p6' => '145',
  'p7' => '151',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '152',
  'plid' => '145',
  'link_path' => 'admin/structure/block-types/manage/%/fields/%/field-settings',
  'router_path' => 'admin/structure/block-types/manage/%/fields/%/field-settings',
  'link_title' => 'Field settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '128',
  'p4' => '131',
  'p5' => '141',
  'p6' => '145',
  'p7' => '152',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '153',
  'plid' => '145',
  'link_path' => 'admin/structure/block-types/manage/%/fields/%/widget-type',
  'router_path' => 'admin/structure/block-types/manage/%/fields/%/widget-type',
  'link_title' => 'Widget type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '128',
  'p4' => '131',
  'p5' => '141',
  'p6' => '145',
  'p7' => '153',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '154',
  'plid' => '5',
  'link_path' => 'node/add/page',
  'router_path' => 'node/add/page',
  'link_title' => 'Basic page',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:77:\"Use <em>basic pages</em> for your static content, such as an 'About us' page.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '5',
  'p2' => '154',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '155',
  'plid' => '85',
  'link_path' => 'admin/structure/types/manage/%/display',
  'router_path' => 'admin/structure/types/manage/%/display',
  'link_title' => 'Manage display',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '26',
  'p4' => '85',
  'p5' => '155',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '156',
  'plid' => '85',
  'link_path' => 'admin/structure/types/manage/%/fields',
  'router_path' => 'admin/structure/types/manage/%/fields',
  'link_title' => 'Manage fields',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '26',
  'p4' => '85',
  'p5' => '156',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '157',
  'plid' => '155',
  'link_path' => 'admin/structure/types/manage/%/display/default',
  'router_path' => 'admin/structure/types/manage/%/display/default',
  'link_title' => 'Default',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '26',
  'p4' => '85',
  'p5' => '155',
  'p6' => '157',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '158',
  'plid' => '155',
  'link_path' => 'admin/structure/types/manage/%/display/full',
  'router_path' => 'admin/structure/types/manage/%/display/full',
  'link_title' => 'Full content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '26',
  'p4' => '85',
  'p5' => '155',
  'p6' => '158',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '159',
  'plid' => '155',
  'link_path' => 'admin/structure/types/manage/%/display/rss',
  'router_path' => 'admin/structure/types/manage/%/display/rss',
  'link_title' => 'RSS',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '26',
  'p4' => '85',
  'p5' => '155',
  'p6' => '159',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '160',
  'plid' => '155',
  'link_path' => 'admin/structure/types/manage/%/display/teaser',
  'router_path' => 'admin/structure/types/manage/%/display/teaser',
  'link_title' => 'Teaser',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '26',
  'p4' => '85',
  'p5' => '155',
  'p6' => '160',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '161',
  'plid' => '156',
  'link_path' => 'admin/structure/types/manage/%/fields/%',
  'router_path' => 'admin/structure/types/manage/%/fields/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '26',
  'p4' => '85',
  'p5' => '156',
  'p6' => '161',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '162',
  'plid' => '161',
  'link_path' => 'admin/structure/types/manage/%/fields/%/delete',
  'router_path' => 'admin/structure/types/manage/%/fields/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '26',
  'p4' => '85',
  'p5' => '156',
  'p6' => '161',
  'p7' => '162',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '163',
  'plid' => '161',
  'link_path' => 'admin/structure/types/manage/%/fields/%/edit',
  'router_path' => 'admin/structure/types/manage/%/fields/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '26',
  'p4' => '85',
  'p5' => '156',
  'p6' => '161',
  'p7' => '163',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '164',
  'plid' => '161',
  'link_path' => 'admin/structure/types/manage/%/fields/%/field-settings',
  'router_path' => 'admin/structure/types/manage/%/fields/%/field-settings',
  'link_title' => 'Field settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '26',
  'p4' => '85',
  'p5' => '156',
  'p6' => '161',
  'p7' => '164',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '165',
  'plid' => '161',
  'link_path' => 'admin/structure/types/manage/%/fields/%/widget-type',
  'router_path' => 'admin/structure/types/manage/%/fields/%/widget-type',
  'link_title' => 'Widget type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '26',
  'p4' => '85',
  'p5' => '156',
  'p6' => '161',
  'p7' => '165',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '171',
  'plid' => '116',
  'link_path' => 'block/add/image',
  'router_path' => 'block/add/image',
  'link_title' => 'Image',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '116',
  'p2' => '171',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '172',
  'plid' => '34',
  'link_path' => 'admin/config/media/image-styles',
  'router_path' => 'admin/config/media/image-styles',
  'link_title' => 'Image styles',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:78:"Configure styles that can be used for resizing or adjusting images on display.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '34',
  'p4' => '172',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '173',
  'plid' => '172',
  'link_path' => 'admin/config/media/image-styles/add',
  'router_path' => 'admin/config/media/image-styles/add',
  'link_title' => 'Add style',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:22:"Add a new image style.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '34',
  'p4' => '172',
  'p5' => '173',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '174',
  'plid' => '172',
  'link_path' => 'admin/config/media/image-styles/list',
  'router_path' => 'admin/config/media/image-styles/list',
  'link_title' => 'List',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:42:"List the current image styles on the site.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '34',
  'p4' => '172',
  'p5' => '174',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '175',
  'plid' => '172',
  'link_path' => 'admin/config/media/image-styles/edit/%',
  'router_path' => 'admin/config/media/image-styles/edit/%',
  'link_title' => 'Edit style',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:25:"Configure an image style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '34',
  'p4' => '172',
  'p5' => '175',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '176',
  'plid' => '172',
  'link_path' => 'admin/config/media/image-styles/delete/%',
  'router_path' => 'admin/config/media/image-styles/delete/%',
  'link_title' => 'Delete style',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:22:"Delete an image style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '34',
  'p4' => '172',
  'p5' => '176',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '177',
  'plid' => '172',
  'link_path' => 'admin/config/media/image-styles/revert/%',
  'router_path' => 'admin/config/media/image-styles/revert/%',
  'link_title' => 'Revert style',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:22:"Revert an image style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '34',
  'p4' => '172',
  'p5' => '177',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '178',
  'plid' => '175',
  'link_path' => 'admin/config/media/image-styles/edit/%/add/%',
  'router_path' => 'admin/config/media/image-styles/edit/%/add/%',
  'link_title' => 'Add image effect',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:28:"Add a new effect to a style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '34',
  'p4' => '172',
  'p5' => '175',
  'p6' => '178',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '179',
  'plid' => '175',
  'link_path' => 'admin/config/media/image-styles/edit/%/effects/%',
  'router_path' => 'admin/config/media/image-styles/edit/%/effects/%',
  'link_title' => 'Edit image effect',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:39:"Edit an existing effect within a style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '34',
  'p4' => '172',
  'p5' => '175',
  'p6' => '179',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '180',
  'plid' => '179',
  'link_path' => 'admin/config/media/image-styles/edit/%/effects/%/delete',
  'router_path' => 'admin/config/media/image-styles/edit/%/effects/%/delete',
  'link_title' => 'Delete image effect',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:39:"Delete an existing effect from a style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '34',
  'p4' => '172',
  'p5' => '175',
  'p6' => '179',
  'p7' => '180',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '181',
  'plid' => '43',
  'link_path' => 'admin/config/system/entity-view-modes',
  'router_path' => 'admin/config/system/entity-view-modes',
  'link_title' => 'Entity view modes',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:41:"Create new custom view modes for content.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '43',
  'p4' => '181',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '182',
  'plid' => '181',
  'link_path' => 'admin/config/system/entity-view-modes/add/%',
  'router_path' => 'admin/config/system/entity-view-modes/add/%',
  'link_title' => 'Add view mode',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '43',
  'p4' => '181',
  'p5' => '182',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '183',
  'plid' => '181',
  'link_path' => 'admin/config/system/entity-view-modes/delete/%/%',
  'router_path' => 'admin/config/system/entity-view-modes/delete/%/%',
  'link_title' => 'Edit view mode',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '43',
  'p4' => '181',
  'p5' => '183',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '184',
  'plid' => '181',
  'link_path' => 'admin/config/system/entity-view-modes/edit/%/%',
  'router_path' => 'admin/config/system/entity-view-modes/edit/%/%',
  'link_title' => 'Edit view mode',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '43',
  'p4' => '181',
  'p5' => '184',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '185',
  'plid' => '140',
  'link_path' => 'admin/structure/block-types/manage/%/display/compact',
  'router_path' => 'admin/structure/block-types/manage/%/display/compact',
  'link_title' => 'compact',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '128',
  'p4' => '131',
  'p5' => '140',
  'p6' => '185',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '186',
  'plid' => '43',
  'link_path' => 'admin/config/system/uuid',
  'router_path' => 'admin/config/system/uuid',
  'link_title' => 'Universally unique identifiers',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:41:"Configure universally unique identifiers.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '43',
  'p4' => '186',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->execute();
$connection->schema()->createTable('menu_router', array(
  'fields' => array(
    'path' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'load_functions' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'to_arg_functions' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'access_callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'access_arguments' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'page_callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'page_arguments' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'delivery_callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'fit' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'number_parts' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'context' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'tab_parent' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'tab_root' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'title_callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'title_arguments' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'theme_callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'theme_arguments' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'type' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'position' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'include_file' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'medium',
    ),
  ),
  'primary key' => array(
    'path',
  ),
  'indexes' => array(
    'fit' => array(
      'fit',
    ),
    'tab_parent' => array(
      array(
        'tab_parent',
        '64',
      ),
      'weight',
      array(
        'title',
        '191',
      ),
    ),
    'tab_root_weight_title' => array(
      array(
        'tab_root',
        '64',
      ),
      'weight',
      array(
        'title',
        '191',
      ),
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('menu_router')
->fields(array(
  'path',
  'load_functions',
  'to_arg_functions',
  'access_callback',
  'access_arguments',
  'page_callback',
  'page_arguments',
  'delivery_callback',
  'fit',
  'number_parts',
  'context',
  'tab_parent',
  'tab_root',
  'title',
  'title_callback',
  'title_arguments',
  'theme_callback',
  'theme_arguments',
  'type',
  'description',
  'position',
  'weight',
  'include_file',
))
->values(array(
  'path' => 'admin',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin',
  'title' => 'Administration',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '9',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'system_themes_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/appearance',
  'title' => 'Appearance',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Select and configure your themes.',
  'position' => 'left',
  'weight' => '-6',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/default',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'system_theme_default',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/appearance/default',
  'title' => 'Set default theme',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/disable',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'system_theme_disable',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/appearance/disable',
  'title' => 'Disable theme',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/enable',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'system_theme_enable',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/appearance/enable',
  'title' => 'Enable theme',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'system_themes_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/appearance',
  'tab_root' => 'admin/appearance',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'Select and configure your theme',
  'position' => '',
  'weight' => '-1',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"system_theme_settings";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/appearance',
  'tab_root' => 'admin/appearance',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => 'Configure default and theme specific settings.',
  'position' => '',
  'weight' => '20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/settings/bartik',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:25:"themes/bartik/bartik.info";s:4:"name";s:6:"bartik";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:17:{s:4:"name";s:6:"Bartik";s:11:"description";s:48:"A flexible, recolorable theme with many regions.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:7:"regions";a:17:{s:6:"header";s:6:"Header";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:11:"highlighted";s:11:"Highlighted";s:8:"featured";s:8:"Featured";s:7:"content";s:7:"Content";s:13:"sidebar_first";s:13:"Sidebar first";s:14:"sidebar_second";s:14:"Sidebar second";s:14:"triptych_first";s:14:"Triptych first";s:15:"triptych_middle";s:15:"Triptych middle";s:13:"triptych_last";s:13:"Triptych last";s:18:"footer_firstcolumn";s:19:"Footer first column";s:19:"footer_secondcolumn";s:20:"Footer second column";s:18:"footer_thirdcolumn";s:19:"Footer third column";s:19:"footer_fourthcolumn";s:20:"Footer fourth column";s:6:"footer";s:6:"Footer";}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"0";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:28:"themes/bartik/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1607003447;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:6:"bartik";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/appearance/settings',
  'tab_root' => 'admin/appearance',
  'title' => 'Bartik',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/settings/garland',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:27:"themes/garland/garland.info";s:4:"name";s:7:"garland";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:17:{s:4:"name";s:7:"Garland";s:11:"description";s:111:"A multi-column theme which can be configured to modify colors and switch between fixed and fluid width layouts.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:8:"settings";a:1:{s:13:"garland_width";s:5:"fluid";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:6:"engine";s:11:"phptemplate";s:7:"regions";a:9:{s:13:"sidebar_first";s:12:"Left sidebar";s:14:"sidebar_second";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";s:11:"highlighted";s:11:"Highlighted";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";}s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1607003447;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:7:"garland";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/appearance/settings',
  'tab_root' => 'admin/appearance',
  'title' => 'Garland',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/settings/global',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"system_theme_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/appearance/settings',
  'tab_root' => 'admin/appearance',
  'title' => 'Global settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-1',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/settings/seven',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:23:"themes/seven/seven.info";s:4:"name";s:5:"seven";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:17:{s:4:"name";s:5:"Seven";s:11:"description";s:65:"A simple one-column, tableless, fluid width administration theme.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"1";}s:7:"regions";a:5:{s:7:"content";s:7:"Content";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:13:"sidebar_first";s:13:"First sidebar";}s:14:"regions_hidden";a:3:{i:0;s:13:"sidebar_first";i:1;s:8:"page_top";i:2;s:11:"page_bottom";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:27:"themes/seven/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1607003447;}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:5:"seven";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/appearance/settings',
  'tab_root' => 'admin/appearance',
  'title' => 'Seven',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/settings/stark',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => "a:1:{i:0;O:8:\"stdClass\":12:{s:8:\"filename\";s:23:\"themes/stark/stark.info\";s:4:\"name\";s:5:\"stark\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"0\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:16:{s:4:\"name\";s:5:\"Stark\";s:11:\"description\";s:208:\"This theme demonstrates Drupal's default HTML markup and CSS styles. To learn how to build your own theme and override Drupal's default code, see the <a href=\"http://drupal.org/theme-guide\">Theming Guide</a>.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.77\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1607003447\";s:6:\"engine\";s:11:\"phptemplate\";s:7:\"regions\";a:9:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:27:\"themes/stark/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1607003447;s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}}s:6:\"prefix\";s:11:\"phptemplate\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:6:\"engine\";s:11:\"phptemplate\";}}",
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:5:"stark";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/appearance/settings',
  'tab_root' => 'admin/appearance',
  'title' => 'Stark',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/compact',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_compact_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/compact',
  'title' => 'Compact mode',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_config_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config',
  'title' => 'Configuration',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Administer settings.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/content',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/content',
  'title' => 'Content authoring',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Settings related to formatting and authoring content.',
  'position' => 'left',
  'weight' => '-15',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/content/formats',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"filter_admin_overview";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/content/formats',
  'title' => 'Text formats',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure how content input by users is filtered, including allowed HTML tags. Also allows enabling of module-provided filters.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/config/content/formats/%',
  'load_functions' => 'a:1:{i:4;s:18:"filter_format_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'filter_admin_format_page',
  'page_arguments' => 'a:1:{i:0;i:4;}',
  'delivery_callback' => '',
  'fit' => '30',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/content/formats/%',
  'title' => '',
  'title_callback' => 'filter_admin_format_title',
  'title_arguments' => 'a:1:{i:0;i:4;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/config/content/formats/%/disable',
  'load_functions' => 'a:1:{i:4;s:18:"filter_format_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_filter_disable_format_access',
  'access_arguments' => 'a:1:{i:0;i:4;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:20:"filter_admin_disable";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/content/formats/%/disable',
  'title' => 'Disable text format',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/config/content/formats/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'filter_admin_format_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/content/formats',
  'tab_root' => 'admin/config/content/formats',
  'title' => 'Add text format',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/config/content/formats/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"filter_admin_overview";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/content/formats',
  'tab_root' => 'admin/config/content/formats',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/config/development',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/development',
  'title' => 'Development',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Development tools.',
  'position' => 'right',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/development/logging',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:23:"system_logging_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/development/logging',
  'title' => 'Logging and errors',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "Settings for logging and alerts modules. Various modules can route Drupal's system events to different destinations, such as syslog, database, email, etc.",
  'position' => '',
  'weight' => '-15',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/development/maintenance',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:28:"system_site_maintenance_mode";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/development/maintenance',
  'title' => 'Maintenance mode',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Take the site offline for maintenance or bring it back online.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/development/performance',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:27:"system_performance_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/development/performance',
  'title' => 'Performance',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Enable or disable page caching for anonymous users and set CSS and JS bandwidth optimization options.',
  'position' => '',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/media',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media',
  'title' => 'Media',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Media tools.',
  'position' => 'left',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/file-system',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:27:"system_file_system_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/file-system',
  'title' => 'File system',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Tell Drupal where to store uploaded files and how they are accessed.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'image_style_list',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles',
  'title' => 'Image styles',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure styles that can be used for resizing or adjusting images on display.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"image_style_add_form";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/media/image-styles',
  'tab_root' => 'admin/config/media/image-styles',
  'title' => 'Add style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => 'Add a new image style.',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/delete/%',
  'load_functions' => 'a:1:{i:5;a:1:{s:16:"image_style_load";a:2:{i:0;N;i:1;s:1:"1";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"image_style_delete_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/delete/%',
  'title' => 'Delete style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Delete an image style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/edit/%',
  'load_functions' => 'a:1:{i:5;s:16:"image_style_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:16:"image_style_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/edit/%',
  'title' => 'Edit style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure an image style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/edit/%/add/%',
  'load_functions' => 'a:2:{i:5;a:1:{s:16:"image_style_load";a:1:{i:0;i:5;}}i:7;a:1:{s:28:"image_effect_definition_load";a:1:{i:0;i:5;}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:17:"image_effect_form";i:1;i:5;i:2;i:7;}',
  'delivery_callback' => '',
  'fit' => '250',
  'number_parts' => '8',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/edit/%/add/%',
  'title' => 'Add image effect',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Add a new effect to a style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/edit/%/effects/%',
  'load_functions' => 'a:2:{i:5;a:1:{s:16:"image_style_load";a:2:{i:0;i:5;i:1;s:1:"3";}}i:7;a:1:{s:17:"image_effect_load";a:2:{i:0;i:5;i:1;s:1:"3";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:17:"image_effect_form";i:1;i:5;i:2;i:7;}',
  'delivery_callback' => '',
  'fit' => '250',
  'number_parts' => '8',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/edit/%/effects/%',
  'title' => 'Edit image effect',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Edit an existing effect within a style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/edit/%/effects/%/delete',
  'load_functions' => 'a:2:{i:5;a:1:{s:16:"image_style_load";a:2:{i:0;i:5;i:1;s:1:"3";}}i:7;a:1:{s:17:"image_effect_load";a:2:{i:0;i:5;i:1;s:1:"3";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:24:"image_effect_delete_form";i:1;i:5;i:2;i:7;}',
  'delivery_callback' => '',
  'fit' => '501',
  'number_parts' => '9',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/edit/%/effects/%/delete',
  'title' => 'Delete image effect',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Delete an existing effect from a style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'image_style_list',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/media/image-styles',
  'tab_root' => 'admin/config/media/image-styles',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'List the current image styles on the site.',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/revert/%',
  'load_functions' => 'a:1:{i:5;a:1:{s:16:"image_style_load";a:2:{i:0;N;i:1;s:1:"2";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"image_style_revert_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/revert/%',
  'title' => 'Revert style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Revert an image style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-toolkit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:29:"system_image_toolkit_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-toolkit',
  'title' => 'Image toolkit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Choose which image toolkit to use if you have installed optional toolkits.',
  'position' => '',
  'weight' => '20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/people',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/people',
  'title' => 'People',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure user accounts.',
  'position' => 'left',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:19:"user_admin_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'Account settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure default behavior of users, including registration requirements, e-mails, fields, and user pictures.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"user";i:2;s:4:"user";i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'Manage display',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/display/default',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:7:"default";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"user";i:2;s:4:"user";i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/display',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'Default',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/display/full',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:4:"full";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"user";i:2;s:4:"user";i:3;s:4:"full";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/display',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'User account',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:28:"field_ui_field_overview_form";i:1;s:4:"user";i:2;s:4:"user";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/fields/%',
  'load_functions' => 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/people/accounts/fields/%',
  'title' => '',
  'title_callback' => 'field_ui_menu_title',
  'title_arguments' => 'a:1:{i:0;i:5;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/fields/%/delete',
  'load_functions' => 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"field_ui_field_delete_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/fields/%',
  'tab_root' => 'admin/config/people/accounts/fields/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/fields/%/edit',
  'load_functions' => 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/fields/%',
  'tab_root' => 'admin/config/people/accounts/fields/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/fields/%/field-settings',
  'load_functions' => 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"field_ui_field_settings_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/fields/%',
  'tab_root' => 'admin/config/people/accounts/fields/%',
  'title' => 'Field settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/fields/%/widget-type',
  'load_functions' => 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:25:"field_ui_widget_type_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/fields/%',
  'tab_root' => 'admin/config/people/accounts/fields/%',
  'title' => 'Widget type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:19:"user_admin_settings";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/ip-blocking',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"block IP addresses";}',
  'page_callback' => 'system_ip_blocking',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/people/ip-blocking',
  'title' => 'IP address blocking',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage blocked IP addresses.',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/ip-blocking/delete/%',
  'load_functions' => 'a:1:{i:5;s:15:"blocked_ip_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"block IP addresses";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:25:"system_ip_blocking_delete";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/people/ip-blocking/delete/%',
  'title' => 'Delete IP address',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional',
  'title' => 'Regional and language',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Regional settings, localization and translation.',
  'position' => 'left',
  'weight' => '-5',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_date_time_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/date-time',
  'title' => 'Date and time',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure display formats for date and time.',
  'position' => '',
  'weight' => '-15',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/formats',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_date_time_formats',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/date-time',
  'tab_root' => 'admin/config/regional/date-time',
  'title' => 'Formats',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => 'Configure display format strings for date and time.',
  'position' => '',
  'weight' => '-9',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/formats/%/delete',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:30:"system_date_delete_format_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/date-time/formats/%/delete',
  'title' => 'Delete date format',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Allow users to delete a configured date format.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/formats/%/edit',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:34:"system_configure_date_formats_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/date-time/formats/%/edit',
  'title' => 'Edit date format',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Allow users to edit a configured date format.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/formats/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:34:"system_configure_date_formats_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/date-time/formats',
  'tab_root' => 'admin/config/regional/date-time',
  'title' => 'Add format',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => 'Allow users to add additional date formats.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/formats/lookup',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_date_time_lookup',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/date-time/formats/lookup',
  'title' => 'Date and time lookup',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/types',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_date_time_settings";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/date-time',
  'tab_root' => 'admin/config/regional/date-time',
  'title' => 'Types',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'Configure display formats for date and time.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/types/%/delete',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:35:"system_delete_date_format_type_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/date-time/types/%/delete',
  'title' => 'Delete date type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Allow users to delete a configured date type.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/types/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:32:"system_add_date_format_type_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/date-time/types',
  'tab_root' => 'admin/config/regional/date-time',
  'title' => 'Add date type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => 'Add new date type.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_regional_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/settings',
  'title' => 'Regional settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "Settings for the site's default time zone and country.",
  'position' => '',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/search',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search',
  'title' => 'Search and metadata',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Local site search, metadata and SEO.',
  'position' => 'left',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/search/clean-urls',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_clean_url_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search/clean-urls',
  'title' => 'Clean URLs',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Enable or disable clean URLs for your site.',
  'position' => '',
  'weight' => '5',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/search/clean-urls/check',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_json_output',
  'page_arguments' => 'a:1:{i:0;a:1:{s:6:"status";b:1;}}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search/clean-urls/check',
  'title' => 'Clean URL check',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/services',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/services',
  'title' => 'Web services',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Tools related to web services.',
  'position' => 'right',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/services/rss-publishing',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_rss_feeds_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/services/rss-publishing',
  'title' => 'RSS publishing',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure the site description, the number of items per feed and whether feeds should be titles/teasers/full-text.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system',
  'title' => 'System',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'General system related configuration.',
  'position' => 'right',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/actions',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'system_actions_manage',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/actions',
  'title' => 'Actions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage the actions defined for your site.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/actions/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_actions_configure";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/actions/configure',
  'title' => 'Configure an advanced action',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/actions/delete/%',
  'load_functions' => 'a:1:{i:5;s:12:"actions_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"system_actions_delete_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/actions/delete/%',
  'title' => 'Delete action',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Delete an action.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/actions/manage',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'system_actions_manage',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/system/actions',
  'tab_root' => 'admin/config/system/actions',
  'title' => 'Manage actions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'Manage the actions defined for your site.',
  'position' => '',
  'weight' => '-2',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/actions/orphan',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'system_actions_remove_orphans',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/actions/orphan',
  'title' => 'Remove orphans',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/cron',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"system_cron_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/cron',
  'title' => 'Cron',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage automatic site maintenance tasks.',
  'position' => '',
  'weight' => '20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/entity-view-modes',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:28:"administer entity view modes";}',
  'page_callback' => 'entity_view_mode_list',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/entity-view-modes',
  'title' => 'Entity view modes',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Create new custom view modes for content.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/entity_view_mode/entity_view_mode.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/entity-view-modes/add/%',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:28:"administer entity view modes";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"entity_view_mode_edit_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/entity-view-modes/add/%',
  'title' => 'Add view mode',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/entity_view_mode/entity_view_mode.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/entity-view-modes/delete/%/%',
  'load_functions' => 'a:2:{i:5;N;i:6;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:28:"administer entity view modes";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:28:"entity_view_mode_delete_form";i:1;i:5;i:2;i:6;}',
  'delivery_callback' => '',
  'fit' => '124',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/entity-view-modes/delete/%/%',
  'title' => 'Edit view mode',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/entity_view_mode/entity_view_mode.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/entity-view-modes/edit/%/%',
  'load_functions' => 'a:2:{i:5;N;i:6;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:28:"administer entity view modes";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:26:"entity_view_mode_edit_form";i:1;i:5;i:2;i:6;}',
  'delivery_callback' => '',
  'fit' => '124',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/entity-view-modes/edit/%/%',
  'title' => 'Edit view mode',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/entity_view_mode/entity_view_mode.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/site-information',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:32:"system_site_information_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/site-information',
  'title' => 'Site information',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Change site name, e-mail address, slogan, default front page, and number of posts per page, error pages.',
  'position' => '',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/uuid',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer uuid";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:15:"uuid_admin_form";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/uuid',
  'title' => 'Universally unique identifiers',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure universally unique identifiers.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/uuid/uuid.admin.inc',
))
->values(array(
  'path' => 'admin/config/user-interface',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/user-interface',
  'title' => 'User interface',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Tools that enhance the user interface.',
  'position' => 'right',
  'weight' => '-15',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/workflow',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/workflow',
  'title' => 'Workflow',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Content workflow, editorial workflow tools.',
  'position' => 'right',
  'weight' => '5',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/content',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"access content overview";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:18:"node_admin_content";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/content',
  'title' => 'Content',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Find and manage content.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/node/node.admin.inc',
))
->values(array(
  'path' => 'admin/content/blocks',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"access bean overview";}',
  'page_callback' => 'bean_list',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/content',
  'tab_root' => 'admin/content',
  'title' => 'Blocks',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '134',
  'description' => 'Manage blocks used on your site.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/bean/includes/bean.pages.inc',
))
->values(array(
  'path' => 'admin/content/node',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"access content overview";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:18:"node_admin_content";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/content',
  'tab_root' => 'admin/content',
  'title' => 'Content',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/node/node.admin.inc',
))
->values(array(
  'path' => 'admin/index',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_index',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'admin',
  'tab_root' => 'admin',
  'title' => 'Index',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '-18',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/modules',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer modules";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"system_modules";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/modules',
  'title' => 'Modules',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Extend site functionality.',
  'position' => '',
  'weight' => '-2',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/modules/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer modules";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"system_modules";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/modules',
  'tab_root' => 'admin/modules',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/modules/list/confirm',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer modules";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"system_modules";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/modules/list/confirm',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/modules/uninstall',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer modules";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_modules_uninstall";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/modules',
  'tab_root' => 'admin/modules',
  'title' => 'Uninstall',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/modules/uninstall/confirm',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer modules";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_modules_uninstall";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/modules/uninstall/confirm',
  'title' => 'Uninstall',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/people',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'user_admin',
  'page_arguments' => 'a:1:{i:0;s:4:"list";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/people',
  'title' => 'People',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage user accounts, roles, and permissions.',
  'position' => 'left',
  'weight' => '-4',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/create',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'user_admin',
  'page_arguments' => 'a:1:{i:0;s:6:"create";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/people',
  'tab_root' => 'admin/people',
  'title' => 'Add user',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/people',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'user_admin',
  'page_arguments' => 'a:1:{i:0;s:4:"list";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/people',
  'tab_root' => 'admin/people',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'Find and manage people interacting with your site.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/permissions',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:22:"user_admin_permissions";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/people',
  'tab_root' => 'admin/people',
  'title' => 'Permissions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => 'Determine access to features by selecting permissions for roles.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/permissions/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:22:"user_admin_permissions";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/people/permissions',
  'tab_root' => 'admin/people',
  'title' => 'Permissions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'Determine access to features by selecting permissions for roles.',
  'position' => '',
  'weight' => '-8',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/permissions/roles',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:16:"user_admin_roles";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/people/permissions',
  'tab_root' => 'admin/people',
  'title' => 'Roles',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => 'List, edit, or add user roles.',
  'position' => '',
  'weight' => '-5',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/permissions/roles/delete/%',
  'load_functions' => 'a:1:{i:5;s:14:"user_role_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_role_edit_access',
  'access_arguments' => 'a:1:{i:0;i:5;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:30:"user_admin_role_delete_confirm";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/people/permissions/roles/delete/%',
  'title' => 'Delete role',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/permissions/roles/edit/%',
  'load_functions' => 'a:1:{i:5;s:14:"user_role_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_role_edit_access',
  'access_arguments' => 'a:1:{i:0;i:5;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:15:"user_admin_role";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/people/permissions/roles/edit/%',
  'title' => 'Edit role',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/reports',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"access site reports";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports',
  'title' => 'Reports',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'View reports, updates, and errors.',
  'position' => 'left',
  'weight' => '5',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/reports/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'field_ui_fields_list',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/fields',
  'title' => 'Field list',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Overview of fields on all entity types.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/reports/status',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_status',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status',
  'title' => 'Status report',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "Get a status report about your site's operation and any detected problems.",
  'position' => '',
  'weight' => '-60',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/reports/status/php',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_php',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status/php',
  'title' => 'PHP',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/reports/status/rebuild',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:30:"node_configure_rebuild_confirm";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status/rebuild',
  'title' => 'Rebuild permissions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.admin.inc',
))
->values(array(
  'path' => 'admin/reports/status/run-cron',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_run_cron',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status/run-cron',
  'title' => 'Run cron',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/structure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure',
  'title' => 'Structure',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Administer blocks, content types, menus, etc.',
  'position' => 'right',
  'weight' => '-8',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:6:"bartik";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block',
  'title' => 'Blocks',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "Configure what block content appears in your site's sidebars and other regions.",
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block-types',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer bean types";}',
  'page_callback' => 'bean_admin_ui_admin_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block-types',
  'title' => 'Block types',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage block types, including fields, settings, etc.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/bean/bean_admin_ui/bean_admin_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block-types/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer bean types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:23:"bean_admin_ui_type_form";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/block-types',
  'tab_root' => 'admin/structure/block-types',
  'title' => 'Add block type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/bean/bean_admin_ui/bean_admin_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block-types/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer bean types";}',
  'page_callback' => 'bean_admin_ui_admin_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/block-types',
  'tab_root' => 'admin/structure/block-types',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'sites/all/modules/bean/bean_admin_ui/bean_admin_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block-types/manage/%',
  'load_functions' => 'a:1:{i:4;s:14:"bean_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer bean types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"bean_admin_ui_type_form";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '30',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block-types/manage/%',
  'title' => 'Edit block type',
  'title_callback' => 'bean_admin_ui_page_title',
  'title_arguments' => 'a:1:{i:0;i:4;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/bean/bean_admin_ui/bean_admin_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block-types/manage/%/delete',
  'load_functions' => 'a:1:{i:4;s:14:"bean_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer bean types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"bean_admin_ui_type_op_confirm";i:1;s:6:"delete";i:2;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block-types/manage/%/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/bean/bean_admin_ui/bean_admin_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block-types/manage/%/display',
  'load_functions' => 'a:1:{i:4;s:14:"bean_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:21:"administer bean types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"bean";i:2;i:4;i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/block-types/manage/%',
  'tab_root' => 'admin/structure/block-types/manage/%',
  'title' => 'Manage display',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block-types/manage/%/display/compact',
  'load_functions' => 'a:1:{i:4;s:14:"bean_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"bean";i:1;i:4;i:2;s:7:"compact";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:21:"administer bean types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"bean";i:2;i:4;i:3;s:7:"compact";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/block-types/manage/%/display',
  'tab_root' => 'admin/structure/block-types/manage/%',
  'title' => 'compact',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block-types/manage/%/display/default',
  'load_functions' => 'a:1:{i:4;s:14:"bean_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"bean";i:1;i:4;i:2;s:7:"default";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:21:"administer bean types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"bean";i:2;i:4;i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/block-types/manage/%/display',
  'tab_root' => 'admin/structure/block-types/manage/%',
  'title' => 'Default',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block-types/manage/%/edit',
  'load_functions' => 'a:1:{i:4;s:14:"bean_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer bean types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"bean_admin_ui_type_form";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/block-types/manage/%',
  'tab_root' => 'admin/structure/block-types/manage/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/bean/bean_admin_ui/bean_admin_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block-types/manage/%/fields',
  'load_functions' => 'a:1:{i:4;s:14:"bean_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:21:"administer bean types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:28:"field_ui_field_overview_form";i:1;s:4:"bean";i:2;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/block-types/manage/%',
  'tab_root' => 'admin/structure/block-types/manage/%',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block-types/manage/%/fields/%',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"bean_type_load";a:4:{i:0;s:4:"bean";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"bean";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:21:"administer bean types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '122',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block-types/manage/%/fields/%',
  'title' => '',
  'title_callback' => 'field_ui_menu_title',
  'title_arguments' => 'a:1:{i:0;i:6;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block-types/manage/%/fields/%/delete',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"bean_type_load";a:4:{i:0;s:4:"bean";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"bean";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:21:"administer bean types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"field_ui_field_delete_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '245',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/block-types/manage/%/fields/%',
  'tab_root' => 'admin/structure/block-types/manage/%/fields/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block-types/manage/%/fields/%/edit',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"bean_type_load";a:4:{i:0;s:4:"bean";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"bean";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:21:"administer bean types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '245',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/block-types/manage/%/fields/%',
  'tab_root' => 'admin/structure/block-types/manage/%/fields/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block-types/manage/%/fields/%/field-settings',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"bean_type_load";a:4:{i:0;s:4:"bean";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"bean";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:21:"administer bean types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"field_ui_field_settings_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '245',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/block-types/manage/%/fields/%',
  'tab_root' => 'admin/structure/block-types/manage/%/fields/%',
  'title' => 'Field settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block-types/manage/%/fields/%/widget-type',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"bean_type_load";a:4:{i:0;s:4:"bean";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"bean";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:21:"administer bean types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:25:"field_ui_widget_type_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '245',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/block-types/manage/%/fields/%',
  'tab_root' => 'admin/structure/block-types/manage/%/fields/%',
  'title' => 'Widget type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block-types/manage/%/revert',
  'load_functions' => 'a:1:{i:4;s:14:"bean_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer bean types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"bean_admin_ui_type_op_confirm";i:1;s:6:"revert";i:2;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block-types/manage/%/revert',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/bean/bean_admin_ui/bean_admin_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"block_add_block_form";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/block',
  'tab_root' => 'admin/structure/block',
  'title' => 'Add block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/demo/bartik',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:25:"themes/bartik/bartik.info";s:4:"name";s:6:"bartik";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:17:{s:4:"name";s:6:"Bartik";s:11:"description";s:48:"A flexible, recolorable theme with many regions.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:7:"regions";a:17:{s:6:"header";s:6:"Header";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:11:"highlighted";s:11:"Highlighted";s:8:"featured";s:8:"Featured";s:7:"content";s:7:"Content";s:13:"sidebar_first";s:13:"Sidebar first";s:14:"sidebar_second";s:14:"Sidebar second";s:14:"triptych_first";s:14:"Triptych first";s:15:"triptych_middle";s:15:"Triptych middle";s:13:"triptych_last";s:13:"Triptych last";s:18:"footer_firstcolumn";s:19:"Footer first column";s:19:"footer_secondcolumn";s:20:"Footer second column";s:18:"footer_thirdcolumn";s:19:"Footer third column";s:19:"footer_fourthcolumn";s:20:"Footer fourth column";s:6:"footer";s:6:"Footer";}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"0";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:28:"themes/bartik/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1607003447;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_demo',
  'page_arguments' => 'a:1:{i:0;s:6:"bartik";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block/demo/bartik',
  'title' => 'Bartik',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '_block_custom_theme',
  'theme_arguments' => 'a:1:{i:0;s:6:"bartik";}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/demo/garland',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:27:"themes/garland/garland.info";s:4:"name";s:7:"garland";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:17:{s:4:"name";s:7:"Garland";s:11:"description";s:111:"A multi-column theme which can be configured to modify colors and switch between fixed and fluid width layouts.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:8:"settings";a:1:{s:13:"garland_width";s:5:"fluid";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:6:"engine";s:11:"phptemplate";s:7:"regions";a:9:{s:13:"sidebar_first";s:12:"Left sidebar";s:14:"sidebar_second";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";s:11:"highlighted";s:11:"Highlighted";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";}s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1607003447;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_demo',
  'page_arguments' => 'a:1:{i:0;s:7:"garland";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block/demo/garland',
  'title' => 'Garland',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '_block_custom_theme',
  'theme_arguments' => 'a:1:{i:0;s:7:"garland";}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/demo/seven',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:23:"themes/seven/seven.info";s:4:"name";s:5:"seven";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:17:{s:4:"name";s:5:"Seven";s:11:"description";s:65:"A simple one-column, tableless, fluid width administration theme.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"1";}s:7:"regions";a:5:{s:7:"content";s:7:"Content";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:13:"sidebar_first";s:13:"First sidebar";}s:14:"regions_hidden";a:3:{i:0;s:13:"sidebar_first";i:1;s:8:"page_top";i:2;s:11:"page_bottom";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:27:"themes/seven/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1607003447;}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_demo',
  'page_arguments' => 'a:1:{i:0;s:5:"seven";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block/demo/seven',
  'title' => 'Seven',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '_block_custom_theme',
  'theme_arguments' => 'a:1:{i:0;s:5:"seven";}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/demo/stark',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => "a:1:{i:0;O:8:\"stdClass\":12:{s:8:\"filename\";s:23:\"themes/stark/stark.info\";s:4:\"name\";s:5:\"stark\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"0\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:16:{s:4:\"name\";s:5:\"Stark\";s:11:\"description\";s:208:\"This theme demonstrates Drupal's default HTML markup and CSS styles. To learn how to build your own theme and override Drupal's default code, see the <a href=\"http://drupal.org/theme-guide\">Theming Guide</a>.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.77\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1607003447\";s:6:\"engine\";s:11:\"phptemplate\";s:7:\"regions\";a:9:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:27:\"themes/stark/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1607003447;s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}}s:6:\"prefix\";s:11:\"phptemplate\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:6:\"engine\";s:11:\"phptemplate\";}}",
  'page_callback' => 'block_admin_demo',
  'page_arguments' => 'a:1:{i:0;s:5:"stark";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block/demo/stark',
  'title' => 'Stark',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '_block_custom_theme',
  'theme_arguments' => 'a:1:{i:0;s:5:"stark";}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/bartik',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:25:"themes/bartik/bartik.info";s:4:"name";s:6:"bartik";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:17:{s:4:"name";s:6:"Bartik";s:11:"description";s:48:"A flexible, recolorable theme with many regions.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:7:"regions";a:17:{s:6:"header";s:6:"Header";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:11:"highlighted";s:11:"Highlighted";s:8:"featured";s:8:"Featured";s:7:"content";s:7:"Content";s:13:"sidebar_first";s:13:"Sidebar first";s:14:"sidebar_second";s:14:"Sidebar second";s:14:"triptych_first";s:14:"Triptych first";s:15:"triptych_middle";s:15:"Triptych middle";s:13:"triptych_last";s:13:"Triptych last";s:18:"footer_firstcolumn";s:19:"Footer first column";s:19:"footer_secondcolumn";s:20:"Footer second column";s:18:"footer_thirdcolumn";s:19:"Footer third column";s:19:"footer_fourthcolumn";s:20:"Footer fourth column";s:6:"footer";s:6:"Footer";}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"0";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:28:"themes/bartik/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1607003447;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:6:"bartik";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/block',
  'tab_root' => 'admin/structure/block',
  'title' => 'Bartik',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/garland',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:27:"themes/garland/garland.info";s:4:"name";s:7:"garland";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:17:{s:4:"name";s:7:"Garland";s:11:"description";s:111:"A multi-column theme which can be configured to modify colors and switch between fixed and fluid width layouts.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:8:"settings";a:1:{s:13:"garland_width";s:5:"fluid";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:6:"engine";s:11:"phptemplate";s:7:"regions";a:9:{s:13:"sidebar_first";s:12:"Left sidebar";s:14:"sidebar_second";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";s:11:"highlighted";s:11:"Highlighted";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";}s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1607003447;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:7:"garland";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/block',
  'tab_root' => 'admin/structure/block',
  'title' => 'Garland',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/garland/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"block_add_block_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/block/list/garland',
  'tab_root' => 'admin/structure/block',
  'title' => 'Add block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/seven',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:23:"themes/seven/seven.info";s:4:"name";s:5:"seven";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:17:{s:4:"name";s:5:"Seven";s:11:"description";s:65:"A simple one-column, tableless, fluid width administration theme.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"1";}s:7:"regions";a:5:{s:7:"content";s:7:"Content";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:13:"sidebar_first";s:13:"First sidebar";}s:14:"regions_hidden";a:3:{i:0;s:13:"sidebar_first";i:1;s:8:"page_top";i:2;s:11:"page_bottom";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:27:"themes/seven/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1607003447;}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:5:"seven";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/block',
  'tab_root' => 'admin/structure/block',
  'title' => 'Seven',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/seven/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"block_add_block_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/block/list/seven',
  'tab_root' => 'admin/structure/block',
  'title' => 'Add block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/stark',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => "a:1:{i:0;O:8:\"stdClass\":12:{s:8:\"filename\";s:23:\"themes/stark/stark.info\";s:4:\"name\";s:5:\"stark\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"0\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:16:{s:4:\"name\";s:5:\"Stark\";s:11:\"description\";s:208:\"This theme demonstrates Drupal's default HTML markup and CSS styles. To learn how to build your own theme and override Drupal's default code, see the <a href=\"http://drupal.org/theme-guide\">Theming Guide</a>.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.77\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1607003447\";s:6:\"engine\";s:11:\"phptemplate\";s:7:\"regions\";a:9:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:27:\"themes/stark/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1607003447;s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}}s:6:\"prefix\";s:11:\"phptemplate\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:6:\"engine\";s:11:\"phptemplate\";}}",
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:5:"stark";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/block',
  'tab_root' => 'admin/structure/block',
  'title' => 'Stark',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/stark/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"block_add_block_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/block/list/stark',
  'tab_root' => 'admin/structure/block',
  'title' => 'Add block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/manage/%/%',
  'load_functions' => 'a:2:{i:4;N;i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:21:"block_admin_configure";i:1;i:4;i:2;i:5;}',
  'delivery_callback' => '',
  'fit' => '60',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block/manage/%/%',
  'title' => 'Configure block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/manage/%/%/configure',
  'load_functions' => 'a:2:{i:4;N;i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:21:"block_admin_configure";i:1;i:4;i:2;i:5;}',
  'delivery_callback' => '',
  'fit' => '121',
  'number_parts' => '7',
  'context' => '2',
  'tab_parent' => 'admin/structure/block/manage/%/%',
  'tab_root' => 'admin/structure/block/manage/%/%',
  'title' => 'Configure block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/manage/%/%/delete',
  'load_functions' => 'a:2:{i:4;N;i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"block_custom_block_delete";i:1;i:4;i:2;i:5;}',
  'delivery_callback' => '',
  'fit' => '121',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => 'admin/structure/block/manage/%/%',
  'tab_root' => 'admin/structure/block/manage/%/%',
  'title' => 'Delete block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'node_overview_types',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/types',
  'title' => 'Content types',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage content types, including default status, front page promotion, comment settings, etc.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/structure/types/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"node_type_form";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/types',
  'tab_root' => 'admin/structure/types',
  'title' => 'Add content type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/structure/types/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'node_overview_types',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/types',
  'tab_root' => 'admin/structure/types',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '30',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Edit content type',
  'title_callback' => 'node_type_page_title',
  'title_arguments' => 'a:1:{i:0;i:4;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/delete',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"node_type_delete_confirm";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/types/manage/%/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/display',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Manage display',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/display/default',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"node";i:1;i:4;i:2;s:7:"default";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Default',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/display/full',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"node";i:1;i:4;i:2;s:4:"full";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:4:"full";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Full content',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/display/rss',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"node";i:1;i:4;i:2;s:3:"rss";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:3:"rss";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/display/teaser',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"node";i:1;i:4;i:2;s:6:"teaser";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:6:"teaser";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Teaser',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/edit',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/fields',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:28:"field_ui_field_overview_form";i:1;s:4:"node";i:2;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/fields/%',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '122',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/types/manage/%/fields/%',
  'title' => '',
  'title_callback' => 'field_ui_menu_title',
  'title_arguments' => 'a:1:{i:0;i:6;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/fields/%/delete',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"field_ui_field_delete_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '245',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/fields/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/fields/%/edit',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '245',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/fields/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/fields/%/field-settings',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"field_ui_field_settings_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '245',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/fields/%',
  'title' => 'Field settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/fields/%/widget-type',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:25:"field_ui_widget_type_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '245',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/fields/%',
  'title' => 'Widget type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/tasks',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'admin',
  'tab_root' => 'admin',
  'title' => 'Tasks',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'batch',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'system_batch_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'batch',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '_system_batch_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'block/%',
  'load_functions' => 'a:1:{i:1;s:15:"bean_delta_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"view bean page";}',
  'page_callback' => 'bean_view_page',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '2',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'block/%',
  'title' => 'Block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/bean/includes/bean.pages.inc',
))
->values(array(
  'path' => 'block/%/delete',
  'load_functions' => 'a:1:{i:1;s:15:"bean_delta_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_access',
  'access_arguments' => 'a:3:{i:0;s:6:"delete";i:1;s:4:"bean";i:2;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:19:"bean_delete_confirm";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => 'block/%',
  'tab_root' => 'block/%',
  'title' => 'Delete Block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'sites/all/modules/bean/includes/bean.pages.inc',
))
->values(array(
  'path' => 'block/%/edit',
  'load_functions' => 'a:1:{i:1;s:15:"bean_delta_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_access',
  'access_arguments' => 'a:3:{i:0;s:6:"update";i:1;s:4:"bean";i:2;i:1;}',
  'page_callback' => 'bean_edit',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '3',
  'tab_parent' => 'block/%',
  'tab_root' => 'block/%',
  'title' => 'Edit Block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/bean/includes/bean.pages.inc',
))
->values(array(
  'path' => 'block/%/revisions',
  'load_functions' => 'a:1:{i:1;s:15:"bean_delta_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"view bean revisions";}',
  'page_callback' => 'bean_revisions_page',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'block/%',
  'tab_root' => 'block/%',
  'title' => 'Revisions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/bean/includes/bean.pages.inc',
))
->values(array(
  'path' => 'block/%/revisions/%',
  'load_functions' => 'a:2:{i:1;a:1:{s:15:"bean_delta_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_access',
  'access_arguments' => 'a:3:{i:0;s:4:"view";i:1;s:4:"bean";i:2;i:1;}',
  'page_callback' => 'bean_view',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '10',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'block/%/revisions/%',
  'title' => '',
  'title_callback' => 'bean_revision_title',
  'title_arguments' => 'a:1:{i:0;i:1;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/bean/includes/bean.pages.inc',
))
->values(array(
  'path' => 'block/%/revisions/%/delete',
  'load_functions' => 'a:2:{i:1;a:1:{s:15:"bean_delta_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_access',
  'access_arguments' => 'a:3:{i:0;s:6:"delete";i:1;s:4:"bean";i:2;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"bean_delete_revision_confirm";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '21',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => 'block/%/revisions/%',
  'tab_root' => 'block/%/revisions/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'sites/all/modules/bean/includes/bean.pages.inc',
))
->values(array(
  'path' => 'block/%/revisions/%/edit',
  'load_functions' => 'a:2:{i:1;a:1:{s:15:"bean_delta_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_access',
  'access_arguments' => 'a:3:{i:0;s:6:"update";i:1;s:4:"bean";i:2;i:1;}',
  'page_callback' => 'bean_edit',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '21',
  'number_parts' => '5',
  'context' => '3',
  'tab_parent' => 'block/%/revisions/%',
  'tab_root' => 'block/%/revisions/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/bean/includes/bean.pages.inc',
))
->values(array(
  'path' => 'block/%/revisions/%/set-active',
  'load_functions' => 'a:2:{i:1;a:1:{s:15:"bean_delta_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_access',
  'access_arguments' => 'a:3:{i:0;s:6:"update";i:1;s:4:"bean";i:2;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"bean_set_default_confirm";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '21',
  'number_parts' => '5',
  'context' => '3',
  'tab_parent' => 'block/%/revisions/%',
  'tab_root' => 'block/%/revisions/%',
  'title' => 'Set active',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/bean/includes/bean.pages.inc',
))
->values(array(
  'path' => 'block/%/revisions/%/view',
  'load_functions' => 'a:2:{i:1;a:1:{s:15:"bean_delta_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_access',
  'access_arguments' => 'a:3:{i:0;s:4:"view";i:1;s:4:"bean";i:2;i:1;}',
  'page_callback' => 'bean_view',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '21',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => 'block/%/revisions/%',
  'tab_root' => 'block/%/revisions/%',
  'title' => 'View',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'sites/all/modules/bean/includes/bean.pages.inc',
))
->values(array(
  'path' => 'block/%/view',
  'load_functions' => 'a:1:{i:1;s:15:"bean_delta_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"view bean page";}',
  'page_callback' => 'bean_view_page',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => 'block/%',
  'tab_root' => 'block/%',
  'title' => 'View',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-20',
  'include_file' => 'sites/all/modules/bean/includes/bean.pages.inc',
))
->values(array(
  'path' => 'block/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'bean_add_page_access',
  'access_arguments' => 'a:1:{i:0;s:3:"add";}',
  'page_callback' => 'bean_add_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'block/add',
  'title' => 'Add Block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/bean/includes/bean.pages.inc',
))
->values(array(
  'path' => 'block/add/image',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'bean_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:5:"image";}',
  'page_callback' => 'bean_add',
  'page_arguments' => 'a:1:{i:0;s:5:"image";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'block/add/image',
  'title' => 'Image',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/bean/includes/bean.pages.inc',
))
->values(array(
  'path' => 'block/add/simple',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'bean_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:6:"simple";}',
  'page_callback' => 'bean_add',
  'page_arguments' => 'a:1:{i:0;s:6:"simple";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'block/add/simple',
  'title' => 'Simple',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/bean/includes/bean.pages.inc',
))
->values(array(
  'path' => 'blockreference/autocomplete/%/%/%/%',
  'load_functions' => 'a:4:{i:2;N;i:3;N;i:4;N;i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'blockreference_autocomplete_access',
  'access_arguments' => 'a:4:{i:0;i:2;i:1;i:3;i:2;i:4;i:3;i:5;}',
  'page_callback' => 'blockreference_autocomplete',
  'page_arguments' => 'a:4:{i:0;i:2;i:1;i:3;i:2;i:4;i:3;i:5;}',
  'delivery_callback' => '',
  'fit' => '48',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'blockreference/autocomplete/%/%/%/%',
  'title' => 'blockreference autocomplete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'ctools/autocomplete/%',
  'load_functions' => 'a:1:{i:2;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'ctools_content_autocomplete_entity',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '6',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'ctools/autocomplete/%',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/ctools/includes/content.menu.inc',
))
->values(array(
  'path' => 'ctools/context/ajax/access/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'ctools_access_ajax_add',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'ctools/context/ajax/access/add',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/ctools/includes/context-access-admin.inc',
))
->values(array(
  'path' => 'ctools/context/ajax/access/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'ctools_access_ajax_edit',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'ctools/context/ajax/access/configure',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/ctools/includes/context-access-admin.inc',
))
->values(array(
  'path' => 'ctools/context/ajax/access/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'ctools_access_ajax_delete',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'ctools/context/ajax/access/delete',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/ctools/includes/context-access-admin.inc',
))
->values(array(
  'path' => 'ctools/context/ajax/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'ctools_context_ajax_item_add',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'ctools/context/ajax/add',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/ctools/includes/context-admin.inc',
))
->values(array(
  'path' => 'ctools/context/ajax/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'ctools_context_ajax_item_edit',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'ctools/context/ajax/configure',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/ctools/includes/context-admin.inc',
))
->values(array(
  'path' => 'ctools/context/ajax/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'ctools_context_ajax_item_delete',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'ctools/context/ajax/delete',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/ctools/includes/context-admin.inc',
))
->values(array(
  'path' => 'file/ajax',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'file_ajax_upload',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => 'ajax_deliver',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'file/ajax',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'file/progress',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'file_ajax_progress',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'file/progress',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'filter/tips',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'filter_tips_long',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'filter/tips',
  'title' => 'Compose tips',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '20',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.pages.inc',
))
->values(array(
  'path' => 'filter/tips/%',
  'load_functions' => 'a:1:{i:2;s:18:"filter_format_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'filter_access',
  'access_arguments' => 'a:1:{i:0;i:2;}',
  'page_callback' => 'filter_tips_long',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '6',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'filter/tips/%',
  'title' => 'Compose tips',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.pages.inc',
))
->values(array(
  'path' => 'node',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'node_page_default',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'node/%',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:4:"view";i:1;i:1;}',
  'page_callback' => 'node_page_view',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '2',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/%',
  'title' => '',
  'title_callback' => 'node_page_title',
  'title_arguments' => 'a:1:{i:0;i:1;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'node/%/delete',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"delete";i:1;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:19:"node_delete_confirm";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '2',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/edit',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"update";i:1;i:1;}',
  'page_callback' => 'node_page_edit',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '3',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/revisions',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'node_revision_overview',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Revisions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/revisions/%/delete',
  'load_functions' => 'a:2:{i:1;a:1:{s:9:"node_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:2:{i:0;i:1;i:1;s:6:"delete";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"node_revision_delete_confirm";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '21',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/%/revisions/%/delete',
  'title' => 'Delete earlier revision',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/revisions/%/revert',
  'load_functions' => 'a:2:{i:1;a:1:{s:9:"node_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:2:{i:0;i:1;i:1;s:6:"update";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"node_revision_revert_confirm";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '21',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/%/revisions/%/revert',
  'title' => 'Revert to earlier revision',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/revisions/%/view',
  'load_functions' => 'a:2:{i:1;a:1:{s:9:"node_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'node_show',
  'page_arguments' => 'a:2:{i:0;i:1;i:1;b:1;}',
  'delivery_callback' => '',
  'fit' => '21',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/%/revisions/%/view',
  'title' => 'Revisions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'node/%/view',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:4:"view";i:1;i:1;}',
  'page_callback' => 'node_page_view',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'View',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => '',
))
->values(array(
  'path' => 'node/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_node_add_access',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'node_add_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/add',
  'title' => 'Add content',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/page',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:4:"page";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;s:4:"page";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/add/page',
  'title' => 'Basic page',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "Use <em>basic pages</em> for your static content, such as an 'About us' page.",
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'rss.xml',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'node_feed',
  'page_arguments' => 'a:2:{i:0;b:0;i:1;a:0:{}}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'rss.xml',
  'title' => 'RSS feed',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'sites/default/files/styles/%',
  'load_functions' => 'a:1:{i:4;s:16:"image_style_load";}',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'image_style_deliver',
  'page_arguments' => 'a:1:{i:0;i:4;}',
  'delivery_callback' => '',
  'fit' => '30',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'sites/default/files/styles/%',
  'title' => 'Generate image style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'system/ajax',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'ajax_form_callback',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => 'ajax_deliver',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'system/ajax',
  'title' => 'AHAH callback',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'includes/form.inc',
))
->values(array(
  'path' => 'system/files',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'file_download',
  'page_arguments' => 'a:1:{i:0;s:7:"private";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'system/files',
  'title' => 'File download',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'system/files/styles/%',
  'load_functions' => 'a:1:{i:3;s:16:"image_style_load";}',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'image_style_deliver',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'delivery_callback' => '',
  'fit' => '14',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'system/files/styles/%',
  'title' => 'Generate image style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'system/temporary',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'file_download',
  'page_arguments' => 'a:1:{i:0;s:9:"temporary";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'system/temporary',
  'title' => 'Temporary files',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'system/timezone',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'system_timezone',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'system/timezone',
  'title' => 'Time zone',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'user',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'user_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user',
  'title' => 'User account',
  'title_callback' => 'user_menu_title',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_view_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'user_view_page',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '2',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/%',
  'title' => 'My account',
  'title_callback' => 'user_page_title',
  'title_arguments' => 'a:1:{i:0;i:1;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'user/%/cancel',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_cancel_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"user_cancel_confirm_form";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/%/cancel',
  'title' => 'Cancel account',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/cancel/confirm/%/%',
  'load_functions' => 'a:3:{i:1;s:9:"user_load";i:4;N;i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_cancel_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'user_cancel_confirm',
  'page_arguments' => 'a:3:{i:0;i:1;i:1;i:4;i:2;i:5;}',
  'delivery_callback' => '',
  'fit' => '44',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/%/cancel/confirm/%/%',
  'title' => 'Confirm account cancellation',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/edit',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_edit_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:17:"user_profile_form";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'user/%',
  'tab_root' => 'user/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/edit/account',
  'load_functions' => 'a:1:{i:1;a:1:{s:18:"user_category_load";a:2:{i:0;s:4:"%map";i:1;s:6:"%index";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_edit_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:17:"user_profile_form";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '11',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'user/%/edit',
  'tab_root' => 'user/%',
  'title' => 'Account',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/view',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_view_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'user_view_page',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'user/%',
  'tab_root' => 'user/%',
  'title' => 'View',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => '',
))
->values(array(
  'path' => 'user/autocomplete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"access user profiles";}',
  'page_callback' => 'user_autocomplete',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/autocomplete',
  'title' => 'User autocomplete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/login',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_is_anonymous',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'user_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'user',
  'tab_root' => 'user',
  'title' => 'Log in',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/logout',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_is_logged_in',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'user_logout',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/logout',
  'title' => 'Log out',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/password',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:9:"user_pass";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'user',
  'tab_root' => 'user',
  'title' => 'Request new password',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/register',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_register_access',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:18:"user_register_form";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'user',
  'tab_root' => 'user',
  'title' => 'Create new account',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'user/reset/%/%/%',
  'load_functions' => 'a:3:{i:2;N;i:3;N;i:4;N;}',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:15:"user_pass_reset";i:1;i:2;i:2;i:3;i:3;i:4;}',
  'delivery_callback' => '',
  'fit' => '24',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/reset/%/%/%',
  'title' => 'Reset password',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'uuid',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'uuid_redirector',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'uuid',
  'title' => 'UUID redirector',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => 'Redirects requests for UUID URIs to the referenced entity.',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->execute();
$connection->schema()->createTable('node', array(
  'fields' => array(
    'nid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'changed' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'comment' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'promote' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'sticky' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'tnid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'translate' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'uuid' => array(
      'type' => 'char',
      'not null' => TRUE,
      'length' => '36',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'nid',
  ),
  'unique keys' => array(
    'vid' => array(
      'vid',
    ),
  ),
  'indexes' => array(
    'node_changed' => array(
      'changed',
    ),
    'node_created' => array(
      'created',
    ),
    'node_frontpage' => array(
      'promote',
      'status',
      'sticky',
      'created',
    ),
    'node_status_type' => array(
      'status',
      'type',
      'nid',
    ),
    'node_title_type' => array(
      array(
        'title',
        '191',
      ),
      array(
        'type',
        '4',
      ),
    ),
    'node_type' => array(
      array(
        'type',
        '4',
      ),
    ),
    'uid' => array(
      'uid',
    ),
    'tnid' => array(
      'tnid',
    ),
    'translate' => array(
      'translate',
    ),
    'language' => array(
      'language',
    ),
    'uuid' => array(
      'uuid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('node')
->fields(array(
  'nid',
  'vid',
  'type',
  'language',
  'title',
  'uid',
  'status',
  'created',
  'changed',
  'comment',
  'promote',
  'sticky',
  'tnid',
  'translate',
  'uuid',
))
->values(array(
  'nid' => '1',
  'vid' => '1',
  'type' => 'page',
  'language' => 'und',
  'title' => 'A basic page referencing beans',
  'uid' => '1',
  'status' => '1',
  'created' => '1611056846',
  'changed' => '1611056846',
  'comment' => '0',
  'promote' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
  'uuid' => '11b3c0f6-ba5a-49a8-ab6d-0161b49c36bd',
))
->execute();
$connection->schema()->createTable('node_access', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'gid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'realm' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'grant_view' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'grant_update' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'grant_delete' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'nid',
    'gid',
    'realm',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('node_access')
->fields(array(
  'nid',
  'gid',
  'realm',
  'grant_view',
  'grant_update',
  'grant_delete',
))
->values(array(
  'nid' => '0',
  'gid' => '0',
  'realm' => 'all',
  'grant_view' => '1',
  'grant_update' => '0',
  'grant_delete' => '0',
))
->execute();
$connection->schema()->createTable('node_revision', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'log' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ),
    'comment' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'promote' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'sticky' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'vuuid' => array(
      'type' => 'char',
      'not null' => TRUE,
      'length' => '36',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'indexes' => array(
    'nid' => array(
      'nid',
    ),
    'uid' => array(
      'uid',
    ),
    'vuuid' => array(
      'vuuid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('node_revision')
->fields(array(
  'nid',
  'vid',
  'uid',
  'title',
  'log',
  'timestamp',
  'status',
  'comment',
  'promote',
  'sticky',
  'vuuid',
))
->values(array(
  'nid' => '1',
  'vid' => '1',
  'uid' => '1',
  'title' => 'A basic page referencing beans',
  'log' => '',
  'timestamp' => '1611056846',
  'status' => '1',
  'comment' => '0',
  'promote' => '0',
  'sticky' => '0',
  'vuuid' => 'c75933e6-068a-4e42-bbac-eae255b38d95',
))
->execute();
$connection->schema()->createTable('node_type', array(
  'fields' => array(
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'base' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'medium',
    ),
    'help' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'medium',
    ),
    'has_title' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'unsigned' => TRUE,
    ),
    'title_label' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'custom' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'modified' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'locked' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'disabled' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'orig_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'type',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('node_type')
->fields(array(
  'type',
  'name',
  'base',
  'module',
  'description',
  'help',
  'has_title',
  'title_label',
  'custom',
  'modified',
  'locked',
  'disabled',
  'orig_type',
))
->values(array(
  'type' => 'page',
  'name' => 'Basic page',
  'base' => 'node_content',
  'module' => 'node',
  'description' => "Use <em>basic pages</em> for your static content, such as an 'About us' page.",
  'help' => '',
  'has_title' => '1',
  'title_label' => 'Title',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'disabled' => '0',
  'orig_type' => 'page',
))
->execute();
$connection->schema()->createTable('queue', array(
  'fields' => array(
    'item_id' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'item_id',
  ),
  'indexes' => array(
    'name_created' => array(
      array(
        'name',
        '191',
      ),
      'created',
    ),
    'expire' => array(
      'expire',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('registry', array(
  'fields' => array(
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '9',
      'default' => '',
    ),
    'filename' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'name',
    'type',
  ),
  'indexes' => array(
    'hook' => array(
      'type',
      'weight',
      array(
        'module',
        '191',
      ),
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('registry')
->fields(array(
  'name',
  'type',
  'filename',
  'module',
  'weight',
))
->values(array(
  'name' => 'AccessDeniedTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'AdminMetaTagTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ArchiverInterface',
  'type' => 'interface',
  'filename' => 'includes/archiver.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'ArchiverTar',
  'type' => 'class',
  'filename' => 'modules/system/system.archiver.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ArchiverZip',
  'type' => 'class',
  'filename' => 'modules/system/system.archiver.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'Archive_Tar',
  'type' => 'class',
  'filename' => 'modules/system/system.tar.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'BatchMemoryQueue',
  'type' => 'class',
  'filename' => 'includes/batch.queue.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'BatchQueue',
  'type' => 'class',
  'filename' => 'includes/batch.queue.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'Bean',
  'type' => 'class',
  'filename' => 'sites/all/modules/bean/includes/bean.core.inc',
  'module' => 'bean',
  'weight' => '0',
))
->values(array(
  'name' => 'BeanAccess',
  'type' => 'class',
  'filename' => 'sites/all/modules/bean/bean.test',
  'module' => 'bean',
  'weight' => '0',
))
->values(array(
  'name' => 'BeanCustom',
  'type' => 'class',
  'filename' => 'sites/all/modules/bean/bean_admin_ui/plugins/BeanCustom.class.php',
  'module' => 'bean_admin_ui',
  'weight' => '0',
))
->values(array(
  'name' => 'BeanDefault',
  'type' => 'class',
  'filename' => 'sites/all/modules/bean/plugins/BeanDefault.class.php',
  'module' => 'bean',
  'weight' => '0',
))
->values(array(
  'name' => 'BeanEntityAPIController',
  'type' => 'class',
  'filename' => 'sites/all/modules/bean/includes/bean.core.inc',
  'module' => 'bean',
  'weight' => '0',
))
->values(array(
  'name' => 'BeanException',
  'type' => 'class',
  'filename' => 'sites/all/modules/bean/includes/bean.core.inc',
  'module' => 'bean',
  'weight' => '0',
))
->values(array(
  'name' => 'BeanInlineEntityFormController',
  'type' => 'class',
  'filename' => 'sites/all/modules/bean/includes/bean.inline_entity_form.inc',
  'module' => 'bean',
  'weight' => '0',
))
->values(array(
  'name' => 'BeanIntegrationTests',
  'type' => 'class',
  'filename' => 'sites/all/modules/bean/bean.test',
  'module' => 'bean',
  'weight' => '0',
))
->values(array(
  'name' => 'BeanMetadataController',
  'type' => 'class',
  'filename' => 'sites/all/modules/bean/includes/bean.info.inc',
  'module' => 'bean',
  'weight' => '0',
))
->values(array(
  'name' => 'BeanPlugin',
  'type' => 'class',
  'filename' => 'sites/all/modules/bean/plugins/BeanPlugin.class.php',
  'module' => 'bean',
  'weight' => '0',
))
->values(array(
  'name' => 'BeanSetup',
  'type' => 'class',
  'filename' => 'sites/all/modules/bean/bean.test',
  'module' => 'bean',
  'weight' => '0',
))
->values(array(
  'name' => 'BeanTestPlugins',
  'type' => 'class',
  'filename' => 'sites/all/modules/bean/bean.test',
  'module' => 'bean',
  'weight' => '0',
))
->values(array(
  'name' => 'BeanTests',
  'type' => 'class',
  'filename' => 'sites/all/modules/bean/bean.test',
  'module' => 'bean',
  'weight' => '0',
))
->values(array(
  'name' => 'BeanTypePluginInterface',
  'type' => 'interface',
  'filename' => 'sites/all/modules/bean/includes/bean.core.inc',
  'module' => 'bean',
  'weight' => '0',
))
->values(array(
  'name' => 'BeanUnitTests',
  'type' => 'class',
  'filename' => 'sites/all/modules/bean/bean.test',
  'module' => 'bean',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockAdminThemeTestCase',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockCacheTestCase',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockHashTestCase',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockHiddenRegionTestCase',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockHTMLIdTestCase',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockInvalidRegionTestCase',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockTemplateSuggestionsUnitTest',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockTestCase',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockViewModuleDeltaAlterWebTest',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'ConfirmFormTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'CronQueueTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'CronRunTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsContextIDTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/tests/context.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsContextKeywordsSubstitutionTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/tests/context.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsContextUnitTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/tests/context.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CToolsCssCache',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/includes/css-cache.inc',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsCSSObjectCache',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/tests/css_cache.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsCssTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/tests/css.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsMathExpressionStackTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/tests/math_expression_stack.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsMathExpressionTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/tests/math_expression.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsModuleTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/tests/ctools.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsObjectCache',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/tests/object_cache.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsPageTokens',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/tests/page_tokens.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsPluginsGetInfoTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/tests/ctools.plugins.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsUnitObjectCachePlugins',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/tests/object_cache_unit.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'ctools_context',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/includes/context.inc',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'ctools_context_optional',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/includes/context.inc',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'ctools_context_required',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/includes/context.inc',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'ctools_export_ui',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/plugins/export_ui/ctools_export_ui.class.php',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'ctools_math_expr',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/includes/math-expr.inc',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'ctools_math_expr_stack',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/includes/math-expr.inc',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'ctools_stylizer_image_processor',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/includes/stylizer.inc',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'Database',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseCondition',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseConnection',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseConnectionNotDefinedException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseConnection_mysql',
  'type' => 'class',
  'filename' => 'includes/database/mysql/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseConnection_pgsql',
  'type' => 'class',
  'filename' => 'includes/database/pgsql/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseConnection_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseDriverNotSpecifiedException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseLog',
  'type' => 'class',
  'filename' => 'includes/database/log.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseSchema',
  'type' => 'class',
  'filename' => 'includes/database/schema.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseSchemaObjectDoesNotExistException',
  'type' => 'class',
  'filename' => 'includes/database/schema.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseSchemaObjectExistsException',
  'type' => 'class',
  'filename' => 'includes/database/schema.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseSchema_mysql',
  'type' => 'class',
  'filename' => 'includes/database/mysql/schema.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseSchema_pgsql',
  'type' => 'class',
  'filename' => 'includes/database/pgsql/schema.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseSchema_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/schema.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseStatementBase',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseStatementEmpty',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseStatementInterface',
  'type' => 'interface',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseStatementPrefetch',
  'type' => 'class',
  'filename' => 'includes/database/prefetch.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseStatement_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTaskException',
  'type' => 'class',
  'filename' => 'includes/install.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTasks',
  'type' => 'class',
  'filename' => 'includes/install.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTasks_mysql',
  'type' => 'class',
  'filename' => 'includes/database/mysql/install.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTasks_pgsql',
  'type' => 'class',
  'filename' => 'includes/database/pgsql/install.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTasks_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/install.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTransaction',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTransactionCommitFailedException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTransactionExplicitCommitNotAllowedException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTransactionNameNonUniqueException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTransactionNoActiveException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTransactionOutOfOrderException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DateFormatTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'DateTimeFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'DefaultMailSystem',
  'type' => 'class',
  'filename' => 'modules/system/system.mail.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'DeleteQuery',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DeleteQuery_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalCacheArray',
  'type' => 'class',
  'filename' => 'includes/bootstrap.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalCacheInterface',
  'type' => 'interface',
  'filename' => 'includes/cache.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalDatabaseCache',
  'type' => 'class',
  'filename' => 'includes/cache.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalDefaultEntityController',
  'type' => 'class',
  'filename' => 'includes/entity.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalEntityControllerInterface',
  'type' => 'interface',
  'filename' => 'includes/entity.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalFakeCache',
  'type' => 'class',
  'filename' => 'includes/cache-install.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalLocalStreamWrapper',
  'type' => 'class',
  'filename' => 'includes/stream_wrappers.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalPrivateStreamWrapper',
  'type' => 'class',
  'filename' => 'includes/stream_wrappers.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalPublicStreamWrapper',
  'type' => 'class',
  'filename' => 'includes/stream_wrappers.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalQueue',
  'type' => 'class',
  'filename' => 'modules/system/system.queue.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalQueueInterface',
  'type' => 'interface',
  'filename' => 'modules/system/system.queue.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalReliableQueueInterface',
  'type' => 'interface',
  'filename' => 'modules/system/system.queue.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalRequestSanitizer',
  'type' => 'class',
  'filename' => 'includes/request-sanitizer.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalSetMessageTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalStreamWrapperInterface',
  'type' => 'interface',
  'filename' => 'includes/stream_wrappers.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalTemporaryStreamWrapper',
  'type' => 'class',
  'filename' => 'includes/stream_wrappers.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalUpdateException',
  'type' => 'class',
  'filename' => 'includes/update.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalUpdaterInterface',
  'type' => 'interface',
  'filename' => 'includes/updater.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'EnableDisableTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'Entity',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityAPICommentNodeAccessTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.test',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityAPIController',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.controller.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityAPIControllerExportable',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.controller.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityAPIControllerInterface',
  'type' => 'interface',
  'filename' => 'sites/all/modules/entity/includes/entity.controller.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityAPIControllerRevisionableInterface',
  'type' => 'interface',
  'filename' => 'sites/all/modules/entity/includes/entity.controller.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityAPIi18nItegrationTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.test',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityAPIRulesIntegrationTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.test',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityAPITestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.test',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityBundleableUIController',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.ui.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityContentUIController',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.ui.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityDB',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityDBExtendable',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityDefaultExtraFieldsController',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.info.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityDefaultFeaturesController',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.features.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityDefaultI18nStringController',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.i18n.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityDefaultMetadataController',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.info.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityDefaultRulesController',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.rules.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityDefaultUIController',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.ui.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityDefaultViewsController',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/entity.views.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityDrupalWrapper',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.wrapper.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityExtendable',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityExtraFieldsControllerInterface',
  'type' => 'interface',
  'filename' => 'sites/all/modules/entity/entity.info.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityFieldHandlerHelper',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_field_handler_helper.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityFieldQuery',
  'type' => 'class',
  'filename' => 'includes/entity.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityFieldQueryException',
  'type' => 'class',
  'filename' => 'includes/entity.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityInterface',
  'type' => 'interface',
  'filename' => 'sites/all/modules/entity/includes/entity.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityListWrapper',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.wrapper.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityMalformedException',
  'type' => 'class',
  'filename' => 'includes/entity.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityMetadataArrayObject',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.wrapper.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityMetadataIntegrationTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.test',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityMetadataNodeAccessTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.test',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityMetadataNodeCreateAccessTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.test',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityMetadataNodeRevisionAccessTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.test',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityMetadataTaxonomyAccessTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.test',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityMetadataTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.test',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityMetadataWrapper',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.wrapper.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityMetadataWrapperException',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.wrapper.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityMetadataWrapperIterator',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.wrapper.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityPropertiesTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityStructureWrapper',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.wrapper.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityTokenTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.test',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityTranslationBeanHandler',
  'type' => 'class',
  'filename' => 'sites/all/modules/bean/includes/translation.handler.bean.inc',
  'module' => 'bean',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityValueWrapper',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.wrapper.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityViewModeFunctionalTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_view_mode/entity_view_mode.test',
  'module' => 'entity_view_mode',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityViewModeSuggestionsTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_view_mode/entity_view_mode.test',
  'module' => 'entity_view_mode',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityViewModeTestHelper',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_view_mode/entity_view_mode.test',
  'module' => 'entity_view_mode',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityWebTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.test',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_area_entity',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_area_entity.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_field_boolean',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_boolean.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_field_date',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_date.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_field_duration',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_duration.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_field_entity',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_entity.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_field_field',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_field.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_field_numeric',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_numeric.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_field_options',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_options.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_field_text',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_text.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_field_uri',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_uri.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_relationship',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_relationship.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_relationship_by_bundle',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_relationship_by_bundle.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_plugin_row_entity_view',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/plugins/entity_views_plugin_row_entity_view.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldAttachOtherTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldAttachStorageTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldAttachTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldBulkDeleteTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldCrudTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldDisplayAPITestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldException',
  'type' => 'class',
  'filename' => 'modules/field/field.module',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldFormTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldInfo',
  'type' => 'class',
  'filename' => 'modules/field/field.info.class.inc',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldInfoTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldInstanceCrudTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldsOverlapException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldSqlStorageTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/field_sql_storage/field_sql_storage.test',
  'module' => 'field_sql_storage',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldTranslationsTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldUIAlterTestCase',
  'type' => 'class',
  'filename' => 'modules/field_ui/field_ui.test',
  'module' => 'field_ui',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldUIManageDisplayTestCase',
  'type' => 'class',
  'filename' => 'modules/field_ui/field_ui.test',
  'module' => 'field_ui',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldUIManageFieldsTestCase',
  'type' => 'class',
  'filename' => 'modules/field_ui/field_ui.test',
  'module' => 'field_ui',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldUITestCase',
  'type' => 'class',
  'filename' => 'modules/field_ui/field_ui.test',
  'module' => 'field_ui',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldUpdateForbiddenException',
  'type' => 'class',
  'filename' => 'modules/field/field.module',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldValidationException',
  'type' => 'class',
  'filename' => 'modules/field/field.attach.inc',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FileFieldAnonymousSubmission',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileFieldDisplayTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileFieldPathTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileFieldRevisionTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileFieldTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileFieldValidateTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileFieldWidgetTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileManagedFileElementTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FilePrivateTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileScanDirectory',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTaxonomyTermTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTokenReplaceTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransfer',
  'type' => 'class',
  'filename' => 'includes/filetransfer/filetransfer.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransferChmodInterface',
  'type' => 'interface',
  'filename' => 'includes/filetransfer/filetransfer.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransferException',
  'type' => 'class',
  'filename' => 'includes/filetransfer/filetransfer.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransferFTP',
  'type' => 'class',
  'filename' => 'includes/filetransfer/ftp.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransferFTPExtension',
  'type' => 'class',
  'filename' => 'includes/filetransfer/ftp.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransferLocal',
  'type' => 'class',
  'filename' => 'includes/filetransfer/local.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransferSSH',
  'type' => 'class',
  'filename' => 'includes/filetransfer/ssh.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterAdminTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterCRUDTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterDefaultFormatTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterDOMSerializeTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterFormatAccessTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterHooksTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterNoFormatTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterSecurityTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterSettingsTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterUnitTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FloodFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'FrontPageTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'HookRequirementsTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageAdminStylesUnitTest',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageAdminUiTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageDimensionsScaleTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageDimensionsTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageEffectsUnitTest',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageFieldDefaultImagesTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageFieldDisplayTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageFieldTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageFieldValidateTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageStyleFlushTest',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageStylesPathAndUrlTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageThemeFunctionWebTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'InfoFileParserTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'InsertQuery',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'InsertQuery_mysql',
  'type' => 'class',
  'filename' => 'includes/database/mysql/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'InsertQuery_pgsql',
  'type' => 'class',
  'filename' => 'includes/database/pgsql/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'InsertQuery_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'InvalidMergeQueryException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'IPAddressBlockingTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'MailSystemInterface',
  'type' => 'interface',
  'filename' => 'includes/mail.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'MemoryQueue',
  'type' => 'class',
  'filename' => 'modules/system/system.queue.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'MergeQuery',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'MigrateBlockReferenceFieldHandler',
  'type' => 'class',
  'filename' => 'sites/all/modules/blockreference/MigrateBlockReferenceFieldHandler.inc',
  'module' => 'blockreference',
  'weight' => '0',
))
->values(array(
  'name' => 'ModuleDependencyTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ModuleRequiredTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ModuleTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ModuleUpdater',
  'type' => 'class',
  'filename' => 'modules/system/system.updater.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ModuleVersionTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'MultiStepNodeFormBasicOptionsTest',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NewDefaultThemeBlocks',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeAccessBaseTableTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeAccessFieldTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeAccessPagerTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeAccessRebuildTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeAccessRecordsTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeAccessTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeAdminTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeBlockFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeBlockTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeBuildContent',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeController',
  'type' => 'class',
  'filename' => 'modules/node/node.module',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeCreationTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeEntityFieldQueryAlter',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeEntityViewModeAlterTest',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeFeedTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeLoadHooksTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeLoadMultipleTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeMultiByteUtf8Test',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodePageCacheTest',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodePostSettingsTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeQueryAlter',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeRevisionPermissionsTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeRevisionsTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeRSSContentTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeSaveTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeTitleTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeTitleXSSTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeTokenReplaceTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeTypePersistenceTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeTypeTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeWebTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NoFieldsException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'NonDefaultBlockAdmin',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'OptionsSelectDynamicValuesTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/options/options.test',
  'module' => 'options',
  'weight' => '0',
))
->values(array(
  'name' => 'OptionsWidgetsTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/options/options.test',
  'module' => 'options',
  'weight' => '0',
))
->values(array(
  'name' => 'PageEditTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'PageNotFoundTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'PagePreviewTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'PagerDefault',
  'type' => 'class',
  'filename' => 'includes/pager.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'PageTitleFiltering',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'PageViewTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'Query',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'QueryAlterableInterface',
  'type' => 'interface',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'QueryConditionInterface',
  'type' => 'interface',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'QueryExtendableInterface',
  'type' => 'interface',
  'filename' => 'includes/database/select.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'QueryPlaceholderInterface',
  'type' => 'interface',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'QueueTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'RetrieveFileTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SchemaCache',
  'type' => 'class',
  'filename' => 'includes/bootstrap.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'SelectQuery',
  'type' => 'class',
  'filename' => 'includes/database/select.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'SelectQueryExtender',
  'type' => 'class',
  'filename' => 'includes/database/select.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'SelectQueryInterface',
  'type' => 'interface',
  'filename' => 'includes/database/select.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'SelectQuery_pgsql',
  'type' => 'class',
  'filename' => 'includes/database/pgsql/select.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'SelectQuery_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/select.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'ShutdownFunctionsTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SiteMaintenanceTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SkipDotsRecursiveDirectoryIterator',
  'type' => 'class',
  'filename' => 'includes/filetransfer/filetransfer.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'StreamWrapperInterface',
  'type' => 'interface',
  'filename' => 'includes/stream_wrappers.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'SummaryLengthTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemAdminTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemAuthorizeCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemBlockTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemIndexPhpTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemInfoAlterTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemMainContentFallback',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemQueue',
  'type' => 'class',
  'filename' => 'modules/system/system.queue.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemThemeFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemValidTokenTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'TableSort',
  'type' => 'class',
  'filename' => 'includes/tablesort.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'TestingMailSystem',
  'type' => 'class',
  'filename' => 'modules/system/system.mail.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'TextFieldTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/text/text.test',
  'module' => 'text',
  'weight' => '0',
))
->values(array(
  'name' => 'TextSummaryTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/text/text.test',
  'module' => 'text',
  'weight' => '0',
))
->values(array(
  'name' => 'TextTranslationTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/text/text.test',
  'module' => 'text',
  'weight' => '0',
))
->values(array(
  'name' => 'ThemeRegistry',
  'type' => 'class',
  'filename' => 'includes/theme.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'ThemeUpdater',
  'type' => 'class',
  'filename' => 'modules/system/system.updater.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'TokenReplaceTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'TokenScanTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'TruncateQuery',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'TruncateQuery_mysql',
  'type' => 'class',
  'filename' => 'includes/database/mysql/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'TruncateQuery_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdateQuery',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdateQuery_mysql',
  'type' => 'class',
  'filename' => 'includes/database/mysql/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdateQuery_pgsql',
  'type' => 'class',
  'filename' => 'includes/database/pgsql/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdateQuery_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'Updater',
  'type' => 'class',
  'filename' => 'includes/updater.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdaterException',
  'type' => 'class',
  'filename' => 'includes/updater.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdaterFileTransferException',
  'type' => 'class',
  'filename' => 'includes/updater.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdateScriptFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'UserAccountLinksUnitTests',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserAdminTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserAuthmapAssignmentTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserAutocompleteTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserBlocksUnitTests',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserCancelTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserController',
  'type' => 'class',
  'filename' => 'modules/user/user.module',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserCreateTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserEditedOwnAccountTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserEditRebuildTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserEditTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserLoginTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserPasswordResetTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserPermissionsTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserPictureTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserRegistrationTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserRoleAdminTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserRolesAssignmentTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserSaveTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserSignatureTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserTimeZoneFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserTokenReplaceTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserUserSearchTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserValidateCurrentPassCustomForm',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserValidationTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UUIDAPITestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/uuid/uuid.test',
  'module' => 'uuid',
  'weight' => '0',
))
->values(array(
  'name' => 'UUIDCommentTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/uuid/uuid.test',
  'module' => 'uuid',
  'weight' => '0',
))
->values(array(
  'name' => 'UUIDEntityTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/uuid/uuid.test',
  'module' => 'uuid',
  'weight' => '0',
))
->values(array(
  'name' => 'UUIDNodeTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/uuid/uuid.test',
  'module' => 'uuid',
  'weight' => '0',
))
->values(array(
  'name' => 'UUIDSyncTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/uuid/uuid.test',
  'module' => 'uuid',
  'weight' => '0',
))
->values(array(
  'name' => 'UUIDTaxonomyTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/uuid/uuid.test',
  'module' => 'uuid',
  'weight' => '0',
))
->values(array(
  'name' => 'UUIDTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/uuid/uuid.test',
  'module' => 'uuid',
  'weight' => '0',
))
->values(array(
  'name' => 'UUIDUserTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/uuid/uuid.test',
  'module' => 'uuid',
  'weight' => '0',
))
->values(array(
  'name' => 'UUIDV5TestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/uuid/uuid.test',
  'module' => 'uuid',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_bean_delete_link',
  'type' => 'class',
  'filename' => 'sites/all/modules/bean/views/views_handler_field_bean_delete_link.inc',
  'module' => 'bean',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_bean_edit_link',
  'type' => 'class',
  'filename' => 'sites/all/modules/bean/views/views_handler_field_bean_edit_link.inc',
  'module' => 'bean',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_bean_operations',
  'type' => 'class',
  'filename' => 'sites/all/modules/bean/views/views_handler_field_bean_operations.inc',
  'module' => 'bean',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_bean_type',
  'type' => 'class',
  'filename' => 'sites/all/modules/bean/views/views_handler_field_bean_type.inc',
  'module' => 'bean',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_bean_type',
  'type' => 'class',
  'filename' => 'sites/all/modules/bean/views/views_handler_filter_bean_type.inc',
  'module' => 'bean',
  'weight' => '0',
))
->execute();
$connection->schema()->createTable('registry_file', array(
  'fields' => array(
    'filename' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'hash' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
  ),
  'primary key' => array(
    'filename',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('registry_file')
->fields(array(
  'filename',
  'hash',
))
->values(array(
  'filename' => 'includes/actions.inc',
  'hash' => 'f36b066681463c7dfe189e0430cb1a89bf66f7e228cbb53cdfcd93987193f759',
))
->values(array(
  'filename' => 'includes/ajax.inc',
  'hash' => '8d5ebead219c48d5929ee6a5a178a331471ee6ceb38653094514c952457eaebd',
))
->values(array(
  'filename' => 'includes/archiver.inc',
  'hash' => 'bdbb21b712a62f6b913590b609fd17cd9f3c3b77c0d21f68e71a78427ed2e3e9',
))
->values(array(
  'filename' => 'includes/authorize.inc',
  'hash' => '6d64d8c21aa01eb12fc29918732e4df6b871ed06e5d41373cb95c197ed661d13',
))
->values(array(
  'filename' => 'includes/batch.inc',
  'hash' => '3480548cff18a67cf26072e041058cabe64bb839c6320a9050dc32eb87534aef',
))
->values(array(
  'filename' => 'includes/batch.queue.inc',
  'hash' => '554b2e92e1dad0f7fd5a19cb8dff7e109f10fbe2441a5692d076338ec908de0f',
))
->values(array(
  'filename' => 'includes/bootstrap.inc',
  'hash' => 'dc09fa65a08e5cf64980ff59bbca0252549dbbbdde1a6b6619109526316351b6',
))
->values(array(
  'filename' => 'includes/cache-install.inc',
  'hash' => 'e7ed123c5805703c84ad2cce9c1ca46b3ce8caeeea0d8ef39a3024a4ab95fa0e',
))
->values(array(
  'filename' => 'includes/cache.inc',
  'hash' => '033c9bf2555dba29382b077f78cc00c82fd7f42a959ba31b710adddf6fdf24fe',
))
->values(array(
  'filename' => 'includes/common.inc',
  'hash' => 'ae34badd3f77d27fc9e4eddc5cc48d657fc8701313bb8a176eac808524e3ddb2',
))
->values(array(
  'filename' => 'includes/database/database.inc',
  'hash' => '3b90b8ebf834894f075cfd9d135076679bc6677c4b73b7441550ac217a0010dc',
))
->values(array(
  'filename' => 'includes/database/log.inc',
  'hash' => '9feb5a17ae2fabcf26a96d2a634ba73da501f7bcfc3599a693d916a6971d00d1',
))
->values(array(
  'filename' => 'includes/database/mysql/database.inc',
  'hash' => '6dded0be670ce06b00b30e7c226224ecf344adb90c98af120c052ca6d8a80ac0',
))
->values(array(
  'filename' => 'includes/database/mysql/install.inc',
  'hash' => '6ae316941f771732fbbabed7e1d6b4cbb41b1f429dd097d04b3345aa15e461a0',
))
->values(array(
  'filename' => 'includes/database/mysql/query.inc',
  'hash' => 'cddf695f7dbd483591f93af805e7118a04eac3f21c0105326642c6463587670c',
))
->values(array(
  'filename' => 'includes/database/mysql/schema.inc',
  'hash' => 'c34aa7b7d2cb4662965497ff86f242224116bbd9b72ca6287c12039a65feb72e',
))
->values(array(
  'filename' => 'includes/database/pgsql/database.inc',
  'hash' => '651bec324e2204aa35a28fdbd876aa8e4f7a9e909e75cc8db811e9c156b0df88',
))
->values(array(
  'filename' => 'includes/database/pgsql/install.inc',
  'hash' => '39587f26a9e054afaab2064d996af910f1b201ef1c6b82938ef130e4ff8c6aab',
))
->values(array(
  'filename' => 'includes/database/pgsql/query.inc',
  'hash' => '0df57377686c921e722a10b49d5e433b131176c8059a4ace4680964206fc14b4',
))
->values(array(
  'filename' => 'includes/database/pgsql/schema.inc',
  'hash' => '1588daadfa53506aa1f5d94572162a45a46dc3ceabdd0e2f224532ded6508403',
))
->values(array(
  'filename' => 'includes/database/pgsql/select.inc',
  'hash' => '1e509bc97c58223750e8ea735145b316827e36f43c07b946003e41f5bca23659',
))
->values(array(
  'filename' => 'includes/database/prefetch.inc',
  'hash' => 'b5b207a66a69ecb52ee4f4459af16a7b5eabedc87254245f37cc33bebb61c0fb',
))
->values(array(
  'filename' => 'includes/database/query.inc',
  'hash' => '982d44a294eea1c9619687c14df2987257e3776fcabeba05f01432e934cf61c6',
))
->values(array(
  'filename' => 'includes/database/schema.inc',
  'hash' => 'da9d48f26c3a47a91f1eb2fa216e9deab2ec42ba10c76039623ce7b6bc984a06',
))
->values(array(
  'filename' => 'includes/database/select.inc',
  'hash' => 'ffb07459c3276d9bd05edec7c1c9ebf192bcb9dfdaa176c362cd91ea01f64d93',
))
->values(array(
  'filename' => 'includes/database/sqlite/database.inc',
  'hash' => '29f3af120e90b3a3b6d6623bde5fc669860a9730765d147ac6fd922a7c400043',
))
->values(array(
  'filename' => 'includes/database/sqlite/install.inc',
  'hash' => '6620f354aa175a116ba3a0562c980d86cc3b8b481042fc3cc5ed6a4d1a7a6d74',
))
->values(array(
  'filename' => 'includes/database/sqlite/query.inc',
  'hash' => '5d4dc3ac34cb2dbc0293471e85e37c890da3da6cd8c0c540c6f33313e4c0cbe9',
))
->values(array(
  'filename' => 'includes/database/sqlite/schema.inc',
  'hash' => '223f150f314374835c636ba3ada9a1ccd5159a6e09adfc22570953c3c4d855e2',
))
->values(array(
  'filename' => 'includes/database/sqlite/select.inc',
  'hash' => '8d1c426dbd337733c206cce9f59a172546c6ed856d8ef3f1c7bef05a16f7bf68',
))
->values(array(
  'filename' => 'includes/date.inc',
  'hash' => '1de2c25e3b67a9919fc6c8061594442b6fb2cdd3a48ddf1591ee3aa98484b737',
))
->values(array(
  'filename' => 'includes/entity.inc',
  'hash' => 'f06b508f93e72ba70f979d8391be57662c018a03a32fac0a6d3baa752740133d',
))
->values(array(
  'filename' => 'includes/errors.inc',
  'hash' => 'd731bbe3a60508e164cfa90b8edc06400c7f15844f9f9bc3935dd87e44c460db',
))
->values(array(
  'filename' => 'includes/file.inc',
  'hash' => '8c4b185c5805ee811e7d6292e2924de24ebf30080f74c173bf8d5cc771c4fff6',
))
->values(array(
  'filename' => 'includes/file.mimetypes.inc',
  'hash' => '33266e837f4ce076378e7e8cef6c5af46446226ca4259f83e13f605856a7f147',
))
->values(array(
  'filename' => 'includes/file.phar.inc',
  'hash' => '544df23f736ce49f458033d6515a301a8ca1c7a7d1bfd3f388caef910534abb3',
))
->values(array(
  'filename' => 'includes/filetransfer/filetransfer.inc',
  'hash' => '68442c03fd8612297a0d1ab86437ff9072fe1b71516f4c1e9f581d137a774698',
))
->values(array(
  'filename' => 'includes/filetransfer/ftp.inc',
  'hash' => '51eb119b8e1221d598ffa6cc46c8a322aa77b49a3d8879f7fb38b7221cf7e06d',
))
->values(array(
  'filename' => 'includes/filetransfer/local.inc',
  'hash' => '7cbfdb46abbdf539640db27e66fb30e5265128f31002bd0dfc3af16ae01a9492',
))
->values(array(
  'filename' => 'includes/filetransfer/ssh.inc',
  'hash' => '92f1232158cb32ab04cbc93ae38ad3af04796e18f66910a9bc5ca8e437f06891',
))
->values(array(
  'filename' => 'includes/form.inc',
  'hash' => '0900d375a3e620d9c78995c7836b98d73ec125942a650e741667bbd14fc86b2a',
))
->values(array(
  'filename' => 'includes/graph.inc',
  'hash' => '8e0e313a8bb33488f371df11fc1b58d7cf80099b886cd1003871e2c896d1b536',
))
->values(array(
  'filename' => 'includes/image.inc',
  'hash' => 'bcdc7e1599c02227502b9d0fe36eeb2b529b130a392bc709eb737647bd361826',
))
->values(array(
  'filename' => 'includes/install.core.inc',
  'hash' => '189653e4bb7d4828bd6e1b61015fabcc7182e23d9dd8858170f98114d99400c8',
))
->values(array(
  'filename' => 'includes/install.inc',
  'hash' => '4d0b8c1532a8829051e17f275fa27e9c379ab826aee2e27229a9679ea6775da7',
))
->values(array(
  'filename' => 'includes/iso.inc',
  'hash' => '0ce4c225edcfa9f037703bc7dd09d4e268a69bcc90e55da0a3f04c502bd2f349',
))
->values(array(
  'filename' => 'includes/json-encode.inc',
  'hash' => '02a822a652d00151f79db9aa9e171c310b69b93a12f549bc2ce00533a8efa14e',
))
->values(array(
  'filename' => 'includes/language.inc',
  'hash' => '4e08f30843a7ccaeea5c041083e9f77d33d57ff002f1ab4f66168e2c683ce128',
))
->values(array(
  'filename' => 'includes/locale.inc',
  'hash' => 'ca50acc0780cbffeca17f99a0997f91b8b9402f0eec1898c3122e1d73664d01d',
))
->values(array(
  'filename' => 'includes/lock.inc',
  'hash' => 'a181c8bd4f88d292a0a73b9f1fbd727e3314f66ec3631f288e6b9a54ba2b70fa',
))
->values(array(
  'filename' => 'includes/mail.inc',
  'hash' => 'a7bef724e057f7410e42c8f33b00c9a0246a2ca2e856a113c9e20eecc49fc069',
))
->values(array(
  'filename' => 'includes/menu.inc',
  'hash' => '3613d45c65662a5edd86e715ffdc9c411232690e11b6933ed06569cbac8c7e9a',
))
->values(array(
  'filename' => 'includes/module.inc',
  'hash' => '943626f94bc69e95e36fde030475d57893f3296f0f8df461e2ee9f122dd37473',
))
->values(array(
  'filename' => 'includes/pager.inc',
  'hash' => '7d8d827eb2baace7031a02fd4b15a5e684928cd8345f878dd707adce11f93bd2',
))
->values(array(
  'filename' => 'includes/password.inc',
  'hash' => 'fd9a1c94fe5a0fa7c7049a2435c7280b1d666b2074595010e3c492dd15712775',
))
->values(array(
  'filename' => 'includes/path.inc',
  'hash' => 'acfd48f5582893af86cbb5ccf331ddb43bbf2671e879e5424a21c928d06d949f',
))
->values(array(
  'filename' => 'includes/registry.inc',
  'hash' => '2067cc87973e7af23428d3f41b8f8739d80092bc3c9e20b5a8858e481d03f22c',
))
->values(array(
  'filename' => 'includes/request-sanitizer.inc',
  'hash' => '770e8ece7b53d13e2b5ef99da02adb9a3d18071c6cd29eb01af30927cf749a73',
))
->values(array(
  'filename' => 'includes/session.inc',
  'hash' => '68dad2eb48e0f7336c7dfc953b4b8b23c95042de9ad480d127beeefd46552250',
))
->values(array(
  'filename' => 'includes/stream_wrappers.inc',
  'hash' => 'b8a5a53f3d3ef26ea868037547f76af8049ce0c55b464810c627310a84f24924',
))
->values(array(
  'filename' => 'includes/tablesort.inc',
  'hash' => '2d88768a544829595dd6cda2a5eb008bedb730f36bba6dfe005d9ddd999d5c0f',
))
->values(array(
  'filename' => 'includes/theme.inc',
  'hash' => 'ffef4dc87e40ba6e57ac90fd1d81c30ff59da9f5407ddbae98d5597cbae5691a',
))
->values(array(
  'filename' => 'includes/theme.maintenance.inc',
  'hash' => '39f068b3eee4d10a90d6aa3c86db587b6d25844c2919d418d34d133cfe330f5a',
))
->values(array(
  'filename' => 'includes/token.inc',
  'hash' => '5e7898cd78689e2c291ed3cd8f41c032075656896f1db57e49217aac19ae0428',
))
->values(array(
  'filename' => 'includes/unicode.entities.inc',
  'hash' => '2b858138596d961fbaa4c6e3986e409921df7f76b6ee1b109c4af5970f1e0f54',
))
->values(array(
  'filename' => 'includes/unicode.inc',
  'hash' => 'e18772dafe0f80eb139fcfc582fef1704ba9f730647057d4f4841d6a6e4066ca',
))
->values(array(
  'filename' => 'includes/update.inc',
  'hash' => '25c30f1e61ef9c91a7bdeb37791c2215d9dc2ae07dba124722d783ca31bb01e7',
))
->values(array(
  'filename' => 'includes/updater.inc',
  'hash' => 'd2da0e74ed86e93c209f16069f3d32e1a134ceb6c06a0044f78e841a1b54e380',
))
->values(array(
  'filename' => 'includes/utility.inc',
  'hash' => '3458fd2b55ab004dd0cc529b8e58af12916e8bd36653b072bdd820b26b907ed5',
))
->values(array(
  'filename' => 'includes/xmlrpc.inc',
  'hash' => 'ea24176ec445c440ba0c825fc7b04a31b440288df8ef02081560dc418e34e659',
))
->values(array(
  'filename' => 'includes/xmlrpcs.inc',
  'hash' => '925c4d5bf429ad9650f059a8862a100bd394dce887933f5b3e7e32309a51fd8e',
))
->values(array(
  'filename' => 'modules/block/block.test',
  'hash' => '40d9de00589211770a85c47d38c8ad61c598ec65d9332128a882eb8750e65a16',
))
->values(array(
  'filename' => 'modules/field/field.attach.inc',
  'hash' => '2df4687b5ec078c4893dc1fea514f67524fd5293de717b9e05caf977e5ae2327',
))
->values(array(
  'filename' => 'modules/field/field.info.class.inc',
  'hash' => 'cf18178e119d43897d3abd882ba3acc0cf59d1ad747663437c57b1ec4d0a4322',
))
->values(array(
  'filename' => 'modules/field/field.module',
  'hash' => '48b5b83f214a8d19e446f46c5d7a1cd35faa656ccb7b540f9f02462a440cacdd',
))
->values(array(
  'filename' => 'modules/field/modules/field_sql_storage/field_sql_storage.test',
  'hash' => 'f156a1147808a486b98a52ab7f3535292ce1b903f0a4ee998b88aacedd3c7ccf',
))
->values(array(
  'filename' => 'modules/field/modules/options/options.test',
  'hash' => '1b30956b6f46840ccb41b99bda08f328172f008f1fb4164c65fe9e4047fffa5f',
))
->values(array(
  'filename' => 'modules/field/modules/text/text.test',
  'hash' => '5c28b9da26417d2ed8a169850989c0b59f2b188a0161eb58e2b87c67994d602d',
))
->values(array(
  'filename' => 'modules/field/tests/field.test',
  'hash' => '5eaad7a933ef8ea05b958056492ce17858cd542111f0fe81dd1a5949ad8f966e',
))
->values(array(
  'filename' => 'modules/field_ui/field_ui.test',
  'hash' => 'f535e5627c969e9083a63aaf72d4ac645e30709d7b87af15c6c3b870481f283a',
))
->values(array(
  'filename' => 'modules/file/tests/file.test',
  'hash' => 'c5f7592b47329f7a3ab44f9c218eebcef639760cd78180b566551c53bcfe9473',
))
->values(array(
  'filename' => 'modules/filter/filter.test',
  'hash' => 'b8aa5e6b832422c6ad5fe963898ec9526c814614f27ecccb67107ce194997d6a',
))
->values(array(
  'filename' => 'modules/image/image.test',
  'hash' => '6e7a0cbcb58f6210127b0ac7c1d118d488abd0925fe8db10a3405af87f1d9fe1',
))
->values(array(
  'filename' => 'modules/node/node.module',
  'hash' => '45a35bda7eea00f6636c85cef8aea3ced2a181ff6d6841f71603e286607f12a5',
))
->values(array(
  'filename' => 'modules/node/node.test',
  'hash' => '35bf40fde62f3a1de95bab9f037b84f20c2f93a1c579d7d19e4a87afe75dc330',
))
->values(array(
  'filename' => 'modules/system/system.archiver.inc',
  'hash' => '05caceec7b3baecfebd053959c513f134a5ae4070749339495274a81bebb904a',
))
->values(array(
  'filename' => 'modules/system/system.mail.inc',
  'hash' => 'd2f4fca46269981db5edb6316176b7b8161de59d4c24c514b63fe3c536ebb4d6',
))
->values(array(
  'filename' => 'modules/system/system.queue.inc',
  'hash' => 'a77a5913d84368092805ac551ca63737c1d829455504fcccb95baa2932f28009',
))
->values(array(
  'filename' => 'modules/system/system.tar.inc',
  'hash' => 'aa4a44368064cfa08034bf35438c86282492d09fbd6a4bf02fa5da3d66c7c52e',
))
->values(array(
  'filename' => 'modules/system/system.test',
  'hash' => '6315d4c3306d99f6143a3b59b6556d15d4b60dfc28239a91ee1b0c0c48828704',
))
->values(array(
  'filename' => 'modules/system/system.updater.inc',
  'hash' => '9433fa8d39500b8c59ab05f41c0aac83b2586a43be4aa949821380e36c4d3c48',
))
->values(array(
  'filename' => 'modules/user/user.module',
  'hash' => '615a2e5a894a9aa4c206834f3e1592ea21b2be7399906504f14c6eaf801200eb',
))
->values(array(
  'filename' => 'modules/user/user.test',
  'hash' => 'f6546eef5f9e272abd7f1287d9013441dd65c45b7045f87381884c7509285b76',
))
->values(array(
  'filename' => 'sites/all/modules/bean/bean.test',
  'hash' => 'a9e4a3181284e8fde14ea84d3d43457db1b88fc3224f593cc80fc261e6991bad',
))
->values(array(
  'filename' => 'sites/all/modules/bean/bean_admin_ui/bean_admin_ui.module',
  'hash' => '00dcdb1b8dad36d2f01be0133f6cfc05058f44c80b14b7cc9ebead32276631db',
))
->values(array(
  'filename' => 'sites/all/modules/bean/bean_admin_ui/plugins/BeanCustom.class.php',
  'hash' => '88d197383ee6b796bedd193d9c0bf60cf0434eb038936cabb53b93586b856b11',
))
->values(array(
  'filename' => 'sites/all/modules/bean/includes/bean.core.inc',
  'hash' => '4c8e26524635bbe37b7023a28e3c15e1184d96a597298ea837647db7d599ac1a',
))
->values(array(
  'filename' => 'sites/all/modules/bean/includes/bean.info.inc',
  'hash' => 'a42eaa64065f453d710efc7158cba691e206fd8c4109a38c9a8ac6c171db7016',
))
->values(array(
  'filename' => 'sites/all/modules/bean/includes/bean.inline_entity_form.inc',
  'hash' => 'ac30e293a60f6253f9572d2aa58cb8738b4d592c47b80159c16e6a2caee4cb86',
))
->values(array(
  'filename' => 'sites/all/modules/bean/includes/translation.handler.bean.inc',
  'hash' => '511b7fb84c934527ad4ecd8c51121ec60fa95f3ce57dc0447a3d59b338b1de41',
))
->values(array(
  'filename' => 'sites/all/modules/bean/plugins/BeanDefault.class.php',
  'hash' => '8d1806968fd6cf5458de179115b5707aede67480a10d6e510bbf0b7a9fa9976b',
))
->values(array(
  'filename' => 'sites/all/modules/bean/plugins/BeanPlugin.class.php',
  'hash' => '6ce3a322d204a39874a9110e4abb4d830394cfd08e9a2880d71c2dc387506484',
))
->values(array(
  'filename' => 'sites/all/modules/bean/views/views_handler_field_bean_delete_link.inc',
  'hash' => '88dc2137059157c3be780594c6e517927176609bb4e7409837b2ba7ae382fb4a',
))
->values(array(
  'filename' => 'sites/all/modules/bean/views/views_handler_field_bean_edit_link.inc',
  'hash' => '868ef7a7053cf5cbdcbf365798dd646b0e9909b99b479d9f1bb677d99333e1f1',
))
->values(array(
  'filename' => 'sites/all/modules/bean/views/views_handler_field_bean_operations.inc',
  'hash' => 'd8101316aff08a185611f4128ea46a00fa8cd94867ec18c3775ecf57f1b1feec',
))
->values(array(
  'filename' => 'sites/all/modules/bean/views/views_handler_field_bean_type.inc',
  'hash' => 'a99634103fa22d9a1b13da43c72fbbe35f5963432fa7096d847843d262c38bfe',
))
->values(array(
  'filename' => 'sites/all/modules/bean/views/views_handler_filter_bean_type.inc',
  'hash' => '4da64b68eff8dced69f2032d57e68970c385b0a5bace3bcff617c0464ecf52e6',
))
->values(array(
  'filename' => 'sites/all/modules/blockreference/MigrateBlockReferenceFieldHandler.inc',
  'hash' => '24ca1c21f8704ad0fec8a508307453e5c6da67d689bdfbe56a128416a2b67b1b',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/includes/context.inc',
  'hash' => '2057a0331cf54e23ef39aa84b7c60f486aff749223367a30f3513b05dde35f3d',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/includes/css-cache.inc',
  'hash' => 'db90ff67669d9fa445e91074ac67fb97cdb191a19e68d42744f0fd4158649cfa',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/includes/math-expr.inc',
  'hash' => '0573737d85980dedf76cc9c82fbc2654ed07fce8ff7a8da4be2e2cd7de67b99f',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/includes/stylizer.inc',
  'hash' => 'a19b912a79e6d982a6bfbb660c108a047e41283a23e1b12e4b9c22af51771add',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/plugins/export_ui/ctools_export_ui.class.php',
  'hash' => '33ca784ee967dee1234372e6075505ce57f7685b494e4fa477318579bb85ccbf',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/tests/context.test',
  'hash' => 'bc23a86c5c32a0335c970f1e51ad6d60cc02d006de3d5cb5ee0bbdaa84d5bcd3',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/tests/css.test',
  'hash' => '832c58634157083e988797bf878c5fd6b9640e187802a397763e25771eced028',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/tests/css_cache.test',
  'hash' => '331564b96148bb666b306ead748b8b18a7baf746e96d6564b9685a23ca47a888',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/tests/ctools.plugins.test',
  'hash' => '2dbabab681d5a9e15e093aef5a48732dcdb030680b932c7a0c7260e444751919',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/tests/ctools.test',
  'hash' => '427659c5c3db1e8638539b6dd1a440451e043129172a42f66f3f9bbd15e8db0b',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/tests/math_expression.test',
  'hash' => '0fa0cd1f54c9a3791a5d77220bfee16baa868d0911f0c834b9682346ba8c0df6',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/tests/math_expression_stack.test',
  'hash' => '203b98c797d7eaa787c6481c1ab9482c0ca45559314f79632d7c5efb51d7d170',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/tests/object_cache.test',
  'hash' => '0af88e1d17b8265ac621799922934dded7c44073c001acf8c1c47d0187cb52fa',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/tests/object_cache_unit.test',
  'hash' => '9fd7871c5f0307247469bcdd488f3086126f5f7978d6a470f8ecb8a6dc4b5a1e',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/tests/page_tokens.test',
  'hash' => '078f82bd0957d8821521388fa270e70e10e9f143c1012ebac60f2dfd4d9ab1a4',
))
->values(array(
  'filename' => 'sites/all/modules/entity/entity.features.inc',
  'hash' => '53f537caf6ad9355fb92b2c6db019959abdf399d80764151dd976b0891f37436',
))
->values(array(
  'filename' => 'sites/all/modules/entity/entity.i18n.inc',
  'hash' => '41e0e62af7e2774f62b162d597bb3244551c280296b692b29d039a2c243d7059',
))
->values(array(
  'filename' => 'sites/all/modules/entity/entity.info.inc',
  'hash' => '8799080b9393c9560e64feae1276fb7d26fef4d92bb0edacc863ee3e7b67bf04',
))
->values(array(
  'filename' => 'sites/all/modules/entity/entity.rules.inc',
  'hash' => '774199059d1b3ebe6d3fe7a49dbb1550df489055a3d066b5de54edda8dd7ba84',
))
->values(array(
  'filename' => 'sites/all/modules/entity/entity.test',
  'hash' => 'aba6490cd2041438d832dc8f63b213e0d171a5a218f6d51a9fe00c51e95069ce',
))
->values(array(
  'filename' => 'sites/all/modules/entity/includes/entity.controller.inc',
  'hash' => 'b85d1882fae38ee8a0e82bf75952f44f65a58fd95e3bf0c3cb2a1321cf4d308a',
))
->values(array(
  'filename' => 'sites/all/modules/entity/includes/entity.inc',
  'hash' => '02c3c8b1d4b7230f875c4fae8e6ba3bd57431e01f312b32f3ed305a7be734774',
))
->values(array(
  'filename' => 'sites/all/modules/entity/includes/entity.ui.inc',
  'hash' => '49653cbbccc4b4e51f957727aa95803c149fac9565f53ed553e2cd1c1c3580ff',
))
->values(array(
  'filename' => 'sites/all/modules/entity/includes/entity.wrapper.inc',
  'hash' => 'c728444ea73d4d5a7f0ec4cc80c7b749ab3134e1d0b973f8c001936c3dd5b861',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/entity.views.inc',
  'hash' => '089b8ed3103f62778be3395a99ddfbd84da4235f5ad431392f8984eaa4bf349f',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_field_handler_helper.inc',
  'hash' => '88e4cbbbeab9bbaa4c928118bdefb158ea99f343f813cf88cce01ed7fbf8bf6a',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_area_entity.inc',
  'hash' => '39ac643c4365394ac54190c4d130ea5787de423b9dadc14a470687a64cfbc8ab',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_boolean.inc',
  'hash' => 'b28b8eee8761ba7a6af35d97ab7aaee28406e6c227271f9769818560626c5791',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_date.inc',
  'hash' => 'b0f5be5b399de94934b24e84c8cf6053a043f6b00c60dcffa752daeafdd38778',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_duration.inc',
  'hash' => 'ed7bb64cb63b94a20c8cde98cfb053b5ea252804396cf61ac562faf1d850266b',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_entity.inc',
  'hash' => '4f255918a22fefebe9c7734f200751457a7ca4d3648e32a98511bb51968d7521',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_field.inc',
  'hash' => '893121efbce2a7181e31147bade260c9cc657cbd33b0d254cb28b2650e57566d',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_numeric.inc',
  'hash' => 'f14e2b063930e8820af381b4f5e83c7278440e7804ab88cfde865b6c94e7c0f6',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_options.inc',
  'hash' => '27ef31b8ee7b9999930380d6a5fdb477772329c4ddbd5c70cc34bcdc7543ce56',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_text.inc',
  'hash' => '5fb0a85d35d29944c699ceaf6efed5eda2df757009e44caba8ff2be397568b60',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_uri.inc',
  'hash' => '79ecaa3eb17dfdd0ca077351b75a2c0adf411ebc04720e7cc0e2397674225f24',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_relationship.inc',
  'hash' => 'b69bc538d1e1e0f91f8485ca54c3b6e2be025caa47619734c467377cf89041b9',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_relationship_by_bundle.inc',
  'hash' => '65300c793c4591d60ad908dc02cf3148fe4e899fa6ad218e875fd92d411374dc',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/plugins/entity_views_plugin_row_entity_view.inc',
  'hash' => 'e489ca209c66b76228383864b8267067e7cf3a1e375d9a195339f89932fed71f',
))
->values(array(
  'filename' => 'sites/all/modules/entity_view_mode/entity_view_mode.test',
  'hash' => '00da4cb2b51d716183588b3e249dfa34ec37281082569a55303159029df96e90',
))
->values(array(
  'filename' => 'sites/all/modules/uuid/uuid.test',
  'hash' => 'f84d7c3f7ffb502203c0abec8a9d55fd1486463a8316f557f71985d2ff1bd44c',
))
->execute();
$connection->schema()->createTable('role', array(
  'fields' => array(
    'rid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'rid',
  ),
  'unique keys' => array(
    'name' => array(
      'name',
    ),
  ),
  'indexes' => array(
    'name_weight' => array(
      'name',
      'weight',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('role')
->fields(array(
  'rid',
  'name',
  'weight',
))
->values(array(
  'rid' => '1',
  'name' => 'anonymous user',
  'weight' => '0',
))
->values(array(
  'rid' => '2',
  'name' => 'authenticated user',
  'weight' => '1',
))
->values(array(
  'rid' => '3',
  'name' => 'bean manager',
  'weight' => '2',
))
->execute();
$connection->schema()->createTable('role_permission', array(
  'fields' => array(
    'rid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'permission' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'rid',
    'permission',
  ),
  'indexes' => array(
    'permission' => array(
      'permission',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('role_permission')
->fields(array(
  'rid',
  'permission',
  'module',
))
->values(array(
  'rid' => '1',
  'permission' => 'access content',
  'module' => 'node',
))
->values(array(
  'rid' => '2',
  'permission' => 'access content',
  'module' => 'node',
))
->values(array(
  'rid' => '2',
  'permission' => 'use text format filtered_html',
  'module' => 'filter',
))
->values(array(
  'rid' => '3',
  'permission' => 'access bean overview',
  'module' => 'bean',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer bean settings',
  'module' => 'bean',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer bean types',
  'module' => 'bean',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer beans',
  'module' => 'bean',
))
->values(array(
  'rid' => '3',
  'permission' => 'edit bean view mode',
  'module' => 'bean',
))
->values(array(
  'rid' => '3',
  'permission' => 'view bean page',
  'module' => 'bean',
))
->values(array(
  'rid' => '3',
  'permission' => 'view bean revisions',
  'module' => 'bean',
))
->execute();
$connection->schema()->createTable('semaphore', array(
  'fields' => array(
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'value' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'expire' => array(
      'type' => 'float',
      'not null' => TRUE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'name',
  ),
  'indexes' => array(
    'value' => array(
      array(
        'value',
        '191',
      ),
    ),
    'expire' => array(
      'expire',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('sequences', array(
  'fields' => array(
    'value' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'value',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('sequences')
->fields(array(
  'value',
))
->values(array(
  'value' => '3',
))
->execute();
$connection->schema()->createTable('sessions', array(
  'fields' => array(
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'sid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
    ),
    'ssid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'hostname' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'cache' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'session' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'sid',
    'ssid',
  ),
  'indexes' => array(
    'timestamp' => array(
      'timestamp',
    ),
    'uid' => array(
      'uid',
    ),
    'ssid' => array(
      'ssid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('system', array(
  'fields' => array(
    'filename' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ),
    'owner' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'bootstrap' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'schema_version' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '-1',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'info' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'filename',
  ),
  'indexes' => array(
    'system_list' => array(
      'status',
      'bootstrap',
      'type',
      'weight',
      array(
        'name',
        '191',
      ),
    ),
    'type_name' => array(
      'type',
      array(
        'name',
        '191',
      ),
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('system')
->fields(array(
  'filename',
  'name',
  'type',
  'owner',
  'status',
  'bootstrap',
  'schema_version',
  'weight',
  'info',
))
->values(array(
  'filename' => 'modules/aggregator/aggregator.module',
  'name' => 'aggregator',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:10:"Aggregator";s:11:"description";s:57:"Aggregates syndicated content (RSS, RDF, and Atom feeds).";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:15:"aggregator.test";}s:9:"configure";s:41:"admin/config/services/aggregator/settings";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:14:"aggregator.css";s:33:"modules/aggregator/aggregator.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/aggregator/tests/aggregator_test.module',
  'name' => 'aggregator_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:23:"Aggregator module tests";s:11:"description";s:46:"Support module for aggregator related testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/block/block.module',
  'name' => 'block',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7009',
  'weight' => '-5',
  'info' => 'a:13:{s:4:"name";s:5:"Block";s:11:"description";s:140:"Controls the visual building blocks a page is constructed with. Blocks are boxes of content rendered into an area, or region, of a web page.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:10:"block.test";}s:9:"configure";s:21:"admin/structure/block";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/block/tests/block_test.module',
  'name' => 'block_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:10:"Block test";s:11:"description";s:21:"Provides test blocks.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/blog/blog.module',
  'name' => 'blog',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:4:"Blog";s:11:"description";s:25:"Enables multi-user blogs.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"blog.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/book/book.module',
  'name' => 'book',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:4:"Book";s:11:"description";s:66:"Allows users to create and organize related content in an outline.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"book.test";}s:9:"configure";s:27:"admin/content/book/settings";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:8:"book.css";s:21:"modules/book/book.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/color/color.module',
  'name' => 'color',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:5:"Color";s:11:"description";s:70:"Allows administrators to change the color scheme of compatible themes.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:10:"color.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/comment/comment.module',
  'name' => 'comment',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:7:"Comment";s:11:"description";s:57:"Allows users to comment on and discuss published content.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:4:"text";}s:5:"files";a:2:{i:0;s:14:"comment.module";i:1;s:12:"comment.test";}s:9:"configure";s:21:"admin/content/comment";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:11:"comment.css";s:27:"modules/comment/comment.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/contact/contact.module',
  'name' => 'contact',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:7:"Contact";s:11:"description";s:61:"Enables the use of both personal and site-wide contact forms.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:12:"contact.test";}s:9:"configure";s:23:"admin/structure/contact";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/contextual/contextual.module',
  'name' => 'contextual',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:16:"Contextual links";s:11:"description";s:75:"Provides contextual links to perform actions related to elements on a page.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:15:"contextual.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/dashboard/dashboard.module',
  'name' => 'dashboard',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:9:"Dashboard";s:11:"description";s:136:"Provides a dashboard page in the administrative interface for organizing administrative tasks and tracking information within your site.";s:4:"core";s:3:"7.x";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:5:"files";a:1:{i:0;s:14:"dashboard.test";}s:12:"dependencies";a:1:{i:0;s:5:"block";}s:9:"configure";s:25:"admin/dashboard/customize";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/dblog/dblog.module',
  'name' => 'dblog',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:16:"Database logging";s:11:"description";s:47:"Logs and records system events to the database.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:10:"dblog.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field/field.module',
  'name' => 'field',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7004',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:5:"Field";s:11:"description";s:57:"Field API to add fields to entities like nodes and users.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:5:"files";a:4:{i:0;s:12:"field.module";i:1;s:16:"field.attach.inc";i:2;s:20:"field.info.class.inc";i:3;s:16:"tests/field.test";}s:12:"dependencies";a:1:{i:0;s:17:"field_sql_storage";}s:8:"required";b:1;s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:15:"theme/field.css";s:29:"modules/field/theme/field.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field/modules/field_sql_storage/field_sql_storage.module',
  'name' => 'field_sql_storage',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7002',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:17:"Field SQL storage";s:11:"description";s:37:"Stores field data in an SQL database.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:22:"field_sql_storage.test";}s:8:"required";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field/modules/list/list.module',
  'name' => 'list',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:4:"List";s:11:"description";s:69:"Defines list field types. Use with Options to create selection lists.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:12:"dependencies";a:2:{i:0;s:5:"field";i:1;s:7:"options";}s:5:"files";a:1:{i:0;s:15:"tests/list.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field/modules/list/tests/list_test.module',
  'name' => 'list_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:9:"List test";s:11:"description";s:41:"Support module for the List module tests.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field/modules/number/number.module',
  'name' => 'number',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:6:"Number";s:11:"description";s:28:"Defines numeric field types.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:11:"number.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field/modules/options/options.module',
  'name' => 'options',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:7:"Options";s:11:"description";s:82:"Defines selection, check box and radio button widgets for text and numeric fields.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:12:"options.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field/modules/text/text.module',
  'name' => 'text',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7000',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:4:"Text";s:11:"description";s:32:"Defines simple text field types.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:9:"text.test";}s:8:"required";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;s:11:"explanation";s:73:"Field type(s) in use - see <a href="/admin/reports/fields">Field list</a>";}',
))
->values(array(
  'filename' => 'modules/field/tests/field_test.module',
  'name' => 'field_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:14:"Field API Test";s:11:"description";s:39:"Support module for the Field API tests.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:5:"files";a:1:{i:0;s:21:"field_test.entity.inc";}s:7:"version";s:4:"7.77";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field_ui/field_ui.module',
  'name' => 'field_ui',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:8:"Field UI";s:11:"description";s:33:"User interface for the Field API.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:13:"field_ui.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/file/file.module',
  'name' => 'file',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:4:"File";s:11:"description";s:26:"Defines a file field type.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:15:"tests/file.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/file/tests/file_module_test.module',
  'name' => 'file_module_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:9:"File test";s:11:"description";s:53:"Provides hooks for testing File module functionality.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/filter/filter.module',
  'name' => 'filter',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7010',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:6:"Filter";s:11:"description";s:43:"Filters content in preparation for display.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:11:"filter.test";}s:8:"required";b:1;s:9:"configure";s:28:"admin/config/content/formats";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/forum/forum.module',
  'name' => 'forum',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:5:"Forum";s:11:"description";s:27:"Provides discussion forums.";s:12:"dependencies";a:2:{i:0;s:8:"taxonomy";i:1;s:7:"comment";}s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:10:"forum.test";}s:9:"configure";s:21:"admin/structure/forum";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"forum.css";s:23:"modules/forum/forum.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/help/help.module',
  'name' => 'help',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:4:"Help";s:11:"description";s:35:"Manages the display of online help.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"help.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/image/image.module',
  'name' => 'image',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7005',
  'weight' => '0',
  'info' => 'a:15:{s:4:"name";s:5:"Image";s:11:"description";s:34:"Provides image manipulation tools.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:4:"file";}s:5:"files";a:1:{i:0;s:10:"image.test";}s:9:"configure";s:31:"admin/config/media/image-styles";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;s:8:"required";b:1;s:11:"explanation";s:73:"Field type(s) in use - see <a href="/admin/reports/fields">Field list</a>";}',
))
->values(array(
  'filename' => 'modules/image/tests/image_module_test.module',
  'name' => 'image_module_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:10:"Image test";s:11:"description";s:69:"Provides hook implementations for testing Image module functionality.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:24:"image_module_test.module";}s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/locale/locale.module',
  'name' => 'locale',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:6:"Locale";s:11:"description";s:119:"Adds language handling functionality and enables the translation of the user interface to languages other than English.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:11:"locale.test";}s:9:"configure";s:30:"admin/config/regional/language";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/locale/tests/locale_test.module',
  'name' => 'locale_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:11:"Locale Test";s:11:"description";s:42:"Support module for the locale layer tests.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/menu/menu.module',
  'name' => 'menu',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:4:"Menu";s:11:"description";s:60:"Allows administrators to customize the site navigation menu.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"menu.test";}s:9:"configure";s:20:"admin/structure/menu";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/node/node.module',
  'name' => 'node',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7016',
  'weight' => '0',
  'info' => 'a:15:{s:4:"name";s:4:"Node";s:11:"description";s:66:"Allows content to be submitted to the site and displayed on pages.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:11:"node.module";i:1;s:9:"node.test";}s:8:"required";b:1;s:9:"configure";s:21:"admin/structure/types";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:8:"node.css";s:21:"modules/node/node.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/node/tests/node_access_test.module',
  'name' => 'node_access_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:24:"Node module access tests";s:11:"description";s:43:"Support module for node permission testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/node/tests/node_test.module',
  'name' => 'node_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:17:"Node module tests";s:11:"description";s:40:"Support module for node related testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/node/tests/node_test_exception.module',
  'name' => 'node_test_exception',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:27:"Node module exception tests";s:11:"description";s:50:"Support module for node related exception testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/openid/openid.module',
  'name' => 'openid',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:6:"OpenID";s:11:"description";s:48:"Allows users to log into your site using OpenID.";s:7:"version";s:4:"7.77";s:7:"package";s:4:"Core";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:11:"openid.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/openid/tests/openid_test.module',
  'name' => 'openid_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:21:"OpenID dummy provider";s:11:"description";s:33:"OpenID provider used for testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:6:"openid";}s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/overlay/overlay.module',
  'name' => 'overlay',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:7:"Overlay";s:11:"description";s:59:"Displays the Drupal administration interface in an overlay.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/path/path.module',
  'name' => 'path',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:4:"Path";s:11:"description";s:28:"Allows users to rename URLs.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"path.test";}s:9:"configure";s:24:"admin/config/search/path";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/php/php.module',
  'name' => 'php',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:10:"PHP filter";s:11:"description";s:50:"Allows embedded PHP code/snippets to be evaluated.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:8:"php.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/poll/poll.module',
  'name' => 'poll',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:4:"Poll";s:11:"description";s:95:"Allows your site to capture votes on different topics in the form of multiple choice questions.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"poll.test";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:8:"poll.css";s:21:"modules/poll/poll.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/profile/profile.module',
  'name' => 'profile',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:7:"Profile";s:11:"description";s:36:"Supports configurable user profiles.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:12:"profile.test";}s:9:"configure";s:27:"admin/config/people/profile";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/rdf/rdf.module',
  'name' => 'rdf',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:3:"RDF";s:11:"description";s:148:"Enriches your content with metadata to let other applications (e.g. search engines, aggregators) better understand its relationships and attributes.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:8:"rdf.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/rdf/tests/rdf_test.module',
  'name' => 'rdf_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:16:"RDF module tests";s:11:"description";s:38:"Support module for RDF module testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:4:"blog";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/search/search.module',
  'name' => 'search',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:6:"Search";s:11:"description";s:36:"Enables site-wide keyword searching.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:19:"search.extender.inc";i:1;s:11:"search.test";}s:9:"configure";s:28:"admin/config/search/settings";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:10:"search.css";s:25:"modules/search/search.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/search/tests/search_embedded_form.module',
  'name' => 'search_embedded_form',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:20:"Search embedded form";s:11:"description";s:59:"Support module for search module testing of embedded forms.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/search/tests/search_extra_type.module',
  'name' => 'search_extra_type',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:16:"Test search type";s:11:"description";s:41:"Support module for search module testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/search/tests/search_node_tags.module',
  'name' => 'search_node_tags',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:21:"Test search node tags";s:11:"description";s:44:"Support module for Node search tags testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/shortcut/shortcut.module',
  'name' => 'shortcut',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:8:"Shortcut";s:11:"description";s:60:"Allows users to manage customizable lists of shortcut links.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:13:"shortcut.test";}s:9:"configure";s:36:"admin/config/user-interface/shortcut";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/simpletest.module',
  'name' => 'simpletest',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:7:"Testing";s:11:"description";s:53:"Provides a framework for unit and functional testing.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:5:"files";a:51:{i:0;s:15:"simpletest.test";i:1;s:24:"drupal_web_test_case.php";i:2;s:18:"tests/actions.test";i:3;s:15:"tests/ajax.test";i:4;s:16:"tests/batch.test";i:5;s:15:"tests/boot.test";i:6;s:20:"tests/bootstrap.test";i:7;s:16:"tests/cache.test";i:8;s:17:"tests/common.test";i:9;s:24:"tests/database_test.test";i:10;s:22:"tests/entity_crud.test";i:11;s:32:"tests/entity_crud_hook_test.test";i:12;s:23:"tests/entity_query.test";i:13;s:16:"tests/error.test";i:14;s:15:"tests/file.test";i:15;s:23:"tests/filetransfer.test";i:16;s:15:"tests/form.test";i:17;s:16:"tests/graph.test";i:18;s:16:"tests/image.test";i:19;s:15:"tests/lock.test";i:20;s:15:"tests/mail.test";i:21;s:15:"tests/menu.test";i:22;s:17:"tests/module.test";i:23;s:16:"tests/pager.test";i:24;s:19:"tests/password.test";i:25;s:15:"tests/path.test";i:26;s:19:"tests/registry.test";i:27;s:28:"tests/request_sanitizer.test";i:28;s:17:"tests/schema.test";i:29;s:18:"tests/session.test";i:30;s:20:"tests/tablesort.test";i:31;s:16:"tests/theme.test";i:32;s:18:"tests/unicode.test";i:33;s:17:"tests/update.test";i:34;s:17:"tests/xmlrpc.test";i:35;s:26:"tests/upgrade/upgrade.test";i:36;s:34:"tests/upgrade/upgrade.comment.test";i:37;s:33:"tests/upgrade/upgrade.filter.test";i:38;s:32:"tests/upgrade/upgrade.forum.test";i:39;s:33:"tests/upgrade/upgrade.locale.test";i:40;s:31:"tests/upgrade/upgrade.menu.test";i:41;s:31:"tests/upgrade/upgrade.node.test";i:42;s:35:"tests/upgrade/upgrade.taxonomy.test";i:43;s:34:"tests/upgrade/upgrade.trigger.test";i:44;s:39:"tests/upgrade/upgrade.translatable.test";i:45;s:33:"tests/upgrade/upgrade.upload.test";i:46;s:31:"tests/upgrade/upgrade.user.test";i:47;s:36:"tests/upgrade/update.aggregator.test";i:48;s:33:"tests/upgrade/update.trigger.test";i:49;s:31:"tests/upgrade/update.field.test";i:50;s:30:"tests/upgrade/update.user.test";}s:9:"configure";s:41:"admin/config/development/testing/settings";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/actions_loop_test.module',
  'name' => 'actions_loop_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:17:"Actions loop test";s:11:"description";s:39:"Support module for action loop testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/ajax_forms_test.module',
  'name' => 'ajax_forms_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:26:"AJAX form test mock module";s:11:"description";s:25:"Test for AJAX form calls.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/ajax_test.module',
  'name' => 'ajax_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:9:"AJAX Test";s:11:"description";s:40:"Support module for AJAX framework tests.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/batch_test.module',
  'name' => 'batch_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:14:"Batch API test";s:11:"description";s:35:"Support module for Batch API tests.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/boot_test_1.module',
  'name' => 'boot_test_1',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:21:"Early bootstrap tests";s:11:"description";s:39:"A support module for hook_boot testing.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/boot_test_2.module',
  'name' => 'boot_test_2',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:21:"Early bootstrap tests";s:11:"description";s:44:"A support module for hook_boot hook testing.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/common_test.module',
  'name' => 'common_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:11:"Common Test";s:11:"description";s:32:"Support module for Common tests.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:15:"common_test.css";s:40:"modules/simpletest/tests/common_test.css";}s:5:"print";a:1:{s:21:"common_test.print.css";s:46:"modules/simpletest/tests/common_test.print.css";}}s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/common_test_cron_helper.module',
  'name' => 'common_test_cron_helper',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:23:"Common Test Cron Helper";s:11:"description";s:56:"Helper module for CronRunTestCase::testCronExceptions().";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/database_test.module',
  'name' => 'database_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:13:"Database Test";s:11:"description";s:40:"Support module for Database layer tests.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/drupal_autoload_test/drupal_autoload_test.module',
  'name' => 'drupal_autoload_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:25:"Drupal code registry test";s:11:"description";s:45:"Support module for testing the code registry.";s:5:"files";a:2:{i:0;s:34:"drupal_autoload_test_interface.inc";i:1;s:30:"drupal_autoload_test_class.inc";}s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/drupal_system_listing_compatible_test/drupal_system_listing_compatible_test.module',
  'name' => 'drupal_system_listing_compatible_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:37:"Drupal system listing compatible test";s:11:"description";s:62:"Support module for testing the drupal_system_listing function.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/drupal_system_listing_incompatible_test/drupal_system_listing_incompatible_test.module',
  'name' => 'drupal_system_listing_incompatible_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:39:"Drupal system listing incompatible test";s:11:"description";s:62:"Support module for testing the drupal_system_listing function.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/entity_cache_test.module',
  'name' => 'entity_cache_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:17:"Entity cache test";s:11:"description";s:40:"Support module for testing entity cache.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:28:"entity_cache_test_dependency";}s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/entity_cache_test_dependency.module',
  'name' => 'entity_cache_test_dependency',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:28:"Entity cache test dependency";s:11:"description";s:51:"Support dependency module for testing entity cache.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/entity_crud_hook_test.module',
  'name' => 'entity_crud_hook_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:22:"Entity CRUD Hooks Test";s:11:"description";s:35:"Support module for CRUD hook tests.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/entity_query_access_test.module',
  'name' => 'entity_query_access_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:24:"Entity query access test";s:11:"description";s:49:"Support module for checking entity query results.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/error_test.module',
  'name' => 'error_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:10:"Error test";s:11:"description";s:47:"Support module for error and exception testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/file_test.module',
  'name' => 'file_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:9:"File test";s:11:"description";s:39:"Support module for file handling tests.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:16:"file_test.module";}s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/filter_test.module',
  'name' => 'filter_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:18:"Filter test module";s:11:"description";s:33:"Tests filter hooks and functions.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/form_test.module',
  'name' => 'form_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:12:"FormAPI Test";s:11:"description";s:34:"Support module for Form API tests.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/image_test.module',
  'name' => 'image_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:10:"Image test";s:11:"description";s:39:"Support module for image toolkit tests.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/menu_test.module',
  'name' => 'menu_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:15:"Hook menu tests";s:11:"description";s:37:"Support module for menu hook testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/module_test.module',
  'name' => 'module_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:11:"Module test";s:11:"description";s:41:"Support module for module system testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/path_test.module',
  'name' => 'path_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:15:"Hook path tests";s:11:"description";s:37:"Support module for path hook testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/psr_0_test/psr_0_test.module',
  'name' => 'psr_0_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:16:"PSR-0 Test cases";s:11:"description";s:44:"Test classes to be discovered by simpletest.";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/psr_4_test/psr_4_test.module',
  'name' => 'psr_4_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:16:"PSR-4 Test cases";s:11:"description";s:44:"Test classes to be discovered by simpletest.";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/requirements1_test.module',
  'name' => 'requirements1_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => "a:13:{s:4:\"name\";s:19:\"Requirements 1 Test\";s:11:\"description\";s:80:\"Tests that a module is not installed when it fails hook_requirements('install').\";s:7:\"package\";s:7:\"Testing\";s:7:\"version\";s:4:\"7.77\";s:4:\"core\";s:3:\"7.x\";s:6:\"hidden\";b:1;s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1607003447\";s:5:\"mtime\";i:1607003447;s:12:\"dependencies\";a:0:{}s:3:\"php\";s:5:\"5.2.4\";s:5:\"files\";a:0:{}s:9:\"bootstrap\";i:0;}",
))
->values(array(
  'filename' => 'modules/simpletest/tests/requirements2_test.module',
  'name' => 'requirements2_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => "a:13:{s:4:\"name\";s:19:\"Requirements 2 Test\";s:11:\"description\";s:98:\"Tests that a module is not installed when the one it depends on fails hook_requirements('install).\";s:12:\"dependencies\";a:2:{i:0;s:18:\"requirements1_test\";i:1;s:7:\"comment\";}s:7:\"package\";s:7:\"Testing\";s:7:\"version\";s:4:\"7.77\";s:4:\"core\";s:3:\"7.x\";s:6:\"hidden\";b:1;s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1607003447\";s:5:\"mtime\";i:1607003447;s:3:\"php\";s:5:\"5.2.4\";s:5:\"files\";a:0:{}s:9:\"bootstrap\";i:0;}",
))
->values(array(
  'filename' => 'modules/simpletest/tests/session_test.module',
  'name' => 'session_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:12:"Session test";s:11:"description";s:40:"Support module for session data testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_dependencies_test.module',
  'name' => 'system_dependencies_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:22:"System dependency test";s:11:"description";s:47:"Support module for testing system dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:19:"_missing_dependency";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_incompatible_core_version_dependencies_test.module',
  'name' => 'system_incompatible_core_version_dependencies_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:50:"System incompatible core version dependencies test";s:11:"description";s:47:"Support module for testing system dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:37:"system_incompatible_core_version_test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_incompatible_core_version_test.module',
  'name' => 'system_incompatible_core_version_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:37:"System incompatible core version test";s:11:"description";s:47:"Support module for testing system dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"5.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_incompatible_module_version_dependencies_test.module',
  'name' => 'system_incompatible_module_version_dependencies_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:52:"System incompatible module version dependencies test";s:11:"description";s:47:"Support module for testing system dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:46:"system_incompatible_module_version_test (>2.0)";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_incompatible_module_version_test.module',
  'name' => 'system_incompatible_module_version_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:39:"System incompatible module version test";s:11:"description";s:47:"Support module for testing system dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_project_namespace_test.module',
  'name' => 'system_project_namespace_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:29:"System project namespace test";s:11:"description";s:58:"Support module for testing project namespace dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:13:"drupal:filter";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_test.module',
  'name' => 'system_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:11:"System test";s:11:"description";s:34:"Support module for system testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:18:"system_test.module";}s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/taxonomy_test.module',
  'name' => 'taxonomy_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:20:"Taxonomy test module";s:11:"description";s:45:""Tests functions and hooks not used in core".";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:8:"taxonomy";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/theme_test.module',
  'name' => 'theme_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:10:"Theme test";s:11:"description";s:40:"Support module for theme system testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/update_script_test.module',
  'name' => 'update_script_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:18:"Update script test";s:11:"description";s:41:"Support module for update script testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/update_test_1.module',
  'name' => 'update_test_1',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:11:"Update test";s:11:"description";s:34:"Support module for update testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/update_test_2.module',
  'name' => 'update_test_2',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:11:"Update test";s:11:"description";s:34:"Support module for update testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/update_test_3.module',
  'name' => 'update_test_3',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:11:"Update test";s:11:"description";s:34:"Support module for update testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/url_alter_test.module',
  'name' => 'url_alter_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:15:"Url_alter tests";s:11:"description";s:45:"A support modules for url_alter hook testing.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/xmlrpc_test.module',
  'name' => 'xmlrpc_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:12:"XML-RPC Test";s:11:"description";s:75:"Support module for XML-RPC tests according to the validator1 specification.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/statistics/statistics.module',
  'name' => 'statistics',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:10:"Statistics";s:11:"description";s:37:"Logs access statistics for your site.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:15:"statistics.test";}s:9:"configure";s:30:"admin/config/system/statistics";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/syslog/syslog.module',
  'name' => 'syslog',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:6:"Syslog";s:11:"description";s:41:"Logs and records system events to syslog.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:11:"syslog.test";}s:9:"configure";s:32:"admin/config/development/logging";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/system/system.module',
  'name' => 'system',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '1',
  'schema_version' => '7084',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:6:"System";s:11:"description";s:54:"Handles general site configuration for administrators.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:5:"files";a:6:{i:0;s:19:"system.archiver.inc";i:1;s:15:"system.mail.inc";i:2;s:16:"system.queue.inc";i:3;s:14:"system.tar.inc";i:4;s:18:"system.updater.inc";i:5;s:11:"system.test";}s:8:"required";b:1;s:9:"configure";s:19:"admin/config/system";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/system/tests/cron_queue_test.module',
  'name' => 'cron_queue_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:15:"Cron Queue test";s:11:"description";s:41:"Support module for the cron queue runner.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/system/tests/system_cron_test.module',
  'name' => 'system_cron_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:16:"System Cron Test";s:11:"description";s:45:"Support module for testing the system_cron().";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/taxonomy/taxonomy.module',
  'name' => 'taxonomy',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:8:"Taxonomy";s:11:"description";s:38:"Enables the categorization of content.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:7:"options";}s:5:"files";a:2:{i:0;s:15:"taxonomy.module";i:1;s:13:"taxonomy.test";}s:9:"configure";s:24:"admin/structure/taxonomy";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/toolbar/toolbar.module',
  'name' => 'toolbar',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:7:"Toolbar";s:11:"description";s:99:"Provides a toolbar that shows the top-level administration menu items and links from other modules.";s:4:"core";s:3:"7.x";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/tracker/tracker.module',
  'name' => 'tracker',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:7:"Tracker";s:11:"description";s:45:"Enables tracking of recent content for users.";s:12:"dependencies";a:1:{i:0;s:7:"comment";}s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:12:"tracker.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/translation/tests/translation_test.module',
  'name' => 'translation_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:24:"Content Translation Test";s:11:"description";s:49:"Support module for the content translation tests.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/translation/translation.module',
  'name' => 'translation',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:19:"Content translation";s:11:"description";s:57:"Allows content to be translated into different languages.";s:12:"dependencies";a:1:{i:0;s:6:"locale";}s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:16:"translation.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/trigger/tests/trigger_test.module',
  'name' => 'trigger_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:12:"Trigger Test";s:11:"description";s:33:"Support module for Trigger tests.";s:7:"package";s:7:"Testing";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"version";s:4:"7.77";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/trigger/trigger.module',
  'name' => 'trigger',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:7:"Trigger";s:11:"description";s:90:"Enables actions to be fired on certain system events, such as when new content is created.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:12:"trigger.test";}s:9:"configure";s:23:"admin/structure/trigger";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/update/tests/aaa_update_test.module',
  'name' => 'aaa_update_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:15:"AAA Update test";s:11:"description";s:41:"Support module for update module testing.";s:7:"package";s:7:"Testing";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"version";s:4:"7.77";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/update/tests/bbb_update_test.module',
  'name' => 'bbb_update_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:15:"BBB Update test";s:11:"description";s:41:"Support module for update module testing.";s:7:"package";s:7:"Testing";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"version";s:4:"7.77";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/update/tests/ccc_update_test.module',
  'name' => 'ccc_update_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:15:"CCC Update test";s:11:"description";s:41:"Support module for update module testing.";s:7:"package";s:7:"Testing";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"version";s:4:"7.77";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/update/tests/update_test.module',
  'name' => 'update_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:11:"Update test";s:11:"description";s:41:"Support module for update module testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/update/update.module',
  'name' => 'update',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:14:"Update manager";s:11:"description";s:104:"Checks for available updates, and can securely install or update modules and themes via a web interface.";s:7:"version";s:4:"7.77";s:7:"package";s:4:"Core";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:11:"update.test";}s:9:"configure";s:30:"admin/reports/updates/settings";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/user/tests/user_flood_test.module',
  'name' => 'user_flood_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:31:"User module flood control tests";s:11:"description";s:46:"Support module for user flood control testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/user/tests/user_form_test.module',
  'name' => 'user_form_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:22:"User module form tests";s:11:"description";s:37:"Support module for user form testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/user/tests/user_session_test.module',
  'name' => 'user_session_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:25:"User module session tests";s:11:"description";s:40:"Support module for user session testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/user/user.module',
  'name' => 'user',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7019',
  'weight' => '0',
  'info' => 'a:15:{s:4:"name";s:4:"User";s:11:"description";s:47:"Manages the user registration and login system.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:11:"user.module";i:1;s:9:"user.test";}s:8:"required";b:1;s:9:"configure";s:19:"admin/config/people";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:8:"user.css";s:21:"modules/user/user.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'profiles/minimal/minimal.profile',
  'name' => 'minimal',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '1000',
  'info' => 'a:15:{s:4:"name";s:7:"Minimal";s:11:"description";s:38:"Start with only a few modules enabled.";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:12:"dependencies";a:2:{i:0;s:5:"block";i:1;s:5:"dblog";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:5:"mtime";i:1607003447;s:7:"package";s:5:"Other";s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;s:6:"hidden";b:1;s:8:"required";b:1;s:17:"distribution_name";s:6:"Drupal";}',
))
->values(array(
  'filename' => 'sites/all/modules/bean/bean.module',
  'name' => 'bean',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7013',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:4:"Bean";s:11:"description";s:28:"Create Bean (Block Entities)";s:4:"core";s:3:"7.x";s:5:"files";a:12:{i:0;s:22:"includes/bean.core.inc";i:1;s:22:"includes/bean.info.inc";i:2;s:28:"plugins/BeanPlugin.class.php";i:3;s:29:"plugins/BeanDefault.class.php";i:4;s:37:"includes/translation.handler.bean.inc";i:5;s:36:"includes/bean.inline_entity_form.inc";i:6;s:40:"views/views_handler_filter_bean_type.inc";i:7;s:39:"views/views_handler_field_bean_type.inc";i:8;s:44:"views/views_handler_field_bean_edit_link.inc";i:9;s:46:"views/views_handler_field_bean_delete_link.inc";i:10;s:45:"views/views_handler_field_bean_operations.inc";i:11;s:9:"bean.test";}s:12:"dependencies";a:2:{i:0;s:6:"entity";i:1;s:6:"ctools";}s:7:"package";s:4:"Bean";s:7:"version";s:8:"7.x-1.11";s:7:"project";s:4:"bean";s:9:"datestamp";s:10:"1470638340";s:5:"mtime";i:1470638340;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/bean/bean_admin_ui/bean_admin_ui.module',
  'name' => 'bean_admin_ui',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7003',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:13:"Bean Admin UI";s:11:"description";s:47:"Add the ability to create Block Types in the UI";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:20:"bean_admin_ui.module";i:1;s:28:"plugins/BeanCustom.class.php";}s:12:"dependencies";a:1:{i:0;s:4:"bean";}s:9:"configure";s:27:"admin/structure/block-types";s:7:"package";s:4:"Bean";s:7:"version";s:8:"7.x-1.11";s:7:"project";s:4:"bean";s:9:"datestamp";s:10:"1470638340";s:5:"mtime";i:1470638340;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/bean/bean_entitycache/bean_entitycache.module',
  'name' => 'bean_entitycache',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:18:"Bean - Entitycache";s:11:"description";s:54:"Integrates the Bean module with the Entitycache module";s:4:"core";s:3:"7.x";s:7:"package";s:27:"Performance and scalability";s:5:"files";a:1:{i:0;s:34:"includes/bean_entitycache.core.inc";}s:12:"dependencies";a:2:{i:0;s:4:"bean";i:1;s:11:"entitycache";}s:7:"version";s:8:"7.x-1.11";s:7:"project";s:4:"bean";s:9:"datestamp";s:10:"1470638340";s:5:"mtime";i:1470638340;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/bean/bean_usage/bean_usage.module',
  'name' => 'bean_usage',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:10:"Bean Usage";s:11:"description";s:32:"View Bean (Block Entities) Usage";s:4:"core";s:3:"7.x";s:12:"dependencies";a:2:{i:0;s:4:"bean";i:1;s:14:"blockreference";}s:7:"package";s:4:"Bean";s:7:"version";s:8:"7.x-1.11";s:7:"project";s:4:"bean";s:9:"datestamp";s:10:"1470638340";s:5:"mtime";i:1470638340;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/bean/bean_uuid/bean_uuid.module',
  'name' => 'bean_uuid',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7201',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:9:"Bean UUID";s:11:"description";s:60:"Allow deploying bean blocks through Deploy and UUID modules.";s:4:"core";s:3:"7.x";s:12:"dependencies";a:2:{i:0;s:4:"bean";i:1;s:4:"uuid";}s:7:"package";s:4:"Bean";s:7:"version";s:8:"7.x-1.11";s:7:"project";s:4:"bean";s:9:"datestamp";s:10:"1470638340";s:5:"mtime";i:1470638340;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/bean/tests/bean_test.module',
  'name' => 'bean_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:9:"Bean Test";s:11:"description";s:29:"Creates test plugins for bean";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:4:"bean";}s:5:"files";a:1:{i:0;s:16:"bean_test.module";}s:6:"hidden";b:1;s:7:"version";s:8:"7.x-1.11";s:7:"project";s:4:"bean";s:9:"datestamp";s:10:"1470638340";s:5:"mtime";i:1470638340;s:7:"package";s:5:"Other";s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/blockreference/blockreference.module',
  'name' => 'blockreference',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7200',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:15:"Block reference";s:11:"description";s:57:"Defines a field type for referencing a block from a node.";s:7:"package";s:6:"Fields";s:4:"core";s:3:"7.x";s:12:"dependencies";a:4:{i:0;s:5:"field";i:1;s:7:"options";i:2;s:5:"block";i:3;s:6:"entity";}s:5:"files";a:1:{i:0;s:37:"MigrateBlockReferenceFieldHandler.inc";}s:7:"version";s:7:"7.x-2.7";s:7:"project";s:14:"blockreference";s:9:"datestamp";s:10:"1518674589";s:5:"mtime";i:1518674589;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;s:8:"required";b:1;s:11:"explanation";s:73:"Field type(s) in use - see <a href="/admin/reports/fields">Field list</a>";}',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/bulk_export/bulk_export.module',
  'name' => 'bulk_export',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:11:"Bulk Export";s:11:"description";s:67:"Performs bulk exporting of data objects known about by Chaos tools.";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:6:"ctools";}s:7:"package";s:16:"Chaos tool suite";s:7:"version";s:8:"7.x-1.17";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1603490551";s:5:"mtime";i:1603490551;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/ctools.module',
  'name' => 'ctools',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7003',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:11:"Chaos tools";s:11:"description";s:46:"A library of helpful tools by Merlin of Chaos.";s:4:"core";s:3:"7.x";s:7:"package";s:16:"Chaos tool suite";s:5:"files";a:14:{i:0;s:20:"includes/context.inc";i:1;s:22:"includes/css-cache.inc";i:2;s:22:"includes/math-expr.inc";i:3;s:21:"includes/stylizer.inc";i:4;s:18:"tests/context.test";i:5;s:14:"tests/css.test";i:6;s:20:"tests/css_cache.test";i:7;s:25:"tests/ctools.plugins.test";i:8;s:17:"tests/ctools.test";i:9;s:26:"tests/math_expression.test";i:10;s:32:"tests/math_expression_stack.test";i:11;s:23:"tests/object_cache.test";i:12;s:28:"tests/object_cache_unit.test";i:13;s:22:"tests/page_tokens.test";}s:7:"version";s:8:"7.x-1.17";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1603490551";s:5:"mtime";i:1603490551;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/ctools_access_ruleset/ctools_access_ruleset.module',
  'name' => 'ctools_access_ruleset',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:15:"Custom rulesets";s:11:"description";s:81:"Create custom, exportable, reusable access rulesets for applications like Panels.";s:4:"core";s:3:"7.x";s:7:"package";s:16:"Chaos tool suite";s:12:"dependencies";a:1:{i:0;s:6:"ctools";}s:7:"version";s:8:"7.x-1.17";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1603490551";s:5:"mtime";i:1603490551;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/ctools_ajax_sample/ctools_ajax_sample.module',
  'name' => 'ctools_ajax_sample',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:33:"Chaos Tools (CTools) AJAX Example";s:11:"description";s:41:"Shows how to use the power of Chaos AJAX.";s:7:"package";s:16:"Chaos tool suite";s:12:"dependencies";a:1:{i:0;s:6:"ctools";}s:4:"core";s:3:"7.x";s:7:"version";s:8:"7.x-1.17";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1603490551";s:5:"mtime";i:1603490551;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/ctools_custom_content/ctools_custom_content.module',
  'name' => 'ctools_custom_content',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:20:"Custom content panes";s:11:"description";s:79:"Create custom, exportable, reusable content panes for applications like Panels.";s:4:"core";s:3:"7.x";s:7:"package";s:16:"Chaos tool suite";s:12:"dependencies";a:1:{i:0;s:6:"ctools";}s:7:"version";s:8:"7.x-1.17";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1603490551";s:5:"mtime";i:1603490551;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/ctools_plugin_example/ctools_plugin_example.module',
  'name' => 'ctools_plugin_example',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:35:"Chaos Tools (CTools) Plugin Example";s:11:"description";s:75:"Shows how an external module can provide ctools plugins (for Panels, etc.).";s:7:"package";s:16:"Chaos tool suite";s:12:"dependencies";a:4:{i:0;s:6:"ctools";i:1;s:6:"panels";i:2;s:12:"page_manager";i:3;s:13:"advanced_help";}s:4:"core";s:3:"7.x";s:7:"version";s:8:"7.x-1.17";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1603490551";s:5:"mtime";i:1603490551;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/page_manager/page_manager.module',
  'name' => 'page_manager',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:12:"Page manager";s:11:"description";s:54:"Provides a UI and API to manage pages within the site.";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:6:"ctools";}s:7:"package";s:16:"Chaos tool suite";s:5:"files";a:1:{i:0;s:21:"tests/head_links.test";}s:7:"version";s:8:"7.x-1.17";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1603490551";s:5:"mtime";i:1603490551;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/stylizer/stylizer.module',
  'name' => 'stylizer',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:8:"Stylizer";s:11:"description";s:53:"Create custom styles for applications such as Panels.";s:4:"core";s:3:"7.x";s:7:"package";s:16:"Chaos tool suite";s:12:"dependencies";a:2:{i:0;s:6:"ctools";i:1;s:5:"color";}s:7:"version";s:8:"7.x-1.17";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1603490551";s:5:"mtime";i:1603490551;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/term_depth/term_depth.module',
  'name' => 'term_depth',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:17:"Term Depth access";s:11:"description";s:48:"Controls access to context based upon term depth";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:6:"ctools";}s:7:"package";s:16:"Chaos tool suite";s:7:"version";s:8:"7.x-1.17";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1603490551";s:5:"mtime";i:1603490551;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/tests/ctools_export_test/ctools_export_test.module',
  'name' => 'ctools_export_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:18:"CTools export test";s:11:"description";s:25:"CTools export test module";s:4:"core";s:3:"7.x";s:7:"package";s:16:"Chaos tool suite";s:12:"dependencies";a:1:{i:0;s:6:"ctools";}s:6:"hidden";b:1;s:5:"files";a:1:{i:0;s:18:"ctools_export.test";}s:7:"version";s:8:"7.x-1.17";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1603490551";s:5:"mtime";i:1603490551;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/tests/ctools_plugin_test.module',
  'name' => 'ctools_plugin_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:24:"Chaos tools plugins test";s:11:"description";s:42:"Provides hooks for testing ctools plugins.";s:7:"package";s:16:"Chaos tool suite";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:6:"ctools";}s:6:"hidden";b:1;s:7:"version";s:8:"7.x-1.17";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1603490551";s:5:"mtime";i:1603490551;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/views_content/views_content.module',
  'name' => 'views_content',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:19:"Views content panes";s:11:"description";s:104:"Allows Views content to be used in Panels, Dashboard and other modules which use the CTools Content API.";s:7:"package";s:16:"Chaos tool suite";s:12:"dependencies";a:2:{i:0;s:6:"ctools";i:1;s:5:"views";}s:4:"core";s:3:"7.x";s:5:"files";a:3:{i:0;s:61:"plugins/views/views_content_plugin_display_ctools_context.inc";i:1;s:57:"plugins/views/views_content_plugin_display_panel_pane.inc";i:2;s:59:"plugins/views/views_content_plugin_style_ctools_context.inc";}s:7:"version";s:8:"7.x-1.17";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1603490551";s:5:"mtime";i:1603490551;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/entity/entity.module',
  'name' => 'entity',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7003',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:10:"Entity API";s:11:"description";s:69:"Enables modules to work with any entity type and to provide entities.";s:4:"core";s:3:"7.x";s:5:"files";a:24:{i:0;s:19:"entity.features.inc";i:1;s:15:"entity.i18n.inc";i:2;s:15:"entity.info.inc";i:3;s:16:"entity.rules.inc";i:4;s:11:"entity.test";i:5;s:19:"includes/entity.inc";i:6;s:30:"includes/entity.controller.inc";i:7;s:22:"includes/entity.ui.inc";i:8;s:27:"includes/entity.wrapper.inc";i:9;s:22:"views/entity.views.inc";i:10;s:52:"views/handlers/entity_views_field_handler_helper.inc";i:11;s:51:"views/handlers/entity_views_handler_area_entity.inc";i:12;s:53:"views/handlers/entity_views_handler_field_boolean.inc";i:13;s:50:"views/handlers/entity_views_handler_field_date.inc";i:14;s:54:"views/handlers/entity_views_handler_field_duration.inc";i:15;s:52:"views/handlers/entity_views_handler_field_entity.inc";i:16;s:51:"views/handlers/entity_views_handler_field_field.inc";i:17;s:53:"views/handlers/entity_views_handler_field_numeric.inc";i:18;s:53:"views/handlers/entity_views_handler_field_options.inc";i:19;s:50:"views/handlers/entity_views_handler_field_text.inc";i:20;s:49:"views/handlers/entity_views_handler_field_uri.inc";i:21;s:62:"views/handlers/entity_views_handler_relationship_by_bundle.inc";i:22;s:52:"views/handlers/entity_views_handler_relationship.inc";i:23;s:53:"views/plugins/entity_views_plugin_row_entity_view.inc";}s:7:"version";s:7:"7.x-1.9";s:7:"project";s:6:"entity";s:9:"datestamp";s:10:"1518620551";s:5:"mtime";i:1518620551;s:12:"dependencies";a:0:{}s:7:"package";s:5:"Other";s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/entity/entity_token.module',
  'name' => 'entity_token',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:13:"Entity tokens";s:11:"description";s:99:"Provides token replacements for all properties that have no tokens and are known to the entity API.";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:23:"entity_token.tokens.inc";i:1;s:19:"entity_token.module";}s:12:"dependencies";a:1:{i:0;s:6:"entity";}s:7:"version";s:7:"7.x-1.9";s:7:"project";s:6:"entity";s:9:"datestamp";s:10:"1518620551";s:5:"mtime";i:1518620551;s:7:"package";s:5:"Other";s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/entity/tests/entity_feature.module',
  'name' => 'entity_feature',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:21:"Entity feature module";s:11:"description";s:31:"Provides some entities in code.";s:7:"version";s:7:"7.x-1.9";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:21:"entity_feature.module";}s:12:"dependencies";a:1:{i:0;s:11:"entity_test";}s:6:"hidden";b:1;s:7:"project";s:6:"entity";s:9:"datestamp";s:10:"1518620551";s:5:"mtime";i:1518620551;s:7:"package";s:5:"Other";s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/entity/tests/entity_test.module',
  'name' => 'entity_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:23:"Entity CRUD test module";s:11:"description";s:46:"Provides entity types based upon the CRUD API.";s:7:"version";s:7:"7.x-1.9";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:18:"entity_test.module";i:1;s:19:"entity_test.install";}s:12:"dependencies";a:1:{i:0;s:6:"entity";}s:6:"hidden";b:1;s:7:"project";s:6:"entity";s:9:"datestamp";s:10:"1518620551";s:5:"mtime";i:1518620551;s:7:"package";s:5:"Other";s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/entity/tests/entity_test_i18n.module',
  'name' => 'entity_test_i18n',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:28:"Entity-test type translation";s:11:"description";s:37:"Allows translating entity-test types.";s:12:"dependencies";a:2:{i:0;s:11:"entity_test";i:1;s:11:"i18n_string";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"version";s:7:"7.x-1.9";s:7:"project";s:6:"entity";s:9:"datestamp";s:10:"1518620551";s:5:"mtime";i:1518620551;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/entity_view_mode/entity_view_mode.module',
  'name' => 'entity_view_mode',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:17:"Entity view modes";s:11:"description";s:101:"Allows administrators to define custom view modes for entities via the administration user interface.";s:4:"core";s:3:"7.x";s:10:"recommends";a:1:{i:0;s:8:"field_ui";}s:9:"configure";s:37:"admin/config/system/entity-view-modes";s:5:"files";a:1:{i:0;s:21:"entity_view_mode.test";}s:7:"version";s:11:"7.x-1.0-rc1";s:7:"project";s:16:"entity_view_mode";s:9:"datestamp";s:10:"1368242411";s:5:"mtime";i:1368242411;s:12:"dependencies";a:0:{}s:7:"package";s:5:"Other";s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/entity_view_mode/tests/entity_view_mode_test.module',
  'name' => 'entity_view_mode_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:21:"Entity view mode test";s:11:"description";s:15:"Testing module.";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"version";s:11:"7.x-1.0-rc1";s:7:"project";s:16:"entity_view_mode";s:9:"datestamp";s:10:"1368242411";s:5:"mtime";i:1368242411;s:12:"dependencies";a:0:{}s:7:"package";s:5:"Other";s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/uuid/uuid.module',
  'name' => 'uuid',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7103',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:21:"Universally Unique ID";s:11:"description";s:85:"Extends the entity functionality and adds support for universally unique identifiers.";s:4:"core";s:3:"7.x";s:7:"package";s:4:"UUID";s:9:"configure";s:24:"admin/config/system/uuid";s:5:"files";a:1:{i:0;s:9:"uuid.test";}s:12:"dependencies";a:2:{i:0;s:4:"node";i:1;s:4:"user";}s:7:"version";s:7:"7.x-1.3";s:7:"project";s:4:"uuid";s:9:"datestamp";s:10:"1559150887";s:5:"mtime";i:1559150887;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/uuid/uuid_path/uuid_path.module',
  'name' => 'uuid_path',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:9:"UUID Path";s:11:"description";s:46:"Provides export functionality for url aliases.";s:4:"core";s:3:"7.x";s:7:"package";s:4:"UUID";s:12:"dependencies";a:1:{i:0;s:4:"uuid";}s:7:"version";s:7:"7.x-1.3";s:7:"project";s:4:"uuid";s:9:"datestamp";s:10:"1559150887";s:5:"mtime";i:1559150887;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/uuid/uuid_services/uuid_services.module',
  'name' => 'uuid_services',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:13:"UUID Services";s:11:"description";s:84:"Provides integration with the Services module, like exposing a UUID entity resource.";s:4:"core";s:3:"7.x";s:7:"package";s:20:"Services - resources";s:5:"files";a:1:{i:0;s:32:"uuid_services.user_services.test";}s:12:"dependencies";a:3:{i:0;s:8:"services";i:1;s:4:"uuid";i:2;s:6:"entity";}s:17:"test_dependencies";a:5:{i:0;s:8:"services";i:1;s:6:"entity";i:2;s:4:"file";i:3;s:5:"field";i:4;s:11:"file_entity";}s:7:"version";s:7:"7.x-1.3";s:7:"project";s:4:"uuid";s:9:"datestamp";s:10:"1559150887";s:5:"mtime";i:1559150887;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/uuid/uuid_services_example/uuid_services_example.module',
  'name' => 'uuid_services_example',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:21:"UUID Services Example";s:11:"description";s:90:"Example feature of a UUID service. Works well with the Deploy Example feature as a client.";s:4:"core";s:3:"7.x";s:7:"package";s:8:"Features";s:3:"php";s:5:"5.2.4";s:12:"dependencies";a:4:{i:0;s:11:"rest_server";i:1;s:8:"services";i:2;s:4:"uuid";i:3;s:13:"uuid_services";}s:8:"features";a:3:{s:6:"ctools";a:1:{i:0;s:19:"services:services:3";}s:12:"features_api";a:1:{i:0;s:5:"api:2";}s:17:"services_endpoint";a:1:{i:0;s:21:"uuid_services_example";}}s:7:"version";s:7:"7.x-1.3";s:7:"project";s:4:"uuid";s:9:"datestamp";s:10:"1559150887";s:5:"mtime";i:1559150887;s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'themes/bartik/bartik.info',
  'name' => 'bartik',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:17:{s:4:"name";s:6:"Bartik";s:11:"description";s:48:"A flexible, recolorable theme with many regions.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:7:"regions";a:17:{s:6:"header";s:6:"Header";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:11:"highlighted";s:11:"Highlighted";s:8:"featured";s:8:"Featured";s:7:"content";s:7:"Content";s:13:"sidebar_first";s:13:"Sidebar first";s:14:"sidebar_second";s:14:"Sidebar second";s:14:"triptych_first";s:14:"Triptych first";s:15:"triptych_middle";s:15:"Triptych middle";s:13:"triptych_last";s:13:"Triptych last";s:18:"footer_firstcolumn";s:19:"Footer first column";s:19:"footer_secondcolumn";s:20:"Footer second column";s:18:"footer_thirdcolumn";s:19:"Footer third column";s:19:"footer_fourthcolumn";s:20:"Footer fourth column";s:6:"footer";s:6:"Footer";}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"0";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:28:"themes/bartik/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1607003447;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}}',
))
->values(array(
  'filename' => 'themes/garland/garland.info',
  'name' => 'garland',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:17:{s:4:"name";s:7:"Garland";s:11:"description";s:111:"A multi-column theme which can be configured to modify colors and switch between fixed and fluid width layouts.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:8:"settings";a:1:{s:13:"garland_width";s:5:"fluid";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:6:"engine";s:11:"phptemplate";s:7:"regions";a:9:{s:13:"sidebar_first";s:12:"Left sidebar";s:14:"sidebar_second";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";s:11:"highlighted";s:11:"Highlighted";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";}s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1607003447;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}}',
))
->values(array(
  'filename' => 'themes/seven/seven.info',
  'name' => 'seven',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:17:{s:4:"name";s:5:"Seven";s:11:"description";s:65:"A simple one-column, tableless, fluid width administration theme.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.77";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"1";}s:7:"regions";a:5:{s:7:"content";s:7:"Content";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:13:"sidebar_first";s:13:"First sidebar";}s:14:"regions_hidden";a:3:{i:0;s:13:"sidebar_first";i:1;s:8:"page_top";i:2;s:11:"page_bottom";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1607003447";s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:27:"themes/seven/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1607003447;}',
))
->values(array(
  'filename' => 'themes/stark/stark.info',
  'name' => 'stark',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => "a:16:{s:4:\"name\";s:5:\"Stark\";s:11:\"description\";s:208:\"This theme demonstrates Drupal's default HTML markup and CSS styles. To learn how to build your own theme and override Drupal's default code, see the <a href=\"http://drupal.org/theme-guide\">Theming Guide</a>.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.77\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1607003447\";s:6:\"engine\";s:11:\"phptemplate\";s:7:\"regions\";a:9:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:27:\"themes/stark/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1607003447;s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}}",
))
->execute();
$connection->schema()->createTable('url_alias', array(
  'fields' => array(
    'pid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'source' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'alias' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'pid',
  ),
  'indexes' => array(
    'alias_language_pid' => array(
      array(
        'alias',
        '191',
      ),
      'language',
      'pid',
    ),
    'source_language_pid' => array(
      array(
        'source',
        '191',
      ),
      'language',
      'pid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('users', array(
  'fields' => array(
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '60',
      'default' => '',
    ),
    'pass' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'mail' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '254',
      'default' => '',
    ),
    'theme' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'signature' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'signature_format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'access' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'login' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'timezone' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '32',
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ),
    'picture' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'init' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '254',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'uuid' => array(
      'type' => 'char',
      'not null' => TRUE,
      'length' => '36',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'uid',
  ),
  'unique keys' => array(
    'name' => array(
      'name',
    ),
  ),
  'indexes' => array(
    'access' => array(
      'access',
    ),
    'created' => array(
      'created',
    ),
    'mail' => array(
      array(
        'mail',
        '191',
      ),
    ),
    'picture' => array(
      'picture',
    ),
    'uuid' => array(
      'uuid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('users')
->fields(array(
  'uid',
  'name',
  'pass',
  'mail',
  'theme',
  'signature',
  'signature_format',
  'created',
  'access',
  'login',
  'status',
  'timezone',
  'language',
  'picture',
  'init',
  'data',
  'uuid',
))
->values(array(
  'uid' => '0',
  'name' => '',
  'pass' => '',
  'mail' => '',
  'theme' => '',
  'signature' => '',
  'signature_format' => NULL,
  'created' => '0',
  'access' => '0',
  'login' => '0',
  'status' => '0',
  'timezone' => NULL,
  'language' => '',
  'picture' => '0',
  'init' => '',
  'data' => NULL,
  'uuid' => '283bd243-ffba-4eac-aa41-1ec81025c4e9',
))
->values(array(
  'uid' => '1',
  'name' => 'admin',
  'pass' => '$S$D.unudsvVIl1Q4a.jg72NVFUlk30b9QLeZS98xsjuIrZEf1b9m83',
  'mail' => 'admin@drupal7-bean.localhost',
  'theme' => '',
  'signature' => '',
  'signature_format' => NULL,
  'created' => '1611051529',
  'access' => '1611057740',
  'login' => '1611054960',
  'status' => '1',
  'timezone' => 'Europe/Budapest',
  'language' => '',
  'picture' => '0',
  'init' => 'admin@drupal7-bean.localhost',
  'data' => 'b:0;',
  'uuid' => 'f5218250-bd5e-4f5d-b499-8f27db4636c0',
))
->values(array(
  'uid' => '2',
  'name' => 'editor',
  'pass' => '$S$DCTGcNfM26qs2HZmAUhiANAEw2xjRF6qRaE2xLeMpuzM.UieCi8r',
  'mail' => 'editor@drupal7-bean.localhost',
  'theme' => '',
  'signature' => '',
  'signature_format' => 'filtered_html',
  'created' => '1611057482',
  'access' => '0',
  'login' => '0',
  'status' => '1',
  'timezone' => 'Europe/Budapest',
  'language' => '',
  'picture' => '0',
  'init' => 'editor@drupal7-bean.localhost',
  'data' => NULL,
  'uuid' => '7d50864e-624d-4e4b-9331-6e3d4064166a',
))
->values(array(
  'uid' => '3',
  'name' => 'user',
  'pass' => '$S$D07IhoIIQLnLzuJolwBlRv2jOH7YlDD4LEpZeLs.qH9JH2p.ft7a',
  'mail' => 'user@drupal7-bean.localhost',
  'theme' => '',
  'signature' => '',
  'signature_format' => 'filtered_html',
  'created' => '1611057517',
  'access' => '0',
  'login' => '0',
  'status' => '1',
  'timezone' => 'Europe/Budapest',
  'language' => '',
  'picture' => '0',
  'init' => 'user@drupal7-bean.localhost',
  'data' => NULL,
  'uuid' => '9a21451b-a116-45f1-87e5-f58742dd4a16',
))
->execute();
$connection->schema()->createTable('users_roles', array(
  'fields' => array(
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'rid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'uid',
    'rid',
  ),
  'indexes' => array(
    'rid' => array(
      'rid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('variable', array(
  'fields' => array(
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'value' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'name',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('variable')
->fields(array(
  'name',
  'value',
))
->values(array(
  'name' => 'additional_settings__active_tab_page',
  'value' => 's:12:"edit-display";',
))
->values(array(
  'name' => 'cache_class_cache_ctools_css',
  'value' => 's:14:"CToolsCssCache";',
))
->values(array(
  'name' => 'clean_url',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'cron_key',
  'value' => 's:43:"QDMUn5if_a-9f4M5vDmJQ4ehUIwfXzbzrBdzymuN8r0";',
))
->values(array(
  'name' => 'cron_last',
  'value' => 'i:1611051598;',
))
->values(array(
  'name' => 'css_js_query_string',
  'value' => 's:6:"qn6jow";',
))
->values(array(
  'name' => 'date_default_timezone',
  'value' => 's:15:"Europe/Budapest";',
))
->values(array(
  'name' => 'drupal_all_databases_are_utf8mb4',
  'value' => 'b:1;',
))
->values(array(
  'name' => 'drupal_http_request_fails',
  'value' => 'b:0;',
))
->values(array(
  'name' => 'drupal_private_key',
  'value' => 's:43:"jZ1aZXyYbiWk4OMaqAp-ihvfujWRCRvmVkn0FW5csZs";',
))
->values(array(
  'name' => 'entity_cache_tables_created',
  'value' => 'N;',
))
->values(array(
  'name' => 'entity_view_modes',
  'value' => 'a:1:{s:4:"bean";a:1:{s:7:"compact";a:2:{s:5:"label";s:7:"compact";s:15:"custom settings";i:1;}}}',
))
->values(array(
  'name' => 'field_bundle_settings_bean__image',
  'value' => 'a:2:{s:10:"view_modes";a:2:{s:7:"default";a:1:{s:15:"custom_settings";b:0;}s:7:"compact";a:1:{s:15:"custom_settings";b:0;}}s:12:"extra_fields";a:2:{s:4:"form";a:4:{s:5:"label";a:1:{s:6:"weight";s:3:"-10";}s:5:"title";a:1:{s:6:"weight";s:2:"-9";}s:8:"revision";a:1:{s:6:"weight";s:2:"10";}s:9:"view_mode";a:1:{s:6:"weight";s:2:"10";}}s:7:"display";a:1:{s:5:"title";a:1:{s:7:"default";a:2:{s:6:"weight";s:1:"1";s:7:"visible";b:0;}}}}}',
))
->values(array(
  'name' => 'field_bundle_settings_bean__simple',
  'value' => 'a:2:{s:10:"view_modes";a:2:{s:7:"compact";a:1:{s:15:"custom_settings";b:1;}s:7:"default";a:1:{s:15:"custom_settings";b:0;}}s:12:"extra_fields";a:2:{s:4:"form";a:4:{s:5:"label";a:1:{s:6:"weight";s:3:"-10";}s:5:"title";a:1:{s:6:"weight";s:2:"-9";}s:8:"revision";a:1:{s:6:"weight";s:2:"10";}s:9:"view_mode";a:1:{s:6:"weight";s:2:"10";}}s:7:"display";a:1:{s:5:"title";a:2:{s:7:"default";a:2:{s:6:"weight";s:2:"-9";s:7:"visible";b:1;}s:7:"compact";a:2:{s:6:"weight";s:2:"-9";s:7:"visible";b:0;}}}}}',
))
->values(array(
  'name' => 'field_bundle_settings_node__page',
  'value' => 'a:2:{s:10:"view_modes";a:3:{s:6:"teaser";a:1:{s:15:"custom_settings";b:1;}s:4:"full";a:1:{s:15:"custom_settings";b:0;}s:3:"rss";a:1:{s:15:"custom_settings";b:0;}}s:12:"extra_fields";a:2:{s:4:"form";a:1:{s:5:"title";a:1:{s:6:"weight";s:2:"-5";}}s:7:"display";a:0:{}}}',
))
->values(array(
  'name' => 'file_temporary_path',
  'value' => 's:4:"/tmp";',
))
->values(array(
  'name' => 'filter_fallback_format',
  'value' => 's:10:"plain_text";',
))
->values(array(
  'name' => 'install_profile',
  'value' => 's:7:"minimal";',
))
->values(array(
  'name' => 'install_task',
  'value' => 's:4:"done";',
))
->values(array(
  'name' => 'install_time',
  'value' => 'i:1611051598;',
))
->values(array(
  'name' => 'menu_expanded',
  'value' => 'a:0:{}',
))
->values(array(
  'name' => 'menu_masks',
  'value' => 'a:28:{i:0;i:501;i:1;i:250;i:2;i:245;i:3;i:125;i:4;i:124;i:5;i:123;i:6;i:122;i:7;i:121;i:8;i:63;i:9;i:62;i:10;i:61;i:11;i:60;i:12;i:48;i:13;i:44;i:14;i:31;i:15;i:30;i:16;i:24;i:17;i:21;i:18;i:15;i:19;i:14;i:20;i:11;i:21;i:10;i:22;i:7;i:23;i:6;i:24;i:5;i:25;i:3;i:26;i:2;i:27;i:1;}',
))
->values(array(
  'name' => 'node_options_page',
  'value' => 'a:1:{i:0;s:6:"status";}',
))
->values(array(
  'name' => 'node_preview_page',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'node_submitted_page',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'path_alias_whitelist',
  'value' => 'a:0:{}',
))
->values(array(
  'name' => 'save_continue_page',
  'value' => 's:19:"Save and add fields";',
))
->values(array(
  'name' => 'site_default_country',
  'value' => 's:2:"HU";',
))
->values(array(
  'name' => 'site_mail',
  'value' => 's:27:"site@drupal7-bean.localhost";',
))
->values(array(
  'name' => 'site_name',
  'value' => 's:17:"Drupal 7 and Bean";',
))
->values(array(
  'name' => 'theme_default',
  'value' => 's:6:"bartik";',
))
->values(array(
  'name' => 'user_register',
  'value' => 'i:2;',
))
->execute();
