<?php

namespace Drupal\Tests\bean_migrate\Kernel\Plugin\migrate\source;

/**
 * Tests the bean migrate source plugin.
 *
 * @covers \Drupal\bean_migrate\Plugin\migrate\source\Bean
 * @group bean_migrate
 */
class BeanTest extends BeanSourceTestBase {

  /**
   * {@inheritdoc}
   */
  public function providerSource() {
    $simple_plus_complicated = static::BEAN_SIMPLE_TABLES;
    foreach (static::BEAN_COMPLICATED_TABLES as $table_name => $records) {
      $simple_plus_complicated[$table_name] = array_merge(
        $simple_plus_complicated[$table_name],
        $records
      );
    }

    $test_cases = [
      'Simple beans with revisions' => [
        'Source' => static::BEAN_SIMPLE_TABLES + static::FIELD_TABLES,
        'Expected' => [
          [
            'bid' => 1,
            'vid' => 1,
            'uuid' => '0a4b1a61-1e87-4cb9-9a41-1080fd8af949',
            'delta' => 'simple-1',
            'label' => 'Label 1 (rev 1)',
            'title' => 'Title 1 (rev 1)',
            'type' => 'simple',
            'view_mode' => 'default',
            'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
            'uid' => 1,
            'created' => '1600000000',
            'changed' => '1600000000',
            'log' => '',
            'status' => 1,
            'revision_default' => 1,
            'revision_uid' => 1,
            'field' => [['value' => 'simple id 1 rev 1 field value']],
            'language' => 'und',
          ],
          [
            'bid' => 2,
            'vid' => 2,
            'uuid' => '7bb6bb6f-0bfb-4421-b339-840f8092842a',
            'delta' => 'simple-2',
            'label' => 'Label 2 (rev 1)',
            'title' => 'Title 2 (rev 1)',
            'type' => 'simple',
            'view_mode' => 'default',
            'data' => serialize(['view_mode' => 'default']),
            'uid' => 22,
            'created' => '1610000000',
            'changed' => '1610000000',
            'log' => '',
            'status' => 1,
            'revision_default' => 1,
            'revision_uid' => 20,
            'field' => [['value' => 'simple id 2 rev 1 field value']],
            'language' => 'und',
          ],
          [
            'bid' => 2,
            'vid' => 3,
            'uuid' => '7bb6bb6f-0bfb-4421-b339-840f8092842a',
            'delta' => 'simple-2',
            'label' => 'Label 2 (rev 2)',
            'title' => 'Title 2 (rev 2)',
            'type' => 'simple',
            'view_mode' => 'default',
            'data' => serialize(['view_mode' => 'default']),
            'uid' => 22,
            'created' => '1610000000',
            'changed' => '1610010000',
            'log' => 'New (published) revision.',
            'status' => 1,
            'revision_default' => 1,
            'revision_uid' => 22,
            'field' => [['value' => 'simple id 2 rev 2 field value']],
            'language' => 'und',
          ],
        ],
      ],
      'Complicated bean with a trailing (non-default) revision' => [
        'Source' => static::BEAN_COMPLICATED_TABLES + static::FIELD_TABLES,
        'Expected' => [
          [
            'bid' => 3,
            'vid' => 4,
            'uuid' => '4404df30-1712-4cd6-b12f-d0e3fc7aa5ff',
            'delta' => 'complicated',
            'label' => 'Label 3 (rev 1)',
            'title' => 'Title 3 (rev 1)',
            'type' => 'complicated',
            'view_mode' => 'default',
            'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
            'uid' => 2,
            'created' => '1620000000',
            'changed' => '1620000000',
            'log' => '',
            'status' => 1,
            'revision_default' => 1,
            'revision_uid' => 2,
            'field' => [['value' => 'complicated id 3 rev 1 field value']],
            'language' => 'und',
          ],
          [
            'bid' => 3,
            'vid' => 5,
            'uuid' => '4404df30-1712-4cd6-b12f-d0e3fc7aa5ff',
            'delta' => 'complicated',
            'label' => 'Label 3 (rev 2)',
            'title' => 'Title 3 (rev 2)',
            'type' => 'complicated',
            'view_mode' => 'default',
            'data' => serialize(['view_mode' => 'default']),
            'uid' => 2,
            'created' => '1620000000',
            'changed' => '1620010000',
            'log' => 'Unpublished revision.',
            'status' => 0,
            'revision_default' => 0,
            'revision_uid' => 2,
            'field' => [['value' => 'complicated id 3 rev 2 field value']],
            'language' => 'und',
          ],
        ],
      ],
    ];
    $test_cases['Simple + complicated, no filtering'] = [
      'Source' => $simple_plus_complicated + static::FIELD_TABLES,
      'Expected' => array_merge(
        $test_cases['Simple beans with revisions']['Expected'],
        $test_cases['Complicated bean with a trailing (non-default) revision']['Expected']
      ),
    ];
    $test_cases['Simple + complicated, source limited to simple'] = [
      'Source' => $simple_plus_complicated + static::FIELD_TABLES,
      'Expected' => $test_cases['Simple beans with revisions']['Expected'],
      'Count' => 3,
      'config' => [
        'type' => 'simple',
      ],
    ];

    // Multilingual.
    $test_cases['Monolingual and translated beans, no UUID'] = [
      'Source' => static::MULTILINGUAL_TABLES,
      'Expected' => [
        0 => [
          'bid' => 1,
          'vid' => 1,
          'delta' => 'untranslatable-1',
          'label' => 'Label 1 (rev 1)',
          'title' => 'Title 1 (rev 1)',
          'type' => 'untranslatable',
          'view_mode' => 'default',
          'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
          'uid' => 1,
          'created' => '1600000000',
          'changed' => '1600000000',
          'log' => '',
          'status' => 1,
          'revision_default' => 1,
          'revision_uid' => 1,
          'language' => 'und',
          'translate' => NULL,
          'etr_uid' => NULL,
          'etr_status' => NULL,
          'etr_created' => NULL,
          'etr_changed' => NULL,
          'source_language' => NULL,
          'field' => [['value' => 'untranslatable id 1 rev 1 field value']],
          'entity_id' => NULL,
          'revision_id' => NULL,
        ],
        1 => [
          'bid' => 2,
          'vid' => 2,
          'delta' => 'untranslatable-2',
          'label' => 'Label 2 (rev 1)',
          'title' => 'Title 2 (rev 1)',
          'type' => 'untranslatable',
          'view_mode' => 'default',
          'data' => serialize(['view_mode' => 'default']),
          'uid' => 22,
          'created' => '1610000000',
          'changed' => '1610000000',
          'log' => '',
          'status' => 1,
          'revision_default' => 1,
          'revision_uid' => 20,
          'language' => 'und',
          'translate' => NULL,
          'etr_uid' => NULL,
          'etr_status' => NULL,
          'etr_created' => NULL,
          'etr_changed' => NULL,
          'source_language' => NULL,
          'field' => [['value' => 'untranslatable id 2 rev 1 field value']],
          'entity_id' => NULL,
          'revision_id' => NULL,
        ],
        2 => [
          'bid' => 2,
          'vid' => 3,
          'delta' => 'untranslatable-2',
          'label' => 'Label 2 (rev 2)',
          'title' => 'Title 2 (rev 2)',
          'type' => 'untranslatable',
          'view_mode' => 'default',
          'data' => serialize(['view_mode' => 'default']),
          'uid' => 22,
          'created' => '1610000000',
          'changed' => '1610010000',
          'log' => 'New (published) revision.',
          'status' => 1,
          'revision_default' => 1,
          'revision_uid' => 22,
          'language' => 'und',
          'translate' => NULL,
          'etr_uid' => NULL,
          'etr_status' => NULL,
          'etr_created' => NULL,
          'etr_changed' => NULL,
          'source_language' => NULL,
          'field' => [['value' => 'untranslatable id 2 rev 2 field value']],
          'entity_id' => NULL,
          'revision_id' => NULL,
        ],
        3 => [
          'bid' => 3,
          'vid' => 4,
          'delta' => 'translatable',
          'label' => 'Label 3 (rev 1)',
          'title' => 'Title 3 (rev 1)',
          'type' => 'translatable',
          'view_mode' => 'default',
          'data' => serialize(['view_mode' => 'default']),
          'uid' => 2,
          'created' => 1620000000,
          'changed' => 1620000000,
          'log' => '',
          'status' => 1,
          'revision_default' => 1,
          'revision_uid' => 2,
          'language' => 'hu',
          'translate' => 0,
          'etr_uid' => 2,
          'etr_status' => 1,
          'etr_created' => 1620000000,
          'etr_changed' => 1620000000,
          'source_language' => '',
          'field' => [['value' => 'untranslatable id 3 rev 1 field value']],
          'field_translatable' => [
            [
              'value' => 'HU translatable id 3 rev 1 field_translatable value',
            ],
          ],
          'entity_id' => 3,
          'revision_id' => 4,
        ],
        4 => [
          'bid' => 3,
          'vid' => 5,
          'delta' => 'translatable',
          'label' => 'Label 3 (rev 2)',
          'title' => 'Title 3 (rev 2)',
          'type' => 'translatable',
          'view_mode' => 'default',
          'data' => serialize(['view_mode' => 'default']),
          'uid' => 2,
          'created' => 1620000000,
          'changed' => 1620010000,
          'log' => '',
          'status' => 1,
          'revision_default' => 1,
          'revision_uid' => 2,
          'language' => 'hu',
          'translate' => 1,
          'etr_uid' => 2,
          'etr_status' => 1,
          'etr_created' => 1620000000,
          'etr_changed' => 1620000000,
          'source_language' => '',
          'field' => [['value' => 'untranslatable id 3 rev 1 field value']],
          'field_translatable' => [
            [
              'value' => 'HU translatable id 3 rev 1 field_translatable value',
            ],
          ],
          'entity_id' => 3,
          'revision_id' => 5,
        ],
        5 => [
          'bid' => 3,
          'vid' => 5,
          'delta' => 'translatable',
          'label' => 'Label 3 (rev 2)',
          'title' => 'Title 3 (rev 2)',
          'type' => 'translatable',
          'view_mode' => 'default',
          'data' => serialize(['view_mode' => 'default']),
          'uid' => 2,
          'created' => 1620000000,
          'changed' => 1620010000,
          'log' => '',
          'status' => 1,
          'revision_default' => 1,
          'revision_uid' => 2,
          'language' => 'en',
          'translate' => 0,
          'etr_uid' => 22,
          'etr_status' => 1,
          'etr_created' => 1620010000,
          'etr_changed' => 1620010000,
          'source_language' => 'hu',
          'field' => [['value' => 'untranslatable id 3 rev 1 field value']],
          'field_translatable' => [
            [
              'value' => 'EN translatable id 3 rev 2 field_translatable value',
            ],
          ],
          'entity_id' => 3,
          'revision_id' => 5,
        ],
      ],
    ];

    return $test_cases;
  }

  /**
   * Field related tables and records used in the test.
   *
   * @const array[][]
   */
  const FIELD_TABLES = [
    'field_config' => [
      [
        'id' => 1,
        'translatable' => 0,
      ],
    ],
    'field_config_instance' => [
      [
        'field_id' => 1,
        'field_name' => 'field',
        'entity_type' => 'bean',
        'bundle' => 'simple',
        'deleted' => 0,
      ],
      [
        'field_id' => 1,
        'field_name' => 'field',
        'entity_type' => 'bean',
        'bundle' => 'complicated',
        'deleted' => 0,
      ],
    ],
    'field_revision_field' => [
      [
        'entity_type' => 'bean',
        'bundle' => 'simple',
        'entity_id' => '1',
        'revision_id' => '1',
        'delta' => 0,
        'deleted' => 0,
        'field_value' => 'simple id 1 rev 1 field value',
      ],
      [
        'entity_type' => 'bean',
        'bundle' => 'simple',
        'entity_id' => '2',
        'revision_id' => '2',
        'delta' => 0,
        'deleted' => 0,
        'field_value' => 'simple id 2 rev 1 field value',
      ],
      [
        'entity_type' => 'bean',
        'bundle' => 'simple',
        'entity_id' => '2',
        'revision_id' => '3',
        'delta' => 0,
        'deleted' => 0,
        'field_value' => 'simple id 2 rev 2 field value',
      ],
      [
        'entity_type' => 'bean',
        'bundle' => 'complicated',
        'entity_id' => '3',
        'revision_id' => '4',
        'delta' => 0,
        'deleted' => 0,
        'field_value' => 'complicated id 3 rev 1 field value',
      ],
      [
        'entity_type' => 'bean',
        'bundle' => 'complicated',
        'entity_id' => '3',
        'revision_id' => '5',
        'delta' => 0,
        'deleted' => 0,
        'field_value' => 'complicated id 3 rev 2 field value',
      ],
    ],
  ];

  /**
   * Tables with test data with "simple" bean records.
   *
   * Contains two bean entities. One of them has two revisions (all of them are
   * published).
   *
   * @const array[][]
   */
  const BEAN_SIMPLE_TABLES = [
    'bean' => [
      [
        'bid' => 1,
        'vid' => 1,
        'delta' => 'simple-1',
        'label' => 'Label 1 (rev 1)',
        'title' => 'Title 1 (rev 1)',
        'type' => 'simple',
        'view_mode' => 'default',
        'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
        'uid' => 1,
        'created' => '1600000000',
        'changed' => '1600000000',
        'uuid' => '0a4b1a61-1e87-4cb9-9a41-1080fd8af949',
      ],
      [
        'bid' => 2,
        'vid' => 3,
        'delta' => 'simple-2',
        'label' => 'Label 2 (rev 2)',
        'title' => 'Title 2 (rev 2)',
        'type' => 'simple',
        'view_mode' => 'default',
        'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
        'uid' => 22,
        'created' => '1610000000',
        'changed' => '1620000000',
        'uuid' => '7bb6bb6f-0bfb-4421-b339-840f8092842a',
      ],
    ],
    'bean_revision' => [
      [
        'bid' => 1,
        'vid' => 1,
        'delta' => 'simple-1',
        'label' => 'Label 1 (rev 1)',
        'title' => 'Title 1 (rev 1)',
        'type' => 'simple',
        'view_mode' => 'default',
        'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
        'uid' => 1,
        'created' => '1600000000',
        'changed' => '1600000000',
        'log' => '',
      ],
      [
        'bid' => 2,
        'vid' => 2,
        'delta' => 'simple-2',
        'label' => 'Label 2 (rev 1)',
        'title' => 'Title 2 (rev 1)',
        'type' => 'simple',
        'view_mode' => 'default',
        'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
        'uid' => 20,
        'created' => '1610000000',
        'changed' => '1610000000',
        'log' => '',
      ],
      [
        'bid' => 2,
        'vid' => 3,
        'delta' => 'simple-2',
        'label' => 'Label 2 (rev 2)',
        'title' => 'Title 2 (rev 2)',
        'type' => 'simple',
        'view_mode' => 'default',
        'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
        'uid' => 22,
        'created' => '1610000000',
        'changed' => '1610010000',
        'log' => 'New (published) revision.',
      ],
    ],
  ];

  /**
   * Tables with test data with "complicated" bean records.
   *
   * Contains a single bean entity with a default revision and with a trailer,
   * unpublished revision.
   *
   * @const array[][]
   */
  const BEAN_COMPLICATED_TABLES = [
    'bean' => [
      [
        'bid' => 3,
        'vid' => 4,
        'delta' => 'complicated',
        'label' => 'Label 3 (rev 1)',
        'title' => 'Title 3 (rev 1)',
        'type' => 'complicated',
        'view_mode' => 'default',
        'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
        'uid' => 2,
        'created' => '1620000000',
        'changed' => '1620000000',
        'uuid' => '4404df30-1712-4cd6-b12f-d0e3fc7aa5ff',
      ],
    ],
    'bean_revision' => [
      [
        'bid' => 3,
        'vid' => 4,
        'delta' => 'complicated',
        'label' => 'Label 3 (rev 1)',
        'title' => 'Title 3 (rev 1)',
        'type' => 'complicated',
        'view_mode' => 'default',
        'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
        'uid' => 2,
        'created' => '1620000000',
        'changed' => '1620000000',
        'log' => '',
      ],
      [
        'bid' => 3,
        'vid' => 5,
        'delta' => 'complicated',
        'label' => 'Label 3 (rev 2)',
        'title' => 'Title 3 (rev 2)',
        'type' => 'complicated',
        'view_mode' => 'default',
        'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
        'uid' => 2,
        'created' => '1620000000',
        'changed' => '1620010000',
        'log' => 'Unpublished revision.',
      ],
    ],
  ];

  /**
   * Source data fixture for the multilingual test cases.
   *
   * @const array[][]
   */
  const MULTILINGUAL_TABLES = [
    'system' => [
      'system' => [
        'name' => 'system',
        'schema_version' => 7084,
        'type' => 'module',
        'status' => 1,
      ],
      'entity_translation' => [
        'name' => 'entity_translation',
        'schema_version' => 7009,
        'type' => 'module',
        'status' => 1,
      ],
      'locale' => [
        'name' => 'locale',
        'schema_version' => 7084,
        'type' => 'module',
        'status' => 1,
      ],
      'bean' => [
        'name' => 'bean',
        'schema_version' => 7013,
        'type' => 'module',
        'status' => 1,
      ],
    ],
    'field_config' => [
      [
        'id' => 1,
        'translatable' => 0,
      ],
      [
        'id' => 2,
        'translatable' => 1,
      ],
    ],
    'field_config_instance' => [
      [
        'field_id' => 1,
        'field_name' => 'field',
        'entity_type' => 'bean',
        'bundle' => 'untranslatable',
        'deleted' => 0,
      ],
      [
        'field_id' => 1,
        'field_name' => 'field',
        'entity_type' => 'bean',
        'bundle' => 'translatable',
        'deleted' => 0,
      ],
      [
        'field_id' => 2,
        'field_name' => 'field_translatable',
        'entity_type' => 'bean',
        'bundle' => 'translatable',
        'deleted' => 0,
      ],
    ],
    'field_revision_field' => [
      [
        'entity_type' => 'bean',
        'bundle' => 'untranslatable',
        'entity_id' => 1,
        'revision_id' => 1,
        'delta' => 0,
        'deleted' => 0,
        'field_value' => 'untranslatable id 1 rev 1 field value',
        'language' => 'und',
      ],
      [
        'entity_type' => 'bean',
        'bundle' => 'untranslatable',
        'entity_id' => 2,
        'revision_id' => 2,
        'delta' => 0,
        'deleted' => 0,
        'field_value' => 'untranslatable id 2 rev 1 field value',
        'language' => 'und',
      ],
      [
        'entity_type' => 'bean',
        'bundle' => 'untranslatable',
        'entity_id' => 2,
        'revision_id' => 3,
        'delta' => 0,
        'deleted' => 0,
        'field_value' => 'untranslatable id 2 rev 2 field value',
        'language' => 'und',
      ],
      [
        'entity_type' => 'bean',
        'bundle' => 'translatable',
        'entity_id' => 3,
        'revision_id' => 4,
        'delta' => 0,
        'deleted' => 0,
        'field_value' => 'untranslatable id 3 rev 1 field value',
        'language' => 'hu',
      ],
      [
        'entity_type' => 'bean',
        'bundle' => 'translatable',
        'entity_id' => 3,
        'revision_id' => 5,
        'delta' => 0,
        'deleted' => 0,
        'field_value' => 'untranslatable id 3 rev 1 field value',
        'language' => 'en',
      ],
      [
        'entity_type' => 'bean',
        'bundle' => 'translatable',
        'entity_id' => 3,
        'revision_id' => 5,
        'delta' => 0,
        'deleted' => 0,
        'field_value' => 'untranslatable id 3 rev 1 field value',
        'language' => 'hu',
      ],
    ],
    'field_revision_field_translatable' => [
      [
        'entity_type' => 'bean',
        'bundle' => 'translatable',
        'entity_id' => 3,
        'revision_id' => 4,
        'delta' => 0,
        'deleted' => 0,
        'field_translatable_value' => 'HU translatable id 3 rev 1 field_translatable value',
        'language' => 'hu',
      ],
      [
        'entity_type' => 'bean',
        'bundle' => 'translatable',
        'entity_id' => 3,
        'revision_id' => 5,
        'delta' => 0,
        'deleted' => 0,
        'field_translatable_value' => 'EN translatable id 3 rev 2 field_translatable value',
        'language' => 'en',
      ],
      [
        'entity_type' => 'bean',
        'bundle' => 'translatable',
        'entity_id' => 3,
        'revision_id' => 5,
        'delta' => 0,
        'deleted' => 0,
        'field_translatable_value' => 'HU translatable id 3 rev 1 field_translatable value',
        'language' => 'hu',
      ],
    ],
    'bean' => [
      [
        'bid' => 1,
        'vid' => 1,
        'delta' => 'untranslatable-1',
        'label' => 'Label 1 (rev 1)',
        'title' => 'Title 1 (rev 1)',
        'type' => 'untranslatable',
        'view_mode' => 'default',
        'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
        'uid' => 1,
        'created' => '1600000000',
        'changed' => '1600000000',
      ],
      [
        'bid' => 2,
        'vid' => 3,
        'delta' => 'untranslatable-2',
        'label' => 'Label 2 (rev 2)',
        'title' => 'Title 2 (rev 2)',
        'type' => 'untranslatable',
        'view_mode' => 'default',
        'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
        'uid' => 22,
        'created' => '1610000000',
        'changed' => '1620000000',
      ],
      [
        'bid' => 3,
        'vid' => 5,
        'delta' => 'translatable',
        'label' => 'Label 3 (rev 1)',
        'title' => 'Title 3 (rev 1)',
        'type' => 'translatable',
        'view_mode' => 'default',
        'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
        'uid' => 2,
        'created' => '1620000000',
        'changed' => '1620000000',
      ],
    ],
    'bean_revision' => [
      [
        'bid' => 1,
        'vid' => 1,
        'delta' => 'untranslatable-1',
        'label' => 'Label 1 (rev 1)',
        'title' => 'Title 1 (rev 1)',
        'type' => 'untranslatable',
        'view_mode' => 'default',
        'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
        'uid' => 1,
        'created' => '1600000000',
        'changed' => '1600000000',
        'log' => '',
      ],
      [
        'bid' => 2,
        'vid' => 2,
        'delta' => 'untranslatable-2',
        'label' => 'Label 2 (rev 1)',
        'title' => 'Title 2 (rev 1)',
        'type' => 'untranslatable',
        'view_mode' => 'default',
        'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
        'uid' => 20,
        'created' => '1610000000',
        'changed' => '1610000000',
        'log' => '',
      ],
      [
        'bid' => 2,
        'vid' => 3,
        'delta' => 'untranslatable-2',
        'label' => 'Label 2 (rev 2)',
        'title' => 'Title 2 (rev 2)',
        'type' => 'untranslatable',
        'view_mode' => 'default',
        'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
        'uid' => 22,
        'created' => '1610000000',
        'changed' => '1610010000',
        'log' => 'New (published) revision.',
      ],
      [
        'bid' => 3,
        'vid' => 4,
        'delta' => 'translatable',
        'label' => 'Label 3 (rev 1)',
        'title' => 'Title 3 (rev 1)',
        'type' => 'translatable',
        'view_mode' => 'default',
        'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
        'uid' => 2,
        'created' => '1620000000',
        'changed' => '1620000000',
        'log' => '',
      ],
      [
        'bid' => 3,
        'vid' => 5,
        'delta' => 'translatable',
        'label' => 'Label 3 (rev 2)',
        'title' => 'Title 3 (rev 2)',
        'type' => 'complicated',
        'view_mode' => 'default',
        'data' => 'a:1:{s:9:"view_mode";s:7:"default";}',
        'uid' => 2,
        'created' => 1620000000,
        'changed' => 1620010000,
        'log' => '',
      ],
    ],
    'entity_translation_revision' => [
      [
        'entity_type' => 'bean',
        'entity_id' => 3,
        'revision_id' => 4,
        'language' => 'hu',
        'source' => '',
        'uid' => 2,
        'status' => 1,
        'translate' => 0,
        'created' => 1620000000,
        'changed' => 1620000000,
      ],
      [
        'entity_type' => 'bean',
        'entity_id' => 3,
        'revision_id' => 5,
        'language' => 'en',
        'source' => 'hu',
        'uid' => 22,
        'status' => 1,
        'translate' => 0,
        'created' => 1620010000,
        'changed' => 1620010000,
      ],
      [
        'entity_type' => 'bean',
        'entity_id' => 3,
        'revision_id' => 5,
        'language' => 'hu',
        'source' => '',
        'uid' => 2,
        'status' => 1,
        'translate' => 1,
        'created' => 1620000000,
        'changed' => 1620000000,
      ],
    ],
  ];

}
