<?php

/**
 * @file
 * Inserts Beanstalk commit messages as nodes.
 * 
 * This file should be copied to the Drupal docroot and optionally be password
 * protected using .htaccess rules or similar.
 */

/**
 * Do a full Drupal boostrap,
 */
require_once './includes/bootstrap.inc';
drupal_bootstrap(DRUPAL_BOOTSTRAP_FULL);

/**
 * See if there is a token in $_GET, and if there is a matching repository.
 */
if (isset($_GET['t']) and !empty($_GET['t'])) {
  $sql = "SELECT * FROM {beanstalk_repository} WHERE token = '%s'";
  $repository = db_fetch_object(db_query($sql, $_GET['t']));
  if (empty($repository) || !$repository->rid) {
    _beanstalk_die(t('Invalid token in $_GET.'));
  }
  else {
    $repository->tids = unserialize($repository->tids);
    $repository->gids = unserialize($repository->gids);
  }
}
else {
  _beanstalk_die(t('No token in $_GET.'));
}


/**
 * See if there is a JSON-commit in $_POST, get commit data.
 */
if (isset($_POST['commit']) and !empty($_POST['commit'])) {
  $data = json_decode($_POST['commit'], true);
  if (empty($data) or !is_array($data)) {
    _beanstalk_die(t('No valid JSON in $_POST.'));
  }
}
else {
  _beanstalk_die(t('No commit in $_POST.'));
}


/**
 * Everything is there, create the node!
 */
if (isset($repository, $data)) {
  module_load_include('inc', 'beanstalk');
  _beanstalk_commit($repository, $data);
}


/**
 * Log error, deny access
 */
function _beanstalk_die($message = '') {
  watchdog('beanstalk', 'Possible break-in attempt: %message', array('%message' => $message), WATCHDOG_ERROR);
  drupal_access_denied();
}
?>