# Semantic UI Integration
Bear Skin can be integrated with [Semantic](http://semantic-ui.com/), a UI framework designed for theming. Semantic allows developers to build beautiful websites fast, with concise HTML, intuitive javascript, and simplified debugging. Semantic is responsively designed allowing your website to scale on multiple devices.

## Installing Semantic UI
This theme is setup to use Semantic UI for many UI/UX elements.

In order to enable, download the plugin at https://github.com/Semantic-Org/Semantic-UI, place the uncompressed directory in the bear_coat root directory and rename it to "semantic_ui".
The path should be `bear_coat/semantic_ui/`. You can also cd into bear_coat and run `git clone https://github.com/Semantic-Org/Semantic-UI.git semantic_ui`.

After you have installed the library and modules, go the the Bear Coat settings page (/admin/appearance/settings/bear_coat), check the box next to "Include Semantic UI" and save configuration.

**You will need to clear your caches after enabling or disabling these options.**

## Semantic UI Features Code Examples
To view the front-end output of this code, please visit the [Semantic UI](http://bear.zivtech.com/feature/semantic-ui) feature page on the Bear info site.

### Accordions
```
<div class="ui styled accordion">
    <div class="active title"><i class="dropdown icon">&nbsp;</i> Lipsum 1</div>
    <div class="active content">
        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>
    </div>
    <div class="title"><i class="dropdown icon">&nbsp;</i> Lipsum 2</div>
    <div class="content">
        <p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt.</p>
    </div>
    <div class="title"><i class="dropdown icon">&nbsp;</i> Lipsum 3</div>
    <div class="content">
        <p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti.</p>
    </div>
</div>
```

### Cards / Equal Height Content
This feature uses Flexbox and Semantic UI.
```
<div class="ui cards">
    <div class="card">
        <div class="content">
            <header>Header 1</header>
            <p>Nulla vitae elit libero, a pharetra augue. Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Curabitur blandit tempus porttitor.</p>
        </div>
    </div>
    <div class="card">
        <div class="content">
            <header>Header 2</header>
            <p>Donec ullamcorper nulla non metus auctor fringilla. Etiam porta sem malesuada magna mollis euismod. Nullam id dolor id nibh ultricies vehicula ut id elit. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum.</p>
            <p>Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Maecenas faucibus mollis interdum. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus. Maecenas faucibus mollis interdum. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec sed odio dui. Sed posuere consectetur est at lobortis.</p>
        </div>
    </div>
    <div class="card">
        <div class="content">
            <header>Header 3</header>
            <p>Praesent commodo cursus magna, vel scelerisque nisl consectetur et. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Nullam quis risus eget urna mollis ornare vel eu leo. Etiam porta sem malesuada magna mollis euismod. Cras mattis consectetur purus sit amet fermentum. Sed posuere consectetur est at lobortis. Maecenas faucibus mollis interdum.</p>
        </div>
    </div>
</div>
```

### Checkboxes
Checkboxes generated by Drupal will automatically inherit the right classes. For WYSIWYG and other types of checkboxes (sliders, etc), use the code below.
```
<div class="ui form">
  <div class="inline field">
    <div class="ui checkbox">
      <input type="checkbox" tabindex="0" class="hidden">
      <label>Checkbox</label>
    </div>
  </div>
  <div class="inline field">
    <div class="ui slider checkbox">
      <input type="checkbox" tabindex="0" class="hidden">
      <label>Slider</label>
    </div>
    <label></label>
  </div>
  <div class="inline field">
    <div class="ui toggle checkbox">
      <input type="checkbox" tabindex="0" class="hidden">
      <label>Toggle</label>
    </div>
  </div>
</div>
```

### Icon Set
List of icons available at http://semantic-ui.com/elements/icon.html. When using the `<i>` tag in the WYSIWYG, be sure to include an html space (`&nbsp;`) so that the code won't be stripped on node save.
```
<i class="shop icon">&nbsp;</i>
<i class="mail icon">&nbsp;</i>
```

### Modal
More info at http://semantic-ui.com/modules/modal.html. Code example below is used for the Login modal at http://bear.zivtech.com/.
```
<div style="display:none">
    <div id="login-popup" class="ui modal login"> <i class="close icon"></i>
        <div class="header">
            User Login</div>
        <form class="ui form segment" action="/features" method="post" id="user-login" accept-charset="UTF-8">
            <div>
                <div class="form-item field  form-type-textfield form-item-name required">
                    <label for="edit-name">Username</label>
                    <input placeholder="Username" id="edit-name" name="name" value="" size="60" maxlength="60" class="form-text required" type="text">
                    <p class="description">Enter your username.</p>
                </div>
                <div class="form-item field  form-type-password form-item-pass required">
                    <label for="edit-pass">Password</label>
                    <input placeholder="Password" id="edit-pass" name="pass" size="60" maxlength="128" class="form-text required" type="password">
                    <p class="description">Enter the password that accompanies your username.</p>
                </div>
                <input name="form_build_id" value="form-4q5drpkF_KSMPy4BGxnGRAO_vNAp4Nmw6vwak5LOzmE" type="hidden">
                <input name="form_id" value="user_login" type="hidden">
                <input class="huge ui button button ui button form-submit" id="edit-submit--3" name="op" value="Log in" type="submit">
            </div>
        </form>
    </div>
</div>
<a class="loginpopup item floated in" href="#"><i class="setting icon"></i> Login</a>
```

### Responsive Tables
While tables styling is handled by Semantic UI classes, their responsive states is not (that's why we use the unstackable class) so we can implement a better responsive approach.

Tables generated by Drupal will have the proper classes assigned to them. However, when using the WYSIWYG, it is important to apply the following classes to the tag: `table class="ui celled table unstackable"`

The table will automatically inherit a horizontal scrollbar when its width is under 600px. This can be changed in the `_tables.scss` file.
```
<table class="ui celled table unstackable">
    <thead>
        <tr>
            <th>Header</th>
            <th>Header</th>
            <th>Header</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td>First</td>
            <td>Cell</td>
            <td>Cell</td>
        </tr>
        <tr>
            <td>Cell</td>
            <td>Cell</td>
            <td>Cell</td>
        </tr>
        <tr>
            <td>Cell</td>
            <td>Cell</td>
            <td>Cell</td>
        </tr>
    </tbody>
</table>
```

### Select Lists
By default, Bear Skin integrates the select lists with the class `search`, which adds a search bar to the dropdown. The example below can be used for adding a country select list.

All select lists generated by Drupal will have the proper classes assigned, however WYSIWYG ones will need the `ui search dropdown` classes.

```
<div class="ui form">
  <div class="field">
    <select class="ui search dropdown">
      <option value="">Select Country</option>
      <option value="AF">Afghanistan</option>
      <option value="AX">Åland Islands</option>
      <option value="AL">Albania</option>
      <option value="DZ">Algeria</option>
      <option value="AS">American Samoa</option>
      <option value="AD">Andorra</option>
      <option value="AO">Angola</option>
      <option value="AI">Anguilla</option>
      <option value="AQ">Antarctica</option>
      <option value="AG">Antigua and Barbuda</option>
      <option value="AR">Argentina</option>
      <option value="AM">Armenia</option>
      <option value="AW">Aruba</option>
      <option value="AU">Australia</option>
      <option value="AT">Austria</option>
      <option value="AZ">Azerbaijan</option>
      <option value="BS">Bahamas</option>
      <option value="BH">Bahrain</option>
      <option value="BD">Bangladesh</option>
      <option value="BB">Barbados</option>
      <option value="BY">Belarus</option>
      <option value="BE">Belgium</option>
      <option value="BZ">Belize</option>
      <option value="BJ">Benin</option>
      <option value="BM">Bermuda</option>
      <option value="BT">Bhutan</option>
      <option value="BO">Bolivia, Plurinational State of</option>
      <option value="BQ">Bonaire, Sint Eustatius and Saba</option>
      <option value="BA">Bosnia and Herzegovina</option>
      <option value="BW">Botswana</option>
      <option value="BV">Bouvet Island</option>
      <option value="BR">Brazil</option>
      <option value="IO">British Indian Ocean Territory</option>
      <option value="BN">Brunei Darussalam</option>
      <option value="BG">Bulgaria</option>
      <option value="BF">Burkina Faso</option>
      <option value="BI">Burundi</option>
      <option value="KH">Cambodia</option>
      <option value="CM">Cameroon</option>
      <option value="CA">Canada</option>
      <option value="CV">Cape Verde</option>
      <option value="KY">Cayman Islands</option>
      <option value="CF">Central African Republic</option>
      <option value="TD">Chad</option>
      <option value="CL">Chile</option>
      <option value="CN">China</option>
      <option value="CX">Christmas Island</option>
      <option value="CC">Cocos (Keeling) Islands</option>
      <option value="CO">Colombia</option>
      <option value="KM">Comoros</option>
      <option value="CG">Congo</option>
      <option value="CD">Congo, the Democratic Republic of the</option>
      <option value="CK">Cook Islands</option>
      <option value="CR">Costa Rica</option>
      <option value="CI">Côte d Ivoire</option>
      <option value="HR">Croatia</option>
      <option value="CU">Cuba</option>
      <option value="CW">Curaçao</option>
      <option value="CY">Cyprus</option>
      <option value="CZ">Czech Republic</option>
      <option value="DK">Denmark</option>
      <option value="DJ">Djibouti</option>
      <option value="DM">Dominica</option>
      <option value="DO">Dominican Republic</option>
      <option value="EC">Ecuador</option>
      <option value="EG">Egypt</option>
      <option value="SV">El Salvador</option>
      <option value="GQ">Equatorial Guinea</option>
      <option value="ER">Eritrea</option>
      <option value="EE">Estonia</option>
      <option value="ET">Ethiopia</option>
      <option value="FK">Falkland Islands (Malvinas)</option>
      <option value="FO">Faroe Islands</option>
      <option value="FJ">Fiji</option>
      <option value="FI">Finland</option>
      <option value="FR">France</option>
      <option value="GF">French Guiana</option>
      <option value="PF">French Polynesia</option>
      <option value="TF">French Southern Territories</option>
      <option value="GA">Gabon</option>
      <option value="GM">Gambia</option>
      <option value="GE">Georgia</option>
      <option value="DE">Germany</option>
      <option value="GH">Ghana</option>
      <option value="GI">Gibraltar</option>
      <option value="GR">Greece</option>
      <option value="GL">Greenland</option>
      <option value="GD">Grenada</option>
      <option value="GP">Guadeloupe</option>
      <option value="GU">Guam</option>
      <option value="GT">Guatemala</option>
      <option value="GG">Guernsey</option>
      <option value="GN">Guinea</option>
      <option value="GW">Guinea-Bissau</option>
      <option value="GY">Guyana</option>
      <option value="HT">Haiti</option>
      <option value="HM">Heard Island and McDonald Islands</option>
      <option value="VA">Holy See (Vatican City State)</option>
      <option value="HN">Honduras</option>
      <option value="HK">Hong Kong</option>
      <option value="HU">Hungary</option>
      <option value="IS">Iceland</option>
      <option value="IN">India</option>
      <option value="ID">Indonesia</option>
      <option value="IR">Iran, Islamic Republic of</option>
      <option value="IQ">Iraq</option>
      <option value="IE">Ireland</option>
      <option value="IM">Isle of Man</option>
      <option value="IL">Israel</option>
      <option value="IT">Italy</option>
      <option value="JM">Jamaica</option>
      <option value="JP">Japan</option>
      <option value="JE">Jersey</option>
      <option value="JO">Jordan</option>
      <option value="KZ">Kazakhstan</option>
      <option value="KE">Kenya</option>
      <option value="KI">Kiribati</option>
      <option value="KP">Korea, Democratic People's Republic of</option>
      <option value="KR">Korea, Republic of</option>
      <option value="KW">Kuwait</option>
      <option value="KG">Kyrgyzstan</option>
      <option value="LA">Lao People's Democratic Republic</option>
      <option value="LV">Latvia</option>
      <option value="LB">Lebanon</option>
      <option value="LS">Lesotho</option>
      <option value="LR">Liberia</option>
      <option value="LY">Libya</option>
      <option value="LI">Liechtenstein</option>
      <option value="LT">Lithuania</option>
      <option value="LU">Luxembourg</option>
      <option value="MO">Macao</option>
      <option value="MK">Macedonia, the former Yugoslav Republic of</option>
      <option value="MG">Madagascar</option>
      <option value="MW">Malawi</option>
      <option value="MY">Malaysia</option>
      <option value="MV">Maldives</option>
      <option value="ML">Mali</option>
      <option value="MT">Malta</option>
      <option value="MH">Marshall Islands</option>
      <option value="MQ">Martinique</option>
      <option value="MR">Mauritania</option>
      <option value="MU">Mauritius</option>
      <option value="YT">Mayotte</option>
      <option value="MX">Mexico</option>
      <option value="FM">Micronesia, Federated States of</option>
      <option value="MD">Moldova, Republic of</option>
      <option value="MC">Monaco</option>
      <option value="MN">Mongolia</option>
      <option value="ME">Montenegro</option>
      <option value="MS">Montserrat</option>
      <option value="MA">Morocco</option>
      <option value="MZ">Mozambique</option>
      <option value="MM">Myanmar</option>
      <option value="NA">Namibia</option>
      <option value="NR">Nauru</option>
      <option value="NP">Nepal</option>
      <option value="NL">Netherlands</option>
      <option value="NC">New Caledonia</option>
      <option value="NZ">New Zealand</option>
      <option value="NI">Nicaragua</option>
      <option value="NE">Niger</option>
      <option value="NG">Nigeria</option>
      <option value="NU">Niue</option>
      <option value="NF">Norfolk Island</option>
      <option value="MP">Northern Mariana Islands</option>
      <option value="NO">Norway</option>
      <option value="OM">Oman</option>
      <option value="PK">Pakistan</option>
      <option value="PW">Palau</option>
      <option value="PS">Palestinian Territory, Occupied</option>
      <option value="PA">Panama</option>
      <option value="PG">Papua New Guinea</option>
      <option value="PY">Paraguay</option>
      <option value="PE">Peru</option>
      <option value="PH">Philippines</option>
      <option value="PN">Pitcairn</option>
      <option value="PL">Poland</option>
      <option value="PT">Portugal</option>
      <option value="PR">Puerto Rico</option>
      <option value="QA">Qatar</option>
      <option value="RE">Réunion</option>
      <option value="RO">Romania</option>
      <option value="RU">Russian Federation</option>
      <option value="RW">Rwanda</option>
      <option value="BL">Saint Barthélemy</option>
      <option value="SH">Saint Helena, Ascension and Tristan da Cunha</option>
      <option value="KN">Saint Kitts and Nevis</option>
      <option value="LC">Saint Lucia</option>
      <option value="MF">Saint Martin (French part)</option>
      <option value="PM">Saint Pierre and Miquelon</option>
      <option value="VC">Saint Vincent and the Grenadines</option>
      <option value="WS">Samoa</option>
      <option value="SM">San Marino</option>
      <option value="ST">Sao Tome and Principe</option>
      <option value="SA">Saudi Arabia</option>
      <option value="SN">Senegal</option>
      <option value="RS">Serbia</option>
      <option value="SC">Seychelles</option>
      <option value="SL">Sierra Leone</option>
      <option value="SG">Singapore</option>
      <option value="SX">Sint Maarten (Dutch part)</option>
      <option value="SK">Slovakia</option>
      <option value="SI">Slovenia</option>
      <option value="SB">Solomon Islands</option>
      <option value="SO">Somalia</option>
      <option value="ZA">South Africa</option>
      <option value="GS">South Georgia and the South Sandwich Islands</option>
      <option value="SS">South Sudan</option>
      <option value="ES">Spain</option>
      <option value="LK">Sri Lanka</option>
      <option value="SD">Sudan</option>
      <option value="SR">Suriname</option>
      <option value="SJ">Svalbard and Jan Mayen</option>
      <option value="SZ">Swaziland</option>
      <option value="SE">Sweden</option>
      <option value="CH">Switzerland</option>
      <option value="SY">Syrian Arab Republic</option>
      <option value="TW">Taiwan, Province of China</option>
      <option value="TJ">Tajikistan</option>
      <option value="TZ">Tanzania, United Republic of</option>
      <option value="TH">Thailand</option>
      <option value="TL">Timor-Leste</option>
      <option value="TG">Togo</option>
      <option value="TK">Tokelau</option>
      <option value="TO">Tonga</option>
      <option value="TT">Trinidad and Tobago</option>
      <option value="TN">Tunisia</option>
      <option value="TR">Turkey</option>
      <option value="TM">Turkmenistan</option>
      <option value="TC">Turks and Caicos Islands</option>
      <option value="TV">Tuvalu</option>
      <option value="UG">Uganda</option>
      <option value="UA">Ukraine</option>
      <option value="AE">United Arab Emirates</option>
      <option value="GB">United Kingdom</option>
      <option value="US">United States</option>
      <option value="UM">United States Minor Outlying Islands</option>
      <option value="UY">Uruguay</option>
      <option value="UZ">Uzbekistan</option>
      <option value="VU">Vanuatu</option>
      <option value="VE">Venezuela, Bolivarian Republic of</option>
      <option value="VN">Viet Nam</option>
      <option value="VG">Virgin Islands, British</option>
      <option value="VI">Virgin Islands, U.S.</option>
      <option value="WF">Wallis and Futuna</option>
      <option value="EH">Western Sahara</option>
      <option value="YE">Yemen</option>
      <option value="ZM">Zambia</option>
      <option value="ZW">Zimbabwe</option>
    </select>
  </div>
</div>
```

### Sticky Content
Sticky content attaches itself to the viewport when it is passed, and remains fixed to the viewport until this fixed content collides with the bottom edge of the passed context. Additional static content can exist above sticky content without affecting its position.
```
<div class="ui sticky" style="background:#444;color:#fff;padding: 20px;margin-bottom:30px;">
  <h3>Sticky Banner</h3>
  <p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.</p>
</div>

$('.ui.sticky').sticky({
  context: '#content'
});
```

### Tabs
The tabs are currently only available in the WYSIWYG, but support for quicktabs will be implemented in the future.

```
<div class="ui top attached tabular menu">
    <a class="active item" data-tab="first">First</a> <a class="item" data-tab="second">Second</a>
    <a class="item" data-tab="third">Third</a>
</div>
<div class="ui bottom attached active tab segment" data-tab="first">First</div>
<div class="ui bottom attached tab segment" data-tab="second">Second</div>
<div class="ui bottom attached tab segment" data-tab="third">Third</div>
```

### Tooltips / Popups
```
<div class="ui icon button pop-up" data-title="Ze Title" data-content="Do Something">
  <i class="add icon">&nbsp;</i>
</div>
```
