<?php

namespace Drupal\environment_indicator\Form;

use Drupal\Core\Entity\EntityConfirmFormBase;
use Drupal\Core\Cache\Cache;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\Core\Url;

/**
 * Provides a deletion confirmation form for environment_indicator environment.
 */
class EnvironmentIndicatorDeleteForm extends EntityConfirmFormBase {

  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public function getFormID() {
    return 'environment_indicator_environment_confirm_delete';
  }

  /**
   * {@inheritdoc}
   */
  public function getQuestion() {
    return $this->t('Are you sure you want to delete the environment indicator %title?', ['%title' => $this->entity->label()]);
  }

  /**
   * {@inheritdoc}
   */
  public function getCancelUrl() {
    return new Url('aggregator.admin_overview');
  }

  /**
   * {@inheritdoc}
   */
  public function getDescription() {
    return $this->t('Deleting a environment will make disappear the indicator.');
  }

  /**
   * {@inheritdoc}
   */
  public function getConfirmText() {
    return $this->t('Delete');
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->entity->delete();
    drupal_set_message($this->t('Deleted environment %name.', ['%name' => $this->entity->label()]));
    // TODO: Figure out how to log stuff to the watchdog.
    // watchdog('environment', 'Deleted environment %name.', ['%name' => $this->entity->label()), WATCHDOG_NOTICE);
    $form_state['redirect'] = 'admin/config/development/environment-indicator';
    Cache::invalidateTags(['content' => TRUE]);
  }

}
