# Bear Skin 8

Bear Skin is the default theme for the [Bear](https://github.com/zivtech/bear) profile, which is a Drupal starter kit installation profile that can be used for building a new Drupal site. Bear Skin does not rely on the profile. Therefore, it **can be used as a standalone [starter theme](https://www.drupal.org/node/323993)**.

## Getting started

Before getting started, make sure that you have the latest version of node.js and [yeoman](http://yeoman.io/) installed. It is preferred to install node via [n](https://www.npmjs.com/package/n) using `curl -L http://git.io/n-install | bash`.  

Also, you will need to have [composer](https://getcomposer.org/doc/00-intro.md) installed. On a Mac, this is easiest with [homebrew](http://brew.sh/).

Bear Skin needs the [**Components Libraries**](https://www.drupal.org/project/components) module to run. You must install it prior to enabling the theme. Additionally, you will need to enable both the **search** and **responsive image** modules (these two ship with core but need to be enabled) before installing the theme.

When ready to work, refer to [Gulp tasks for front-end development](docs/gulp.md) to get started.

## Documentation

1. [Enabling dev mode](docs/dev_mode.md) in Drupal 8 to provide template suggestions and disabling the cache
1. [Gulp tasks for front-end development](docs/gulp.md)
    - [Building CSS](docs/gulp.md#building-css)
    - [Adding Google Fonts](docs/gulp.md#adding-google-fonts)
    - [Generating fav/app icons](docs/gulp.md#generating-favicons)
    - [Visual regression testing](docs/gulp.md#visual-regression-testing)
1. [Renaming the theme files and its functions](docs/rename.md)
1. [Using Pattern Lab](docs/pattern_lab.md)
    - [Generate Pattern Lab files](docs/pattern_lab.md#generate-pattern-lab-files)
    - [Watching Pattern Lab](docs/pattern_lab.md#watching-pattern-lab)
    - [Generate a new pattern](docs/pattern_lab.md#generate-a-pattern)
1. [Inheritance in Pattern Lab](docs/pattern_lab_inheritance.md) (this applies to inheritance in Twig too)
1. [Bower for front-end plugins](docs/bower.md)
    - [Serving location of Bower files](docs/bower.md#serving-location-of-bower-files)
    - [Forcing usage of specific files from Bower](docs/bower.md#forcing-usage-of-specific-files-from-bower)
1. [Using Probo.CI](docs/probo.md)
    - [Linting with Probo](docs/probo.md#linting-with-probo)
1. [Sass Structure](docs/sass.md)

* * *

### D8AX/#DAX - We pledge to make this theme as accessible as it can be. If you find any flaws, please submit an issue. Help us fix them if you can.
