<?php
/**
 * @file
 * Default theme implementation to wrap menu blocks.
 *
 * Available variables:
 * - $content: The renderable array containing the menu.
 * - $classes: A string containing the CSS classes for the DIV tag. Includes:
 *   menu-block-DELTA, menu-name-NAME, parent-mlid-MLID, and menu-level-LEVEL.
 * - $classes_array: An array containing each of the CSS classes.
 *
 * The following variables are provided for contextual information.
 * - $delta: (string) The menu_block's block delta.
 * - $config: An array of the block's configuration settings. Includes
 *   menu_name, parent_mlid, title_link, admin_title, level, follow, depth,
 *   expanded, and sort.
 *
 * @see template_preprocess_menu_block_wrapper()
 */
?>
<nav class="<?php print $classes; ?>" aria-labelledby="mainMenuLabel" tabindex="-1" role="navigation">
  <?php // provide mainMenuLabel here for WAI accessibility ?>
  <h3 class="u-hidden" id="mainMenuLabel"><?php print t('Main Navigation Menu:')?></h3>
  <?php print render($content); ?>
</nav>
