<?php

namespace Drupal\bee\Resolvers;

use Drupal\commerce\Context;
use Drupal\commerce\PurchasableEntityInterface;
use Drupal\commerce_price\Resolver\PriceResolverInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Resolve price for BEE nodes.
 *
 * @package Drupal\bee\Resolvers
 */
class SalepriceResolver implements PriceResolverInterface {

  /**
   * The cart provider.
   *
   * @var \Drupal\commerce_cart\CartProviderInterface
   */
  protected $cartProvider;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    $instance->cartProvider = $container->get('commerce_cart.cart_provider');
    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function resolve(PurchasableEntityInterface $entity, $quantity, Context $context) {

    if ($entity->bundle() != 'bee') {
      return;
    }

    $store = $context->getStore();

    /*
     * if ($cart = $this->cartProvider->getCart('default', $store)) {
     */
    if ($cart = $this->cartProvider->getCart('default', $store)) {
      $order_items = $cart->getItems();
      foreach ($order_items as $order_item) {
        if ($order_item->bundle() == 'bee') {
          return $order_item->getUnitPrice();
        }
      }
    }
  }

}
