<?php

namespace Drupal\beehotel_pricealterator\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure GetSeason Alterator.
 */
class GetSeason extends ConfigFormBase {

  /**
   * Reference to the Alterator (as plugin).
   *
   *   This value matches the ID in the @PriceAlterator annotation.
   */
  public function pluginId() {
    return 'GetSeason';
  }

  /**
   * {@inheritdoc}
   */
  public function configName() {
    return BEEHOTEL_PRICEALTERATOR_ROUTE_BASE . $this->pluginId() . '.settings';
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return $this->configName();
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      $this->configName(),
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {

    $config = $this->config($this->configName());

    $tmp = $this->t("This Alterator is the first at the bottom of the altertion pile");

    $form = [
      '#type' => 'fieldset',
      '#title' => $this->t('Get Season alterator'),
      '#collapsible' => TRUE,
      '#prefix' => $tmp,
    ];

    $form['status'] = [
      '#default_value' => $config->get('status'),
      '#type' => 'checkbox',
      '#title' => $this->t('Enable this alterator'),
      '#description' => $this->t('This altertor is mandatory'),
    ];

    $form['#suffix'] = "This Alterator is set up via coding.";

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
  }

}
