<?php

namespace Drupal\beehotel_pricealterators\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure GlobalSlider Alterator.
 */
class GlobalSlider extends ConfigFormBase {

  /**
   * Reference to the Alterator (as plugin).
   *
   *   This value matches the ID in the @PriceAlterator annotation.
   */
  public function pluginId() {
    return 'GlobalSlider';
  }

  /**
   * {@inheritdoc}
   */
  public function configName() {
    return BEEHOTEL_PRICEALTERATOR_ROUTE_BASE . $this->pluginId() . '.settings';
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return $this->configName();
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      $this->configName(),
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {

    $config = $this->config($this->configName());

    $tmp = $this->t("This Alterator works on every price of every Bee Hotel Unit.");
    $tmp .= " " . $this->t("Leave this value to 0 and set up other alterators firts.");
    $tmp .= " " . $this->t("Once you are happy with your alterator chain set
    up, give a value to this global alterator.");

    $form = [
      '#type' => 'fieldset',
      '#title' => $this->t('Global Slider alterator'),
      '#collapsible' => TRUE,
      '#prefix' => $tmp,
    ];

    $form['status'] = [
      '#default_value' => $config->get('status'),
      '#type' => 'checkbox',
      '#title' => $this->t('Enable this alterator'),
      '#description' => $this->t('When on, this alterator will be applied the BEEHotel prices'),
    ];

    $tmp = $this->t("Price will be altered as per percentage value");
    $tmp .= "<br/>" . $this->t("price + (price / 100 * global slice) = Altered price");
    $tmp .= "<br/>" . $this->t("IE: 200 + (200 / 100 * 20) = 240");

    $form['globalslider'] = [
      '#default_value' => $config->get('globalslider'),
      '#type' => 'range_slider',
      '#title' => 'Global Slider',
      '#min' => -100,
      '#max' => 100,
      '#step' => 1,
      '#description' => $tmp,
      '#data-orientation' => 'horizontal',
      '#output' => 'below',
      '#output__field_prefix' => '',
      '#output__field_suffix' => '%',
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config($this->configName())
      ->set('status', $form_state->getValue('status'))
      ->set('globalslider', $form_state->getValue('globalslider'))
      ->save();
    parent::submitForm($form, $form_state);
  }

}
