<?php

namespace Drupal\beehotel_pricealterators\Form;

use Drupal\Core\Config\ConfigFactory;
use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Configure Occupants Alterator.
 */
class Occupants extends ConfigFormBase {

  /**
   * Drupal configuration service container.
   *
   * @var \Drupal\Core\Config\ConfigFactory
   */
  protected $configFactory;

  /**
   * Constructs a new Occupants alterator object.
   */
  public function __construct(ConfigFactory $config_factory) {
    $this->configFactory = $config_factory;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('config.factory'),
    );
  }

  /**
   * Reference to the Alterator (as plugin).
   *
   *   This value matches the ID in the @PriceAlterator annotation.
   */
  public function pluginId() {
    return 'Occupants';
  }

  /**
   * {@inheritdoc}
   */
  public function configName() {
    return BEEHOTEL_PRICEALTERATOR_ROUTE_BASE . $this->pluginId() . '.settings';
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return $this->configName();
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      $this->configName(),
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {

    $config = $this->configFactory->get($this->configName());

    $form = [
      '#type' => 'fieldset',
      '#title' => $this->t('Occupants alterator'),
      '#collapsible' => FALSE,
    ];

    $form['status'] = [
      '#default_value' => $config->get('status'),
      '#type' => 'checkbox',
      '#title' => $this->t('Enable this alterator'),
      '#description' => $this->t('When on, this alterator will be applied the BEEHotel prices'),
    ];

    for ($i = 1; $i <= 6; $i++) {
      $title = $this->formatPlural($i, '1 occupant.', '@count occupants.');
      $description = $this->formatPlural($i, 'Percentage alteration for 1 occupant.', 'Percentage alteration for @count occupants.');

      $form['increase'][$i] = [
        '#default_value' => $config->get('increase_' . $i),
        '#type' => 'range_slider',
        '#title' => $title,
        '#min' => -100,
        '#max' => 100,
        '#step' => 1,
        '#description' => $description,
        '#data-orientation' => 'horizontal',
        '#output' => 'below',
        '#output__field_prefix' => '',
        '#output__field_suffix' => '%',
      ];
    }
    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {

    $config = $this->configFactory->getEditable($this->configName());

    // @todo loop by the max Guests attribute
    $config
      ->set('status', $form_state->getValue('status'))
      ->set('increase_1', $form_state->getValue('1'))
      ->set('increase_2', $form_state->getValue('2'))
      ->set('increase_3', $form_state->getValue('3'))
      ->set('increase_4', $form_state->getValue('4'))
      ->set('increase_5', $form_state->getValue('5'))
      ->set('increase_6', $form_state->getValue('6'))
      ->save();
    parent::submitForm($form, $form_state);
  }

}
