<?php

namespace Drupal\bee_hotel\Util;

use Drupal\Core\Entity\EntityTypeManagerInterface;

/**
 * Commerce related utils for BeeHotel.
 */
class BeeHotelCommerce {

  /**
   * The store storage.
   *
   * @var \Drupal\commerce_store\StoreStorageInterface
   */
  protected $storeStorage;

  /**
   * The currency storage.
   *
   * @var \Drupal\commerce_currency\CurrencyStorageInterface
   */
  protected $currencyStorage;

  /**
   * Constructs a new CookieStoreResolver object.
   *
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entity_type_manager
   *   The entity type manager.
   */
  public function __construct(EntityTypeManagerInterface $entity_type_manager) {
    $this->storeStorage = $entity_type_manager->getStorage('commerce_store');
    $this->currencyStorage = $entity_type_manager->getStorage('commerce_currency');
  }

  /**
   * Get currency from current store.
   */
  public function currentStoreCurrency() {
    $store = $this->storeStorage->loadDefault();
    $currency_code = $store->get('default_currency')->getValue()[0]['target_id'];
    $currency = $this->currencyStorage->load($currency_code);
    return $currency;
  }

}
