<?php

namespace Drupal\beehotel_pricealterator\Plugin\Block;

use Drupal\Core\Block\BlockBase;

/**
 * Provides a 'Price Alterator Log' Block.
 *
 * @Block(
 *   id = "price_alterator_debug_block",
 *   admin_label = @Translation("price alterator debug block"),
 *   category = @Translation("price_alterator_debug_block"),
 * )
 */
class PriceAlteratorDebugBlock extends BlockBase {

  /**
   * The tempstore factory.
   *
   * @var \Drupal\Core\TempStore\PrivateTempStoreFactory
   */
  protected $tempStoreFactory;

  /**
   * Alter constructor.
   *
   * @param \Drupal\Core\TempStore\PrivateTempStoreFactory $temp_store_factory
   *   The tempstore factory.
   */
  public function __construct(PrivateTempStoreFactory $temp_store_factory) {
    $this->tempStoreFactory = $temp_store_factory;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('tempstore.private'),
    );
  }

  /**
   * {@inheritdoc}
   */
  public function build() {

    $tempstore = $this->tempStoreFactory->get('beehotel_pricealterator');
    $output = "";

    $output .= date_create()->format('Uv') . " ";
    $output .= "beehotel_pricealterator_class" .
                  $tempstore->get('beehotel_pricealterator_class') . "<br>";
    return [
      '#markup' => $output,
    ];
  }

}
