<?php

namespace Drupal\beehotel_pricealterator;

use Drupal\Core\Config\ConfigFactory;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\Plugin\PluginBase;
use Drupal\Core\Plugin\PluginWithFormsTrait;
use Drupal\datetime\Plugin\Field\FieldType\DateTimeItemInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides the base class for payment gateways.
 */
class PriceAlteratorBase extends PluginBase implements PriceAlteratorInterface, ContainerFactoryPluginInterface {

  use PluginWithFormsTrait;

  /**
   * The entity type manager.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected $entityTypeManager;

  /**
   * The BeeHotel commerce Util.
   *
   * @var \Drupal\bee_hotel\Util\BeeHotelCommerce
   */
  protected $beehotelCommerce;

  /**
   * Constructs a new Occupants alterator object.
   */
  public function __construct(ConfigFactory $config_factory) {
    $this->configFactory = $config_factory;
  }

  /**
   * Creates an instance of the plugin.
   *
   * @param \Symfony\Component\DependencyInjection\ContainerInterface $container
   *   The container to pull out services used in the plugin.
   * @param array $configuration
   *   A configuration array containing information about the plugin instance.
   * @param string $plugin_id
   *   The plugin ID for the plugin instance.
   * @param mixed $plugin_definition
   *   The plugin implementation definition.
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {}

  /**
   * {@inheritdoc}
   */
  public function configName() {
    return BEEHOTEL_PRICEALTERATOR_ROUTE_BASE . $this->pluginId() . '.settings';
  }

  /**
   * {@inheritdoc}
   */
  public function alter(array $data, array $pricetable) {}

  /**
   * {@inheritdoc}
   */
  public function description() {
    // Retrieve the @description property from the annotation and return it.
    return $this->pluginDefinition['description'];
  }

  /**
   * {@inheritdoc}
   */
  public function status() {
    // Retrieve the @status property from the annotation and return it.
    return $this->pluginDefinition['status'];
  }

  /**
   * {@inheritdoc}
   */
  public function weight() {
    // Retrieve the @weight property from the annotation and return it.
    return $this->pluginDefinition['weight'];
  }

  /**
   * {@inheritdoc}
   */
  public function polarity($value) {
    if ($value > 0) {
      $polarity = "add";
    }
    elseif ($value < 0) {
      $polarity = "sub";
    }
    else {
      $polarity = NULL;
    }
    return $polarity;
  }

  /**
   * Is this alterator enabled by user?
   */
  public function enabled($value) {
    $config = \Drupal::config($this->configName());
    return $config->get("enabled");
  }

  /**
   * Get alterator weight given by user.
   */
  public function getUserWeight() {
    $config = \Drupal::config('beehotel_pricealterator.settings')->get("price_alterators");
    $user_weight = isset($config) ?? $config[$this->pluginId() . '_weight'] :: NULL;
    return (int) $user_weight;
  }

  /**
   * {@inheritdoc}
   */
  protected function getTimezone() {
    return DateTimeItemInterface::STORAGE_TIMEZONE;
  }

  /**
   * {@inheritdoc}
   */
  protected function getTimestorage() {
    return DateTimeItemInterface::DATE_STORAGE_FORMAT;
  }

}
