<?php

namespace Drupal\beehotel_pricealterator\Plugin\Block;

use Drupal\Core\Block\BlockBase;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\Session\Session;

/**
 * Provides a 'Debug block for price alteration' block.
 *
 * @Block(
 * id = "price_alterator_debug_block",
 * admin_label = @Translation("price alterator debug block"),
 * category = @Translation("price_alterator_debug_block"),
 * )
 */
class PriceAlteratorDebugBlock extends BlockBase implements ContainerFactoryPluginInterface {

  /**
   * The account object.
   *
   * @var Drupal\Core\Session\AccountProxyInterface
   */
  protected $account;

  /**
   * The session.
   *
   * @var \Symfony\Component\HttpFoundation\Session\Session
   */
  protected $session;

  /**
   * A create method.
   *
   * @param \Symfony\Component\DependencyInjection\ContainerInterface $container
   *   The container interface.
   * @param array $configuration
   *   A configuration array.
   * @param string $plugin_id
   *   The plugin id.
   * @param mixed $plugin_definition
   *   The plugin definition.
   *
   * @return static
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      // $container->get('current_user'),
      $container->get('session'),
    );
  }

  /**
   * The __construct method.
   *
   * @param array $configuration
   *   The configuration array.
   * @param string $plugin_id
   *   The plugin id.
   * @param mixed $plugin_definition
   *   The plugin definition.
   * @param \Symfony\Component\HttpFoundation\Session\Session $session
   *   The session.
   */
  public function __construct(
    array $configuration,
    $plugin_id,
    $plugin_definition,
    Session $session,
  ) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    $this->session = $session;
  }

  /**
   * {@inheritdoc}
   *
   * The return value of the build() method is a renderable array. Returning an
   * empty array will result in empty block contents. The front end will not
   * display empty blocks.
   */
  public function build() {

    $output = "";
    $data = [];
    $data['alterators_current_stack'] = $this->session->get('alterators_current_stack');
    $path = \Drupal::service('path.current')->getPath();
    $data['path']['pieces'] = explode("/", $path);

    if ($data['path']['pieces'][1] != 'cart') {
      return;
    }

    if (!isset($data['alterators_current_stack'])) {
      return;
    }

    $chain = "";
    $output .= "<ul>";
    $prev = NULL;
    foreach ($data['alterators_current_stack'] as $item) {
      if ($item['id'] == "GetSeason") {
        $chain .= "<li> <b>Season:</b> : " . $item['season'];
      }
      else {
        $chain .= "<li><b>" . $item['id'] . "</b>: " . number_format($item['price'], 2);

        if (isset($prev)) {

          $class = $sign = "";
          $diff = $item['price'] - $prev;

          if ($diff < 0) {
            $sign = "-";
            $class = "subtract bold smaller";
            $value = $sign . number_format($diff, 2);
          }
          elseif ($diff > 0) {
            $class = "add bold smaller";
            $sign = "+";
            $value = $sign . number_format($diff, 2);
          }
          else {
            $diff = "0";
            $class = "grey bold smaller";
            $value = $this->t("-");
          }
          $chain .= "<span class='" . $class . "'> (" . $value . ")</span>";
        }
      }

      $prev = $item['price'];
    }
    $chain .= "</ul>";

    $output = [
      '#prefix' => "<div class='price-alterators-chain'>",
      '#type' => 'details',
      '#title' => $this->t("Alterator's chain"),
      '#description' => $chain,
      '#suffix' => "</div>",
    ];
    return $output;
  }

  /**
   * {@inheritdoc}
   */
  public function getCacheMaxAge() {
    return 0;
  }

}
