(function (Drupal, drupalSettings) {
  Drupal.behaviors.beehotel_pricealterator = {
    attach: function (context, drupalSettings) {
      once('div', 'html', context).forEach(function (context) {

      window.onload = function(){
        google.charts.load("current", {packages:["corechart"]});
        google.charts.setOnLoadCallback(drawChart);
      };

      function drawChart() {
        var rows = [];
        rows.push(['Altertor', 'Price']);
        for (var k = 1; k < drupalSettings.beehotel_pricealterator.alterators.length; k++) {
          var diff = (drupalSettings.beehotel_pricealterator.alterators[k].price - drupalSettings.beehotel_pricealterator.alterators[k - 1].price);
          if (diff > 0) {
            var string = parseFloat(diff).toFixed(2).toString(0);
            var label = drupalSettings.beehotel_pricealterator.alterators[k].id.substring(0, 24) + " (" + string + ")";
            //In pies, price is the difference.
            var int = parseInt(drupalSettings.beehotel_pricealterator.alterators[k].price, 10);
            var tmp = [label, diff];
            rows.push(tmp);
          }
        }
        var data = google.visualization.arrayToDataTable(rows);
        var options = {
          title: 'Price Alteration',
          is3D: true,
        };
        var chart = new google.visualization.PieChart(document.getElementById('chain-chart'));
        chart.draw(data, options);
      }

    });
    }
  }
}
(Drupal, drupalSettings));
