module.exports = function(grunt) {
// 1. All configuration goes here 
grunt.initConfig({
  pkg: grunt.file.readJSON('package.json'),
  sass: {
    dist: {
      options: {
        loadPath: require('node-bourbon').includePaths,
        style: 'indented'
      },
      files: {
        'css/main.css': 'scss/main.scss'
      }
    }
  },
  watch: {
    src: {
      files: ['scss/**/*.scss'],
      tasks: ['sass'],
      sourcemap: true
    },
  }
});
// 3. Where we tell Grunt we plan to use this plug-in.
grunt.loadNpmTasks('grunt-contrib-sass');
grunt.loadNpmTasks('grunt-contrib-watch');
// 4. Where we tell Grunt what to do when we type "grunt" into the terminal.
grunt.registerTask('default', ['sass', 'watch']);
//grunt.registerTask('default', ['sassWatch']);

};