/**
 * @file
 * bef-entity-select-buttons.js
 *
 * Additional js for button select links in exposed views forms.
 */
(({ behaviors }, once) => {

  const selector = '.bef-entity-select-buttons';

  /**
   * Remove the click events from all entity add buttons if ajax is enabled for
   * this view. With ajax enabled the button is interpreted as the select option
   * itself so the wrong behavior is fired.
   *
   * @type {{attach: Drupal.behaviors.BefButtonSelectRemoveAjaxFromAddEntity.attach}}
   */
  behaviors.BefEntityButtonSelectRemoveAjax = {
    attach: context => {
      once('remove-ajax', `${selector} .bef-links-use-ajax`, context).forEach(element => {
        element.querySelectorAll(`${selector}__add-entity-button`).forEach(link => {
          // Replace the dom element with itself to delete all click events.
          // https://stackoverflow.com/a/4386514
          link.replaceWith(link.cloneNode(true));
        })
      });
    }
  }

})(Drupal, window.once);
