<?php

namespace Drupal\bef_entity_select_buttons\Plugin\better_exposed_filters\filter;

use Drupal\better_exposed_filters\Annotation\BetterExposedFiltersFilterWidget;
use Drupal\better_exposed_filters\Plugin\better_exposed_filters\filter\Links;
use Drupal\Core\Form\FormStateInterface;

/**
 * Default widget implementation.
 *
 * @BetterExposedFiltersFilterWidget(
 *   id = "bef_entity_select_buttons",
 *   label = @Translation("BEF entity select buttons"),
 * )
 */
class EntitySelectButtons extends Links {

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration(): array {
    return parent::defaultConfiguration() + [
        'display_full_width' => TRUE,
        'display_flex' => FALSE,
        'small_buttons' => FALSE,
        'button_size' => 'default',
        'button_style' => 'default',
        'entity_add_button' => TRUE,
        'entity_type_icon' => TRUE,
        'restrained_buttons' => FALSE,
      ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state): array {
    $form = parent::buildConfigurationForm($form, $form_state);

    $form['display_full_width'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Show as block element in full width'),
      // Als Block Element in voller Breite anzeigen
      '#description' => $this->t('No longer display the element in a line with other elements, but display it across the entire available width. Previous or following elements are then located above or below the element.'),
      // Element nicht mehr mit anderen Elementen in einer Zeile darstellen, sondern über die komplette verfügbare Breite anzeigen. Vorherige oder Folgende Elemente befinden sich dann über oder unter dem Element.
      '#default_value' => $this->configuration['display_full_width'],
    ];

    $form['display_flex'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Align buttons in flex instead of grid'),
      '#description' => $this->t(''),
      '#default_value' => $this->configuration['display_flex'],
    ];

    $form['small_buttons'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Display small buttons'),
      '#description' => $this->t(''),
      '#default_value' => $this->configuration['small_buttons'],
    ];

    $form['entity_add_button'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Add entity type'),
      '#default_value' => $this->configuration['entity_add_button'],
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function exposedFormAlter(array &$form, FormStateInterface $form_state): void {
    parent::exposedFormAlter($form, $form_state);

    $configs = $this->getConfiguration();
    $field_id = $this->getExposedFilterFieldId();

    $entity_type = $this->handler->getEntityType();
    $component_class = 'bef-entity-select-buttons';

    $form[$field_id]['#wrapper_attributes']['class'] ??= [];
    $form[$field_id]['#wrapper_attributes']['class'] += [
      $component_class,
      $configs['display_full_width'] ? "$component_class--full-width" : null,
      $configs['display_flex'] ? "$component_class--flex" : "$component_class--grid",
    ];

    $form[$field_id]['#theme'] = 'bef_entity_select_buttons';
    $form[$field_id]['#button_small'] = $configs['small_buttons'];
    $form[$field_id]['#entity_type'] = $configs['entity_add_button'] ? $entity_type : null;
  }
}
