/**
 * @file
 * filter.js
 *
 * Allows Better Exposed Filters links to themselves be filtered.
 *
 * @TODO get rid of JQuery but really no point in doing that until
 */

(function ($, once) {

  Drupal.behaviors.bef_links_filter = {
    attach: function (context) {
      $(once('bef-links-filter', '.bef-links-filter', context)).each(function () {
        const links = $(this).find('ul li');
        const input = $(this).find('.bef-links-filter-input')[0];
        input.addEventListener("keyup", (event) => {
          filter = input.value.toLowerCase();
          for (i = 0; i < links.length; i++) {
            a = links[i].getElementsByTagName("a")[0];
            txt = a.textContent || a.innerText;
            if (txt.toLowerCase().indexOf(filter) > -1) {
              links[i].style.display = "";
            } else {
              links[i].style.display = "none";
            }
          }
        });
      });

      $(once('bef-links-filter-show', '.bef-links-filter-hide-extras', context)).each(function () {
        $(this).addClass('blf-hide-extra');
        const show_link = $(this).find('.blf-show-link')[0];
        const hide_link = $(this).find('.blf-hide-link')[0];
        show_link.addEventListener("click", (event) => {
          event.preventDefault();
          event.stopPropagation();
          $(this).removeClass('blf-hide-extra');
          $(this).addClass('blf-show-hide-link');
        });
        hide_link.addEventListener("click", (event) => {
          event.preventDefault();
          event.stopPropagation();
          $(this).addClass('blf-hide-extra');
          $(this).removeClass('blf-show-hide-link');
        });
      });
    }
  };
})(jQuery, once);
