<?php

/**
 * @file
 * Provides the admin callback functionalities
 */

/**
 * Callbacks for the admin settings
 */
function beididp_checkrole_admin() {
  $form['#tree'] = TRUE;

  $form['beididp_required_for_role'] = array(
    '#type' => 'fieldset',
    '#title' => t('Roles that require eID authentication'),
    '#description' => t('Check all roles that require eID authentication. Users that are in one or more of the checked roles must login via eID.'),
    '#collapsible' => TRUE,
    '#collapsed' => FALSE,
    '#weight' => 0,
  );

  // Don't include Drupal's anonymous role.
  $roles = user_roles(TRUE);
  $required = variable_get('beididp_required_for_role', array());

  foreach ($roles as $rid => $name) {
    $form['beididp_required_for_role'][$rid] = array(
      '#type' => 'checkbox',
      '#title' => t(check_plain($name)),
      '#default_value' => !empty($required[$rid]),
    );
  }

  return system_settings_form($form);
}
