<?php
/**
 * @file
 * Provides the admin callback functionalities
 */

/**
 * Callbacks for the admin settings
 */
function beididp_profile_admin() {
  $form['attr'] = array(
    '#type' => 'fieldset',
    '#title' => t('Map eID attributes to Drupal profile fields'),
    '#collapsible' => TRUE,
    '#collapsed' => FALSE,
    '#weight' => 0,
  );

  $result = db_query('SELECT name, title FROM {profile_fields} order by weight');
  $drupal_profiles = array('');
  while ($record = db_fetch_object($result)) {
    $name = check_plain($record->name);
    $title = check_plain($record->title);
    $drupal_profiles[$name] = t($title);
  }

  $profile_fields = beididp_profile_get_fields();
  foreach ($profile_fields as $item) {
    $form['attr']['beididp_profilemapping_' . $item] = array(
      '#type' => 'select',
      '#title' => check_plain($item),
      '#default_value' => variable_get('beididp_profilemapping_' . $item, ''),
      '#options' => $drupal_profiles,
    );
  }

  return system_settings_form($form);
}
