<?php
/**
 * @file
 * The beididp pages.inc file.
 *
 * This file provides callbacks for different pages used in the beididp module
 */

module_load_include('inc', 'beididp');

/**
 * Menu callback. Process an OpenID authentication.
 */
function beididp_authentication_page() {
  $result = beididp_complete();

  switch ($result['status']) {
    case 'success':
      return beididp_authentication($result);
    case 'failed':
      drupal_set_message(t('BeID login failed.'), 'error');
      break;

    case 'cancel':
      drupal_set_message(t('BeID login cancelled.'));
      break;
  }
  drupal_goto();
}


/**
 * Menu callback. Manage eID identities for the specified user.
 */
function beididp_eid_identities($account) {
  drupal_set_title(check_plain($account->name));

  // Check to see if we got a response.
  $result = beididp_complete();
  if ($result['status'] == 'success') {
    $identity = $result['openid.claimed_id'];

    if (db_result(db_query("SELECT 1 from {authmap} WHERE authname='%s' AND module='beididp'", $identity))) {
      drupal_set_message(t('That eID card is already in use on this site.'), 'error');
      watchdog('beididp', 'Could not add @identity for @user, already in use', array('@user' => $account->name, '@identity' => $identity), WATCHDOG_WARNING);
    }
    else {
      $record = array(
        'uid' => $account->uid,
        'authname' => $identity,
        'module' => 'beididp',
      );
      $ret = drupal_write_record('authmap', $record);

      if ($ret) {
        drupal_set_message(t('Successfully added @identity', array('@identity' => $identity)));
      }
      else {
        drupal_set_message(t('Error adding @identity', array('@identity' => $identity)), 'error');
      }
    }
  }

  $header = array(t('BeID identity'), t('Operations'));
  $rows = array();

  $result = beididp_get_eid($account->uid);
  while ($identity = db_fetch_object($result)) {
    $rows[] = array(
      check_plain($identity->authname),
      l(t('Delete'), 'user/' . $account->uid . '/beididp/delete/' . $identity->aid),
    );
  }

  $output = theme('table', $header, $rows);
  if (empty($rows)) {
    $output .= drupal_get_form('beididp_eid_add_form');
  }
  return $output;
}

/**
 * Form constructor for adding eID identities to an account.
 *
 * @see beididp_eid_add_form_submit()
 * @ingroup forms
 */
function beididp_eid_add_form() {
  $form['beid'] = array(
    '#name' => 'beid',
    '#type' => 'submit',
    '#value' => t('Add a BeID identity'),
  );

  return $form;
}

/**
 * Form submission handler for beididp_eid_add_form().
 */
function beididp_eid_add_form_submit($form, &$form_state) {
  $return_to = url('user/' . arg(1) . '/beididp', array('absolute' => TRUE));
  beididp_begin($return_to);
}


/**
 * Form constructor for deleting an eID identity.
 *
 * @see beididp_eid_delete_form_submit()
 * @ingroup forms
 */
function beididp_eid_delete_form($form_state, $account, $aid = 0) {
  $authname = db_result(db_query("SELECT authname FROM {authmap} WHERE uid = %d AND aid = %d AND module = 'beididp'", $account->uid, $aid));

  $form = array();

  $form['uid'] = array(
    '#type' => 'value',
    '#value' => $account->uid,
  );
  $form['aid'] = array(
    '#type' => 'value',
    '#value' => $aid,
  );

  return confirm_form($form, t('Are you sure you want to delete the BeID @authname for @user?', array('@authname' => $authname, '@user' => $account->name)), 'user/' . $account->uid . '/beididp');
}

/**
 * Form submission handler for beididp_eid_delete_form().
 */
function beididp_eid_delete_form_submit($form, &$form_state) {
  $uid = (int) $form_state['values']['uid'];
  $aid = (int) $form_state['values']['aid'];

  db_query("DELETE FROM {authmap} WHERE uid = %d AND aid = %d AND module = 'beididp'", $uid, $aid);
  if (db_affected_rows()) {
    drupal_set_message(t('BeID Identity deleted.'));
  }

  $form_state['redirect'] = 'user/' . $uid . '/beididp';
}
