<?php
/**
 * @file
 * Provides the admin page callback functionalities
 */

/**
 * Callback for the general settings
 */
function beididp_admin($form, &$form_state) {
  $form['standard'] = array(
    '#type' => 'fieldset',
    '#title' => t('Basic settings'),
    '#collapsible' => TRUE,
    '#collapsed' => FALSE,
  );

  $form['standard']['beididp_idp_url'] = array(
    '#type' => 'textfield',
    '#title' => t('eId Identity endpoint'),
    '#default_value' => variable_get('beididp_idp_url', 'https://www.e-contract.be/eid-idp/endpoints/openid/auth-ident'),
    '#size' => 100,
    '#maxlength' => 100,
    '#description' => t('The https URL to the OpenID endpoint of the Belgian eID Identity Provider'),
  );

  $form['standard']['beididp_no_mail_verify'] = array(
    '#type' => 'checkbox',
    '#title' => t('No email verification upon registration'),
    '#default_value' => variable_get('beididp_no_mail_verify', TRUE),
    '#description' => t('Override general email verifications when registering new user with eID-card'),
  );

  $form['secpriv'] = array(
    '#type' => 'fieldset',
    '#title' => t('Recommended privacy and security settings'),
    '#collapsible' => TRUE,
    '#collapsed' => FALSE,
  );

  $form['secpriv']['beididp_https_required'] = array(
    '#type' => 'checkbox',
    '#title' => t('Require HTTPS on eID login'),
    '#default_value' => variable_get('beididp_https_required', TRUE),
    '#description' => t('HTTPS must be activated to prevent cookie / session hijacking, either by always using HTTPS or by installing http://drupal.org/project/securepages_prevent_hijack.'),
  );

  $form['secpriv']['beididp_hash_claimed_id'] = array(
    '#type' => 'checkbox',
    '#title' => t('Apply hash function to OpenID Identity'),
    '#default_value' => variable_get('beididp_beididp_hash_claimed_id', TRUE),
    '#description' => t('Enable this option to hash the unique Rijksregister Nummer (part of the OpenID Identity) before storing it in the database.'),
  );

  return system_settings_form($form);
}


/**
 * Callback for the mail settings
 */
function beididp_admin_mail($form, &$form_state) {
  $form['register'] = array(
    '#type' => 'fieldset',
    '#title' => t('Registration mail - no admin approval'),
    '#description' => t('Alternative subject to use when user creates a new account via eID. The default confirmation mail that Drupal sends can be confusing, because it contains a username and a password. Leave these fields blank to have the mails sent normally.'),
    '#collapsible' => TRUE,
    '#collapsed' => FALSE,
  );

  $form['register']['beididp_register_no_approval_required_subject'] = array(
    '#type' => 'textfield',
    '#title' => t('Subject'),
    '#default_value' => variable_get('beididp_register_no_approval_required_subject', _user_mail_text('register_no_approval_required_subject')),
    '#size' => 100,
    '#maxlength' => 100,
  );

  $form['register']['beididp_register_no_approval_required_body'] = array(
    '#type' => 'textarea',
    '#title' => t('Body'),
    '#default_value' => variable_get('beididp_register_no_approval_required_body', _user_mail_text('register_no_approval_required_body')),
    '#rows' => 15,
  );

  $form['pending'] = array(
    '#type' => 'fieldset',
    '#title' => t('Registration mail - pending approval'),
    '#description' => t('Alternative subject to use when user creates a new account via eID. The default confirmation mail that Drupal sends can be confusing, because it contains a username and a password. Leave these fields blank to have the mails sent normally.'),
    '#collapsible' => TRUE,
    '#collapsed' => FALSE,
  );

  $form['pending']['beididp_register_pending_approval_subject'] = array(
    '#type' => 'textfield',
    '#title' => t('Subject'),
    '#default_value' => variable_get('beididp_register_pending_approval_subject', _user_mail_text('register_pending_approval_subject')),
    '#size' => 100,
    '#maxlength' => 100,
  );

  $form['pending']['beididp_register_pending_approval_body'] = array(
    '#type' => 'textarea',
    '#title' => t('Body'),
    '#default_value' => variable_get('beididp_register_pending_approval_body', _user_mail_text('register_pending_approval_body')),
    '#rows' => 15,
  );

  return system_settings_form($form);
}


/**
 * Form validator for beididp_admin().
 */
function beididp_admin_validate($form, &$form_state) {
  $idp = $form_state['values']['beididp_idp_url'];

  if (!valid_url($idp)) {
    form_set_error('beididp_idp_url', t('Please enter a valid URL'));
  }
  else {
    $url = parse_url($idp);
    if (!($url['scheme'] === 'https')) {
      form_set_error('beididp_idp_url', t('HTTPS required'));
    }
  }
}
